/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.ArrayList;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.Merger;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.ForwardingCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.kstream.internals.TupleForwarder;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;

class KStreamSessionWindowAggregate<K, V, T>
implements KStreamAggProcessorSupplier<K, Windowed<K>, V, T> {
    private final String storeName;
    private final SessionWindows windows;
    private final Initializer<T> initializer;
    private final Aggregator<? super K, ? super V, T> aggregator;
    private final Merger<? super K, T> sessionMerger;
    private boolean sendOldValues = false;

    KStreamSessionWindowAggregate(SessionWindows windows, String storeName, Initializer<T> initializer, Aggregator<? super K, ? super V, T> aggregator, Merger<? super K, T> sessionMerger) {
        this.windows = windows;
        this.storeName = storeName;
        this.initializer = initializer;
        this.aggregator = aggregator;
        this.sessionMerger = sessionMerger;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamSessionWindowAggregateProcessor();
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    private SessionWindow mergeSessionWindow(SessionWindow one, SessionWindow two) {
        long start = one.start() < two.start() ? one.start() : two.start();
        long end = one.end() > two.end() ? one.end() : two.end();
        return new SessionWindow(start, end);
    }

    @Override
    public KTableValueGetterSupplier<Windowed<K>, T> view() {
        return new KTableValueGetterSupplier<Windowed<K>, T>(){

            @Override
            public KTableValueGetter<Windowed<K>, T> get() {
                return new KTableSessionWindowValueGetter();
            }

            @Override
            public String[] storeNames() {
                return new String[]{KStreamSessionWindowAggregate.this.storeName};
            }
        };
    }

    private class KTableSessionWindowValueGetter
    implements KTableValueGetter<Windowed<K>, T> {
        private SessionStore<K, T> store;

        private KTableSessionWindowValueGetter() {
        }

        @Override
        public void init(ProcessorContext context) {
            this.store = (SessionStore)context.getStateStore(KStreamSessionWindowAggregate.this.storeName);
        }

        @Override
        public T get(Windowed<K> key) {
            try (KeyValueIterator iter = this.store.findSessions(key.key(), key.window().end(), key.window().end());){
                if (!iter.hasNext()) {
                    Object t = null;
                    return t;
                }
                Object value = ((KeyValue)iter.next()).value;
                if (iter.hasNext()) {
                    throw new ProcessorStateException(String.format("Iterator for key [%s] on session store has more than one value", key));
                }
                Object v = value;
                return v;
            }
        }
    }

    private class KStreamSessionWindowAggregateProcessor
    extends AbstractProcessor<K, V> {
        private SessionStore<K, T> store;
        private TupleForwarder<Windowed<K>, T> tupleForwarder;

        private KStreamSessionWindowAggregateProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.store = (SessionStore)context.getStateStore(KStreamSessionWindowAggregate.this.storeName);
            this.tupleForwarder = new TupleForwarder(this.store, context, new ForwardingCacheFlushListener(context, KStreamSessionWindowAggregate.this.sendOldValues), KStreamSessionWindowAggregate.this.sendOldValues);
        }

        @Override
        public void process(K key, V value) {
            SessionWindow newSessionWindow;
            if (key == null) {
                return;
            }
            long timestamp = this.context().timestamp();
            ArrayList<KeyValue> merged = new ArrayList<KeyValue>();
            SessionWindow mergedWindow = newSessionWindow = new SessionWindow(timestamp, timestamp);
            Object agg = KStreamSessionWindowAggregate.this.initializer.apply();
            KeyValueIterator iterator = this.store.findSessions(key, timestamp - KStreamSessionWindowAggregate.this.windows.inactivityGap(), timestamp + KStreamSessionWindowAggregate.this.windows.inactivityGap());
            Object object = null;
            try {
                while (iterator.hasNext()) {
                    KeyValue next = (KeyValue)iterator.next();
                    merged.add(next);
                    agg = KStreamSessionWindowAggregate.this.sessionMerger.apply(key, agg, next.value);
                    mergedWindow = KStreamSessionWindowAggregate.this.mergeSessionWindow(mergedWindow, (SessionWindow)((Windowed)next.key).window());
                }
            }
            catch (Throwable next) {
                object = next;
                throw next;
            }
            finally {
                if (iterator != null) {
                    if (object != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable next) {
                            ((Throwable)object).addSuppressed(next);
                        }
                    } else {
                        iterator.close();
                    }
                }
            }
            agg = KStreamSessionWindowAggregate.this.aggregator.apply(key, value, agg);
            Windowed sessionKey = new Windowed(key, mergedWindow);
            if (!mergedWindow.equals(newSessionWindow)) {
                for (KeyValue session : merged) {
                    this.store.remove((Windowed)session.key);
                    this.tupleForwarder.maybeForward(session.key, (Object)null, (Object)session.value);
                }
            }
            this.store.put(sessionKey, agg);
            this.tupleForwarder.maybeForward(sessionKey, agg, null);
        }
    }
}

