/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtp.header_extensions;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.extensions.unsigned.UnsignedKt;
import org.jitsi.rtp.util.FieldParsersKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jitsi/rtp/rtp/header_extensions/HeaderExtensionHelpers;", "", "()V", "Companion", "rtp"})
public final class HeaderExtensionHelpers {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int MINIMUM_EXT_SIZE_BYTES = 2;
    public static final int EXT_HEADER_SIZE_BYTES = 1;
    public static final int TOP_LEVEL_EXT_HEADER_SIZE_BYTES = 4;

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004J\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004J\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004J\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jitsi/rtp/rtp/header_extensions/HeaderExtensionHelpers$Companion;", "", "()V", "EXT_HEADER_SIZE_BYTES", "", "MINIMUM_EXT_SIZE_BYTES", "TOP_LEVEL_EXT_HEADER_SIZE_BYTES", "getDataLengthBytes", "buf", "", "offset", "getEntireLengthBytes", "getExtensionsTotalLength", "getId", "setId", "", "id", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        public final int getId(@NotNull byte[] buf, int offset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return buf[offset] >>> 4 & 0xF;
        }

        public final void setId(int id, @NotNull byte[] buf, int offset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            buf[offset] = (byte)(buf[offset] & 0xF);
            buf[offset] = (byte)(buf[offset] | (byte)(id << 4));
        }

        public final int getEntireLengthBytes(@NotNull byte[] buf, int offset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return this.getDataLengthBytes(buf, offset) + 1;
        }

        public final int getDataLengthBytes(@NotNull byte[] buf, int offset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return UnsignedKt.toPositiveInt((byte)(buf[offset] & 0xF)) + 1;
        }

        public final int getExtensionsTotalLength(@NotNull byte[] buf, int offset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return 4 + FieldParsersKt.getShortAsInt(buf, offset + 2) * 4;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

