/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Vector;

public class Picture {
    private Image image;
    private String name;
    private int index;
    private int count;
    private Rectangle rect;
    private Vector frames;
    private int frameCount;
    private int frameIndex;
    private int waitingSteps;
    private int waitingStep;

    public Picture(Image image, String string, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.image = image;
        this.name = string;
        this.index = n;
        this.count = n6;
        this.rect = new Rectangle(n2, n3, n4, n5);
        this.waitingSteps = 1 + Math.max(0, n7);
        this.waitingStep = 0;
    }

    public Rectangle getRect() {
        return this.rect;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public int getCount() {
        return this.count;
    }

    public synchronized void addFrames(Vector vector) {
        this.frames = vector;
        this.frameCount = vector.size();
        this.frameIndex = 0;
    }

    public synchronized Image getImage() {
        if (this.frames != null) {
            return (Image)this.frames.elementAt(this.frameIndex);
        }
        return this.image;
    }

    public synchronized boolean animate() {
        if (this.frames != null) {
            this.waitingStep = (this.waitingStep + 1) % this.waitingSteps;
            if (this.waitingStep == 0) {
                this.frameIndex = (this.frameIndex + 1) % this.frameCount;
                return true;
            }
        }
        return false;
    }
}

