/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.Alphabet;
import com.thaiopensource.relaxng.impl.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.NullNameClass;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternFunction;
import com.thaiopensource.relaxng.impl.PatternVisitor;
import com.thaiopensource.relaxng.impl.RestrictionViolationException;
import com.thaiopensource.relaxng.impl.SchemaPatternBuilder;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class ElementPattern
extends Pattern {
    private Pattern p;
    private final NameClass origNameClass;
    private NameClass nameClass;
    private boolean expanded = false;
    private boolean checkedRestrictions = false;
    private final Locator loc;

    ElementPattern(NameClass nameClass, Pattern p, Locator loc) {
        super(false, 1, ElementPattern.combineHashCode(23, nameClass.hashCode(), p.hashCode()));
        this.nameClass = nameClass;
        this.origNameClass = nameClass;
        this.p = p;
        this.loc = loc;
    }

    void checkRestrictions(int context, DuplicateAttributeDetector dad, Alphabet alpha) throws RestrictionViolationException {
        if (alpha != null) {
            alpha.addElement(this.origNameClass);
        }
        if (this.checkedRestrictions) {
            return;
        }
        switch (context) {
            case 7: {
                throw new RestrictionViolationException("data_except_contains_element");
            }
            case 6: {
                throw new RestrictionViolationException("list_contains_element");
            }
            case 5: {
                throw new RestrictionViolationException("attribute_contains_element");
            }
        }
        this.checkedRestrictions = true;
        try {
            this.p.checkRestrictions(1, new DuplicateAttributeDetector(), null);
        }
        catch (RestrictionViolationException e) {
            this.checkedRestrictions = false;
            e.maybeSetLocator(this.loc);
            throw e;
        }
    }

    Pattern expand(SchemaPatternBuilder b) {
        if (!this.expanded) {
            this.expanded = true;
            this.p = this.p.expand(b);
            if (this.p.isNotAllowed()) {
                this.nameClass = new NullNameClass();
            }
        }
        return this;
    }

    boolean samePattern(Pattern other) {
        if (!(other instanceof ElementPattern)) {
            return false;
        }
        ElementPattern ep = (ElementPattern)other;
        return this.nameClass.equals(ep.nameClass) && this.p == ep.p;
    }

    void checkRecursion(int depth) throws SAXException {
        this.p.checkRecursion(depth + 1);
    }

    void accept(PatternVisitor visitor) {
        visitor.visitElement(this.nameClass, this.p);
    }

    Object apply(PatternFunction f) {
        return f.caseElement(this);
    }

    void setContent(Pattern p) {
        this.p = p;
    }

    Pattern getContent() {
        return this.p;
    }

    NameClass getNameClass() {
        return this.nameClass;
    }

    Locator getLocator() {
        return this.loc;
    }
}

