/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.env.Environment;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.security.authc.InternalRealms;
import org.elasticsearch.xpack.security.authc.esnative.ReservedRealm;

public class Realms
extends AbstractComponent
implements Iterable<Realm> {
    private final Settings settings;
    private final Environment env;
    private final Map<String, Realm.Factory> factories;
    private final XPackLicenseState licenseState;
    private final ThreadContext threadContext;
    private final ReservedRealm reservedRealm;
    protected List<Realm> realms;
    List<Realm> standardRealmsOnly;
    List<Realm> nativeRealmsOnly;

    public Realms(Settings settings, Environment env, Map<String, Realm.Factory> factories, XPackLicenseState licenseState, ThreadContext threadContext, ReservedRealm reservedRealm) throws Exception {
        this.settings = settings;
        this.env = env;
        this.factories = factories;
        this.licenseState = licenseState;
        this.threadContext = threadContext;
        this.reservedRealm = reservedRealm;
        assert (factories.get("reserved") == null);
        this.realms = this.initRealms();
        ArrayList<Realm> standardRealms = new ArrayList<Realm>();
        ArrayList<Realm> nativeRealms = new ArrayList<Realm>();
        for (Realm realm : this.realms) {
            if (InternalRealms.isStandardRealm(realm.type())) {
                standardRealms.add(realm);
            }
            if (!"file".equals(realm.type()) && !"native".equals(realm.type())) continue;
            nativeRealms.add(realm);
        }
        for (List realmList : Arrays.asList(standardRealms, nativeRealms)) {
            if (realmList.isEmpty()) {
                this.addNativeRealms(realmList);
            }
            assert (!realmList.contains((Object)reservedRealm));
            realmList.add(0, reservedRealm);
            assert (realmList.get(0) == reservedRealm);
        }
        this.standardRealmsOnly = Collections.unmodifiableList(standardRealms);
        this.nativeRealmsOnly = Collections.unmodifiableList(nativeRealms);
        this.realms.forEach(r -> r.initialize((Iterable)this, licenseState));
    }

    @Override
    public Iterator<Realm> iterator() {
        if (!this.licenseState.isAuthAllowed()) {
            return Collections.emptyIterator();
        }
        XPackLicenseState.AllowedRealmType allowedRealmType = this.licenseState.allowedRealmType();
        switch (allowedRealmType) {
            case ALL: {
                return this.realms.iterator();
            }
            case DEFAULT: {
                return this.standardRealmsOnly.iterator();
            }
            case NATIVE: {
                return this.nativeRealmsOnly.iterator();
            }
        }
        throw new IllegalStateException("authentication should not be enabled");
    }

    public List<Realm> getUnlicensedRealms() {
        if (!this.licenseState.isAuthAllowed()) {
            return Collections.unmodifiableList(this.realms);
        }
        XPackLicenseState.AllowedRealmType allowedRealmType = this.licenseState.allowedRealmType();
        if (allowedRealmType == XPackLicenseState.AllowedRealmType.ALL) {
            return Collections.emptyList();
        }
        List<Realm> allowedRealms = this.asList();
        if (allowedRealms.equals(this.realms.size())) {
            return Collections.emptyList();
        }
        List unlicensed = this.realms.stream().filter(r -> !allowedRealms.contains(r)).collect(Collectors.toList());
        return Collections.unmodifiableList(unlicensed);
    }

    public Stream<Realm> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public List<Realm> asList() {
        if (!this.licenseState.isAuthAllowed()) {
            return Collections.emptyList();
        }
        XPackLicenseState.AllowedRealmType allowedRealmType = this.licenseState.allowedRealmType();
        switch (allowedRealmType) {
            case ALL: {
                return Collections.unmodifiableList(this.realms);
            }
            case DEFAULT: {
                return Collections.unmodifiableList(this.standardRealmsOnly);
            }
            case NATIVE: {
                return Collections.unmodifiableList(this.nativeRealmsOnly);
            }
        }
        throw new IllegalStateException("authentication should not be enabled");
    }

    public Realm realm(String name) {
        for (Realm realm : this.realms) {
            if (!name.equals(realm.name())) continue;
            return realm;
        }
        return null;
    }

    public Realm.Factory realmFactory(String type) {
        return this.factories.get(type);
    }

    protected List<Realm> initRealms() throws Exception {
        Settings realmsSettings = RealmSettings.get((Settings)this.settings);
        HashSet<String> internalTypes = new HashSet<String>();
        ArrayList<Realm> realms = new ArrayList<Realm>();
        ArrayList<String> kerberosRealmNames = new ArrayList<String>();
        for (String name : realmsSettings.names()) {
            Settings realmSettings = realmsSettings.getAsSettings(name);
            String type = realmSettings.get("type");
            if (type == null) {
                throw new IllegalArgumentException("missing realm type for [" + name + "] realm");
            }
            Realm.Factory factory = this.factories.get(type);
            if (factory == null) {
                throw new IllegalArgumentException("unknown realm type [" + type + "] set for realm [" + name + "]");
            }
            RealmConfig config = new RealmConfig(name, realmSettings, this.settings, this.env, this.threadContext);
            if (!config.enabled()) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("realm [{}/{}] is disabled", (Object)type, (Object)name);
                continue;
            }
            if ("file".equals(type) || "native".equals(type)) {
                if (internalTypes.contains(type)) {
                    throw new IllegalArgumentException("multiple [" + type + "] realms are configured. [" + type + "] is an internal realm and therefore there can only be one such realm configured");
                }
                internalTypes.add(type);
            }
            if ("kerberos".equals(type)) {
                kerberosRealmNames.add(name);
                if (kerberosRealmNames.size() > 1) {
                    throw new IllegalArgumentException("multiple realms " + ((Object)kerberosRealmNames).toString() + " configured of type [" + type + "], [" + type + "] can only have one such realm configured");
                }
            }
            realms.add(factory.create(config));
        }
        if (!realms.isEmpty()) {
            Collections.sort(realms);
        } else {
            this.addNativeRealms(realms);
        }
        realms.add(0, this.reservedRealm);
        return realms;
    }

    public void usageStats(ActionListener<Map<String, Object>> listener) {
        HashMap realmMap = new HashMap();
        AtomicBoolean failed = new AtomicBoolean(false);
        List realmList = this.asList().stream().filter(r -> !"reserved".equals(r.type())).collect(Collectors.toList());
        CountDown countDown = new CountDown(realmList.size());
        Runnable doCountDown = () -> {
            if ((realmList.isEmpty() || countDown.countDown()) && !failed.get()) {
                XPackLicenseState.AllowedRealmType allowedRealmType = this.licenseState.allowedRealmType();
                for (String type : this.factories.keySet()) {
                    assert (!"reserved".equals(type));
                    realmMap.compute(type, (key, value) -> {
                        if (value == null) {
                            return MapBuilder.newMapBuilder().put((Object)"enabled", (Object)false).put((Object)"available", (Object)Realms.isRealmTypeAvailable(allowedRealmType, type)).map();
                        }
                        assert (value instanceof Map);
                        Map realmTypeUsage = (Map)value;
                        realmTypeUsage.put("enabled", true);
                        assert (Realms.isRealmTypeAvailable(allowedRealmType, type));
                        realmTypeUsage.put("available", true);
                        return value;
                    });
                }
                listener.onResponse((Object)realmMap);
            }
        };
        if (realmList.isEmpty()) {
            doCountDown.run();
        } else {
            for (Realm realm : realmList) {
                realm.usageStats(ActionListener.wrap(stats -> {
                    if (!failed.get()) {
                        Map map = realmMap;
                        synchronized (map) {
                            realmMap.compute(realm.type(), (key, value) -> {
                                if (value == null) {
                                    Map<String, Object> realmTypeUsage = Realms.convertToMapOfLists(stats);
                                    return realmTypeUsage;
                                }
                                assert (value instanceof Map);
                                Realms.combineMaps((Map)value, stats);
                                return value;
                            });
                        }
                        doCountDown.run();
                    }
                }, e -> {
                    if (failed.compareAndSet(false, true)) {
                        listener.onFailure(e);
                    }
                }));
            }
        }
    }

    private void addNativeRealms(List<Realm> realms) throws Exception {
        Realm.Factory indexRealmFactory;
        Realm.Factory fileRealm = this.factories.get("file");
        if (fileRealm != null) {
            realms.add(fileRealm.create(new RealmConfig("default_file", Settings.EMPTY, this.settings, this.env, this.threadContext)));
        }
        if ((indexRealmFactory = this.factories.get("native")) != null) {
            realms.add(indexRealmFactory.create(new RealmConfig("default_native", Settings.EMPTY, this.settings, this.env, this.threadContext)));
        }
    }

    private static void combineMaps(Map<String, Object> mapA, Map<String, Object> mapB) {
        for (Map.Entry<String, Object> entry : mapB.entrySet()) {
            mapA.compute(entry.getKey(), (key, value) -> {
                if (value == null) {
                    return new ArrayList(Collections.singletonList(entry.getValue()));
                }
                assert (value instanceof List);
                ((List)value).add(entry.getValue());
                return value;
            });
        }
    }

    private static Map<String, Object> convertToMapOfLists(Map<String, Object> map) {
        HashMap<String, Object> converted = new HashMap<String, Object>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            converted.put(entry.getKey(), new ArrayList<Object>(Collections.singletonList(entry.getValue())));
        }
        return converted;
    }

    public static boolean isRealmTypeAvailable(XPackLicenseState.AllowedRealmType enabledRealmType, String type) {
        switch (enabledRealmType) {
            case ALL: {
                return true;
            }
            case NONE: {
                return false;
            }
            case NATIVE: {
                return "file".equals(type) || "native".equals(type);
            }
            case DEFAULT: {
                return InternalRealms.isStandardRealm(type) || "reserved".equals(type);
            }
        }
        throw new IllegalStateException("unknown enabled realm type [" + enabledRealmType + "]");
    }
}

