/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.util.Locale;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.xpack.core.XPackSettings;

public final class ApiKeySSLBootstrapCheck
implements BootstrapCheck {
    public BootstrapCheck.BootstrapCheckResult check(BootstrapContext context) {
        Boolean httpsEnabled = (Boolean)XPackSettings.HTTP_SSL_ENABLED.get(context.settings());
        Boolean apiKeyServiceEnabled = (Boolean)XPackSettings.API_KEY_SERVICE_ENABLED_SETTING.get(context.settings());
        if (!httpsEnabled.booleanValue() && apiKeyServiceEnabled.booleanValue()) {
            String message = String.format(Locale.ROOT, "HTTPS is required in order to use the API key service; please enable HTTPS using the [%s] setting or disable the API key service using the [%s] setting", XPackSettings.HTTP_SSL_ENABLED.getKey(), XPackSettings.API_KEY_SERVICE_ENABLED_SETTING.getKey());
            return BootstrapCheck.BootstrapCheckResult.failure((String)message);
        }
        return BootstrapCheck.BootstrapCheckResult.success();
    }
}

