/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.writer;

import com.fasterxml.jackson.core.JsonParseException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.XContentParser;

class XContentRecordReader {
    static final int PARSE_ERRORS_LIMIT = 100;
    protected final XContentParser parser;
    protected final Map<String, Integer> fieldMap;
    protected final Logger logger;
    protected int nestedLevel;
    protected long fieldCount;
    protected int errorCounter;
    private Deque<String> nestedFields;
    private String nestedPrefix;

    XContentRecordReader(XContentParser parser, Map<String, Integer> fieldMap, Logger logger) {
        this.parser = Objects.requireNonNull(parser);
        this.fieldMap = Objects.requireNonNull(fieldMap);
        this.logger = Objects.requireNonNull(logger);
    }

    public long read(String[] record, boolean[] gotFields) throws IOException {
        this.initArrays(record, gotFields);
        this.fieldCount = 0L;
        this.clearNestedLevel();
        XContentParser.Token token = this.tryNextTokenOrReadToEndOnError();
        while ((token != XContentParser.Token.END_OBJECT || this.nestedLevel != 0) && token != null) {
            if (token == XContentParser.Token.END_OBJECT) {
                --this.nestedLevel;
                String objectFieldName = this.nestedFields.pop();
                int lastIndex = this.nestedPrefix.length() - objectFieldName.length() - 1;
                this.nestedPrefix = this.nestedPrefix.substring(0, lastIndex);
            } else if (token == XContentParser.Token.FIELD_NAME) {
                this.parseFieldValuePair(record, gotFields);
            }
            token = this.tryNextTokenOrReadToEndOnError();
        }
        if (token == null) {
            return -1L;
        }
        return this.fieldCount;
    }

    protected void clearNestedLevel() {
        this.nestedLevel = 0;
        this.nestedFields = new ArrayDeque<String>();
        this.nestedPrefix = "";
    }

    private void parseFieldValuePair(String[] record, boolean[] gotFields) throws IOException {
        String fieldName = this.parser.currentName();
        XContentParser.Token token = this.tryNextTokenOrReadToEndOnError();
        if (token == null) {
            return;
        }
        if (token == XContentParser.Token.START_OBJECT) {
            ++this.nestedLevel;
            this.nestedFields.push(fieldName);
            this.nestedPrefix = this.nestedPrefix + fieldName + ".";
        } else if (token == XContentParser.Token.START_ARRAY || token.isValue()) {
            ++this.fieldCount;
            Integer index = this.fieldMap.get(this.nestedPrefix + fieldName);
            if (index != null) {
                record[index.intValue()] = this.parseSingleFieldValue(token);
                gotFields[index.intValue()] = true;
            } else {
                this.skipSingleFieldValue(token);
            }
        }
    }

    private String parseSingleFieldValue(XContentParser.Token token) throws IOException {
        if (token == XContentParser.Token.START_ARRAY) {
            StringBuilder strBuilder = new StringBuilder();
            boolean needComma = false;
            while (token != XContentParser.Token.END_ARRAY) {
                token = this.tryNextTokenOrReadToEndOnError();
                if (!token.isValue()) continue;
                if (needComma) {
                    strBuilder.append(',');
                } else {
                    needComma = true;
                }
                strBuilder.append(this.tokenToString(token));
            }
            return strBuilder.toString();
        }
        return this.tokenToString(token);
    }

    private void skipSingleFieldValue(XContentParser.Token token) throws IOException {
        if (token == XContentParser.Token.START_ARRAY) {
            int arrayDepth = 1;
            do {
                if ((token = this.tryNextTokenOrReadToEndOnError()) == XContentParser.Token.END_ARRAY) {
                    --arrayDepth;
                    continue;
                }
                if (token != XContentParser.Token.START_ARRAY) continue;
                ++arrayDepth;
            } while (token != null && arrayDepth > 0);
        }
    }

    private String tokenToString(XContentParser.Token token) throws IOException {
        if (token == null || token == XContentParser.Token.VALUE_NULL) {
            return "";
        }
        return this.parser.text();
    }

    protected void initArrays(String[] record, boolean[] gotFields) {
        Arrays.fill(gotFields, false);
        Arrays.fill(record, "");
    }

    protected XContentParser.Token tryNextTokenOrReadToEndOnError() throws IOException {
        try {
            return this.parser.nextToken();
        }
        catch (JsonParseException e) {
            this.logger.warn("Attempting to recover from malformed JSON data.", (Throwable)e);
            for (int i = 0; i <= this.nestedLevel; ++i) {
                this.readToEndOfObject();
            }
            this.clearNestedLevel();
            return this.parser.currentToken();
        }
    }

    protected void readToEndOfObject() throws IOException {
        XContentParser.Token token = null;
        do {
            try {
                token = this.parser.nextToken();
            }
            catch (JsonParseException e) {
                ++this.errorCounter;
                if (this.errorCounter < 100) continue;
                this.logger.error("Failed to recover from malformed JSON data.", (Throwable)e);
                throw new ElasticsearchParseException("The input JSON data is malformed.", new Object[0]);
            }
        } while (token != XContentParser.Token.END_OBJECT);
    }
}

