/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.io.IOException;
import java.util.function.BiFunction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.gen.processor.FunctionalBinaryProcessor;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;

public class BinaryStringNumericProcessor
extends FunctionalBinaryProcessor<String, Number, String, BinaryStringNumericOperation> {
    public static final String NAME = "sn";

    public BinaryStringNumericProcessor(Processor left, Processor right, BinaryStringNumericOperation operation) {
        super(left, right, operation);
    }

    public BinaryStringNumericProcessor(StreamInput in) throws IOException {
        super(in, i -> (BinaryStringNumericOperation)i.readEnum(BinaryStringNumericOperation.class));
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Object doProcess(Object left, Object right) {
        if (!(left instanceof String) && !(left instanceof Character)) {
            throw new SqlIllegalArgumentException("A string/char is required; received [{}]", left);
        }
        if (!(right instanceof Number)) {
            throw new SqlIllegalArgumentException("A number is required; received [{}]", right);
        }
        return super.doProcess(left.toString(), right);
    }

    public static enum BinaryStringNumericOperation implements BiFunction<String, Number, String>
    {
        LEFT((s, c) -> {
            int i = c.intValue();
            if (i < 0) {
                return "";
            }
            return i > s.length() ? s : s.substring(0, i);
        }),
        RIGHT((s, c) -> {
            int i = c.intValue();
            if (i < 0) {
                return "";
            }
            return i > s.length() ? s : s.substring(s.length() - i);
        }),
        REPEAT((s, c) -> {
            int i = c.intValue();
            if (i <= 0) {
                return null;
            }
            StringBuilder sb = new StringBuilder(s.length() * i);
            for (int j = 0; j < i; ++j) {
                sb.append((String)s);
            }
            return sb.toString();
        });

        private final BiFunction<String, Number, String> op;

        private BinaryStringNumericOperation(BiFunction<String, Number, String> op) {
            this.op = op;
        }

        @Override
        public String apply(String stringExp, Number count) {
            if (stringExp == null || count == null) {
                return null;
            }
            return this.op.apply(stringExp, count);
        }
    }
}

