/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.bytecode.analysis.parse.expression;

import java.util.List;
import org.benf.cfr.reader.bytecode.analysis.parse.Expression;
import org.benf.cfr.reader.bytecode.analysis.parse.StatementContainer;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.LambdaExpressionCommon;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.misc.Precedence;
import org.benf.cfr.reader.bytecode.analysis.parse.rewriters.CloneHelper;
import org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriter;
import org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterFlags;
import org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.EquivalenceConstraint;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.LValueRewriter;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.LValueUsageCollector;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.SSAIdentifiers;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.discovery.InferredJavaType;
import org.benf.cfr.reader.state.TypeUsageCollector;
import org.benf.cfr.reader.util.StringUtils;
import org.benf.cfr.reader.util.Troolean;
import org.benf.cfr.reader.util.output.Dumper;

public class LambdaExpressionFallback
extends AbstractExpression
implements LambdaExpressionCommon {
    private JavaTypeInstance callClassType;
    private String lambdaFnName;
    private List<JavaTypeInstance> targetFnArgTypes;
    private List<Expression> curriedArgs;
    private boolean instance;
    private final boolean colon;

    public LambdaExpressionFallback(JavaTypeInstance callClassType, InferredJavaType castJavaType, String lambdaFnName, List<JavaTypeInstance> targetFnArgTypes, List<Expression> curriedArgs, boolean instance) {
        super(castJavaType);
        this.callClassType = callClassType;
        this.lambdaFnName = lambdaFnName.equals("<init>") ? "new" : lambdaFnName;
        this.targetFnArgTypes = targetFnArgTypes;
        this.curriedArgs = curriedArgs;
        this.instance = instance;
        boolean isColon = false;
        switch (curriedArgs.size()) {
            case 0: {
                boolean bl = isColon = targetFnArgTypes.size() <= 1 && !instance;
                if (!instance) break;
                isColon = true;
                this.instance = false;
                break;
            }
            case 1: {
                isColon = targetFnArgTypes.size() <= 1 && instance;
            }
        }
        this.colon = isColon;
    }

    private LambdaExpressionFallback(InferredJavaType inferredJavaType, boolean colon, boolean instance, List<Expression> curriedArgs, List<JavaTypeInstance> targetFnArgTypes, String lambdaFnName, JavaTypeInstance callClassType) {
        super(inferredJavaType);
        this.colon = colon;
        this.instance = instance;
        this.curriedArgs = curriedArgs;
        this.targetFnArgTypes = targetFnArgTypes;
        this.lambdaFnName = lambdaFnName;
        this.callClassType = callClassType;
    }

    @Override
    public Expression deepClone(CloneHelper cloneHelper) {
        return new LambdaExpressionFallback(this.getInferredJavaType(), this.colon, this.instance, cloneHelper.replaceOrClone(this.curriedArgs), this.targetFnArgTypes, this.lambdaFnName, this.callClassType);
    }

    @Override
    public void collectTypeUsages(TypeUsageCollector collector) {
        collector.collect(this.targetFnArgTypes);
        collector.collectFrom(this.curriedArgs);
        collector.collect(this.callClassType);
    }

    @Override
    public Expression replaceSingleUsageLValues(LValueRewriter lValueRewriter, SSAIdentifiers ssaIdentifiers, StatementContainer statementContainer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression applyExpressionRewriter(ExpressionRewriter expressionRewriter, SSAIdentifiers ssaIdentifiers, StatementContainer statementContainer, ExpressionRewriterFlags flags) {
        ExpressionRewriterHelper.applyForwards(this.curriedArgs, expressionRewriter, ssaIdentifiers, statementContainer, flags);
        return this;
    }

    @Override
    public Expression applyReverseExpressionRewriter(ExpressionRewriter expressionRewriter, SSAIdentifiers ssaIdentifiers, StatementContainer statementContainer, ExpressionRewriterFlags flags) {
        ExpressionRewriterHelper.applyBackwards(this.curriedArgs, expressionRewriter, ssaIdentifiers, statementContainer, flags);
        return this;
    }

    @Override
    public Precedence getPrecedence() {
        return Precedence.LAMBDA;
    }

    @Override
    public Dumper dumpInner(Dumper d) {
        if (this.colon) {
            if (this.instance) {
                this.curriedArgs.get(0).dumpWithOuterPrecedence(d, this.getPrecedence(), Troolean.TRUE).print("::").print(this.lambdaFnName);
            } else {
                d.dump(this.callClassType).print("::").print(this.lambdaFnName);
            }
        } else {
            int x;
            boolean multi;
            int n = this.targetFnArgTypes.size();
            boolean bl = multi = n != 1;
            if (multi) {
                d.print("(");
            }
            for (int x2 = 0; x2 < n; ++x2) {
                if (x2 > 0) {
                    d.print(", ");
                }
                d.print("arg_" + x2);
            }
            if (multi) {
                d.print(")");
            }
            if (this.instance) {
                d = d.print(" -> ");
                this.curriedArgs.get(0).dumpWithOuterPrecedence(d, this.getPrecedence(), Troolean.TRUE).print('.').print(this.lambdaFnName);
            } else {
                d.print(" -> ").dump(this.callClassType).print('.').print(this.lambdaFnName);
            }
            d.print("(");
            boolean first = true;
            int cnt = this.curriedArgs.size();
            for (x = this.instance ? 1 : 0; x < cnt; ++x) {
                Expression c = this.curriedArgs.get(x);
                first = StringUtils.comma(first, d);
                d.dump(c);
            }
            for (x = 0; x < n; ++x) {
                first = StringUtils.comma(first, d);
                d.print("arg_" + x);
            }
            d.print(")");
        }
        return d;
    }

    @Override
    public void collectUsedLValues(LValueUsageCollector lValueUsageCollector) {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LambdaExpressionFallback that = (LambdaExpressionFallback)o;
        if (this.colon != that.colon) {
            return false;
        }
        if (this.instance != that.instance) {
            return false;
        }
        if (this.callClassType != null ? !this.callClassType.equals(that.callClassType) : that.callClassType != null) {
            return false;
        }
        if (this.curriedArgs != null ? !((Object)this.curriedArgs).equals(that.curriedArgs) : that.curriedArgs != null) {
            return false;
        }
        if (this.lambdaFnName != null ? !this.lambdaFnName.equals(that.lambdaFnName) : that.lambdaFnName != null) {
            return false;
        }
        return !(this.targetFnArgTypes != null ? !((Object)this.targetFnArgTypes).equals(that.targetFnArgTypes) : that.targetFnArgTypes != null);
    }

    @Override
    public final boolean equivalentUnder(Object o, EquivalenceConstraint constraint) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        LambdaExpressionFallback other = (LambdaExpressionFallback)o;
        if (this.instance != other.instance) {
            return false;
        }
        if (this.colon != other.colon) {
            return false;
        }
        if (!constraint.equivalent(this.lambdaFnName, other.lambdaFnName)) {
            return false;
        }
        return constraint.equivalent(this.curriedArgs, other.curriedArgs);
    }
}

