/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.GossipDigest;
import org.apache.cassandra.gms.GossipDigestAck;
import org.apache.cassandra.gms.GossipDigestSyn;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GossipDigestSynVerbHandler
implements IVerbHandler<GossipDigestSyn> {
    private static final Logger logger = LoggerFactory.getLogger(GossipDigestSynVerbHandler.class);

    @Override
    public void doVerb(MessageIn<GossipDigestSyn> message, int id) {
        InetAddress from = message.from;
        if (logger.isTraceEnabled()) {
            logger.trace("Received a GossipDigestSynMessage from {}", (Object)from);
        }
        if (!Gossiper.instance.isEnabled() && !Gossiper.instance.isInShadowRound()) {
            if (logger.isTraceEnabled()) {
                logger.trace("Ignoring GossipDigestSynMessage because gossip is disabled");
            }
            return;
        }
        GossipDigestSyn gDigestMessage = (GossipDigestSyn)message.payload;
        if (!gDigestMessage.clusterId.equals(DatabaseDescriptor.getClusterName())) {
            logger.warn("ClusterName mismatch from {} {}!={}", new Object[]{from, gDigestMessage.clusterId, DatabaseDescriptor.getClusterName()});
            return;
        }
        if (gDigestMessage.partioner != null && !gDigestMessage.partioner.equals(DatabaseDescriptor.getPartitionerName())) {
            logger.warn("Partitioner mismatch from {} {}!={}", new Object[]{from, gDigestMessage.partioner, DatabaseDescriptor.getPartitionerName()});
            return;
        }
        List<GossipDigest> gDigestList = gDigestMessage.getGossipDigests();
        if (!Gossiper.instance.isEnabled() && Gossiper.instance.isInShadowRound()) {
            if (gDigestList.size() > 0) {
                logger.debug("Ignoring non-empty GossipDigestSynMessage because currently in gossip shadow round");
                return;
            }
            logger.debug("Received a shadow round syn from {}. Gossip is disabled but currently also in shadow round, responding with a minimal ack", (Object)from);
            MessagingService.instance().sendOneWay(new MessageOut<GossipDigestAck>(MessagingService.Verb.GOSSIP_DIGEST_ACK, new GossipDigestAck(new ArrayList<GossipDigest>(), new HashMap<InetAddress, EndpointState>()), GossipDigestAck.serializer), from);
            return;
        }
        if (logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (GossipDigest gDigest : gDigestList) {
                sb.append(gDigest);
                sb.append(" ");
            }
            logger.trace("Gossip syn digests are : {}", (Object)sb);
        }
        this.doSort(gDigestList);
        ArrayList<GossipDigest> deltaGossipDigestList = new ArrayList<GossipDigest>();
        HashMap<InetAddress, EndpointState> deltaEpStateMap = new HashMap<InetAddress, EndpointState>();
        Gossiper.instance.examineGossiper(gDigestList, deltaGossipDigestList, deltaEpStateMap);
        logger.trace("sending {} digests and {} deltas", (Object)deltaGossipDigestList.size(), (Object)deltaEpStateMap.size());
        MessageOut<GossipDigestAck> gDigestAckMessage = new MessageOut<GossipDigestAck>(MessagingService.Verb.GOSSIP_DIGEST_ACK, new GossipDigestAck(deltaGossipDigestList, deltaEpStateMap), GossipDigestAck.serializer);
        if (logger.isTraceEnabled()) {
            logger.trace("Sending a GossipDigestAckMessage to {}", (Object)from);
        }
        MessagingService.instance().sendOneWay(gDigestAckMessage, from);
    }

    private void doSort(List<GossipDigest> gDigestList) {
        HashMap<InetAddress, GossipDigest> epToDigestMap = new HashMap<InetAddress, GossipDigest>();
        for (GossipDigest gossipDigest : gDigestList) {
            epToDigestMap.put(gossipDigest.getEndpoint(), gossipDigest);
        }
        ArrayList<GossipDigest> diffDigests = new ArrayList<GossipDigest>(gDigestList.size());
        for (GossipDigest gDigest : gDigestList) {
            InetAddress ep = gDigest.getEndpoint();
            EndpointState epState = Gossiper.instance.getEndpointStateForEndpoint(ep);
            int version = epState != null ? Gossiper.instance.getMaxEndpointStateVersion(epState) : 0;
            int diffVersion = Math.abs(version - gDigest.getMaxVersion());
            diffDigests.add(new GossipDigest(ep, gDigest.getGeneration(), diffVersion));
        }
        gDigestList.clear();
        Collections.sort(diffDigests);
        int n = diffDigests.size();
        for (int i = n - 1; i >= 0; --i) {
            gDigestList.add((GossipDigest)epToDigestMap.get(((GossipDigest)diffDigests.get(i)).getEndpoint()));
        }
    }
}

