/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.omegat.core.Core;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.statistics.StatisticsSettings;
import org.omegat.util.PatternConsts;

public final class TagUtil {
    private static final Comparator<Tag> TAG_COMPARATOR = (o1, o2) -> o1.pos - o2.pos;
    public static final String TAG_SEPARATOR_SENTINEL = "\ue100";
    public static final char TEXT_REPLACEMENT = '\ue100';

    private TagUtil() {
    }

    public static List<Tag> getAllTagsInSource() {
        SourceTextEntry ste = Core.getEditor().getCurrentEntry();
        return TagUtil.buildTagList(ste.getSrcText(), ste.getProtectedParts());
    }

    public static List<Tag> getAllTagsMissingFromTarget() {
        ArrayList<Tag> result = new ArrayList<Tag>();
        StringBuilder target = new StringBuilder(Core.getEditor().getCurrentTranslation());
        for (Tag tag : TagUtil.getAllTagsInSource()) {
            int pos = -1;
            pos = target.indexOf(tag.tag);
            if (pos != -1) {
                TagUtil.replaceWith(target, pos, pos + tag.tag.length(), '\ue100');
                continue;
            }
            result.add(tag);
        }
        return result;
    }

    public static List<String> getGroupedMissingTagsFromTarget() {
        ArrayList<Object> result = new ArrayList<Object>();
        List<Tag> tags = TagUtil.getAllTagsMissingFromTarget();
        for (int i = 0; i < tags.size(); ++i) {
            Tag tag = tags.get(i);
            List group = TagUtil.getGroupAt(tags, i).stream().map(t -> t.tag).collect(Collectors.toList());
            if (group.size() > 1) {
                result.add(String.join((CharSequence)"", group));
            }
            if (i + 1 < tags.size()) {
                Tag next = tags.get(i + 1);
                String pair = tag.getPairedTag();
                if (next.tag.equals(pair) || tag.getType() == TagType.SINGLE && next.getType() == TagType.SINGLE) {
                    result.add(tag.tag + TAG_SEPARATOR_SENTINEL + next.tag);
                }
            }
            result.addAll(group);
        }
        return result.stream().distinct().collect(Collectors.toList());
    }

    private static List<Tag> getGroupAt(List<Tag> tags, int index) {
        Tag tag = tags.get(index);
        if (index > 0) {
            Tag prev = tags.get(index - 1);
            if (prev.pos + prev.tag.length() == tag.pos) {
                return Arrays.asList(tag);
            }
        }
        ArrayList<Tag> group = new ArrayList<Tag>();
        group.add(tag);
        for (int j = index + 1; j < tags.size(); ++j) {
            Tag prev = tags.get(j - 1);
            Tag next = tags.get(j);
            if (prev.pos + prev.tag.length() != next.pos) break;
            group.add(next);
        }
        return group;
    }

    public static List<Tag> buildTagList(String str, ProtectedPart[] protectedParts) {
        boolean loopAgain;
        if (protectedParts == null || protectedParts.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        StringBuilder sb = new StringBuilder(str);
        do {
            loopAgain = false;
            for (ProtectedPart pp : protectedParts) {
                int pos = -1;
                pos = sb.indexOf(pp.getTextInSourceSegment());
                if (pos == -1) continue;
                tags.add(new Tag(pos, pp.getTextInSourceSegment()));
                TagUtil.replaceWith(sb, pos, pos + pp.getTextInSourceSegment().length(), '\ue100');
                loopAgain = true;
            }
        } while (loopAgain);
        Collections.sort(tags, TAG_COMPARATOR);
        return tags;
    }

    public static void addExtraTags(List<Tag> resultList, List<Tag> srcTags, String str) {
        StringBuilder sb = new StringBuilder(str);
        Pattern placeholderPattern = PatternConsts.OMEGAT_TAG;
        Matcher placeholderMatcher = placeholderPattern.matcher(str);
        while (placeholderMatcher.find()) {
            int pos;
            if (TagUtil.containsTag(srcTags, placeholderMatcher.group(0)) || (pos = sb.indexOf(placeholderMatcher.group(0))) == -1) continue;
            resultList.add(new Tag(pos, placeholderMatcher.group(0)));
            TagUtil.replaceWith(sb, pos, pos + placeholderMatcher.group(0).length(), '\ue100');
        }
        Collections.sort(resultList, TAG_COMPARATOR);
    }

    public static boolean containsTag(List<Tag> tags, String tag) {
        if (tag == null) {
            return false;
        }
        for (Tag t : tags) {
            if (!t.tag.equals(tag)) continue;
            return true;
        }
        return false;
    }

    private static void replaceWith(StringBuilder sb, int start, int end, char replacement) {
        for (int i = start; i < end; ++i) {
            sb.setCharAt(i, replacement);
        }
    }

    public static String buildTagListForRemove(String str) {
        StringBuilder res = new StringBuilder();
        Pattern placeholderPattern = PatternConsts.OMEGAT_TAG;
        Matcher placeholderMatcher = placeholderPattern.matcher(str);
        while (placeholderMatcher.find()) {
            res.append(placeholderMatcher.group(0));
        }
        return res.toString();
    }

    public static String getFirstTag(String str) {
        Pattern placeholderPattern = PatternConsts.OMEGAT_TAG;
        Matcher placeholderMatcher = placeholderPattern.matcher(str);
        if (placeholderMatcher.find()) {
            return placeholderMatcher.group(0);
        }
        return null;
    }

    public static List<ProtectedPart> applyCustomProtectedParts(String source, Pattern protectedPartsPatterns, List<ProtectedPart> protectedParts) {
        ArrayList<ProtectedPart> result;
        if (protectedParts != null) {
            for (ProtectedPart pp : protectedParts) {
                source = source.replace(pp.getTextInSourceSegment(), "\b");
            }
            result = protectedParts;
        } else {
            result = new ArrayList();
        }
        Matcher placeholderMatcher = protectedPartsPatterns.matcher(source);
        while (placeholderMatcher.find()) {
            ProtectedPart pp;
            pp = new ProtectedPart();
            pp.setTextInSourceSegment(placeholderMatcher.group());
            pp.setDetailsFromSourceFile(placeholderMatcher.group());
            if (StatisticsSettings.isCountingCustomTags()) {
                pp.setReplacementWordsCountCalculation(placeholderMatcher.group());
            } else {
                pp.setReplacementWordsCountCalculation("\b");
            }
            pp.setReplacementUniquenessCalculation(placeholderMatcher.group());
            pp.setReplacementMatchCalculation(placeholderMatcher.group());
            result.add(pp);
        }
        return result;
    }

    public static String stripXmlTags(String xml) {
        return PatternConsts.OMEGAT_TAG.matcher(xml).replaceAll("");
    }

    public static class TagInfo {
        public final TagType type;
        public final String name;

        public TagInfo(String name, TagType type) {
            this.name = name;
            this.type = type;
        }
    }

    public static enum TagType {
        START,
        END,
        SINGLE;

    }

    public static final class Tag {
        public final int pos;
        public final String tag;

        public Tag(int pos, String tag) {
            this.pos = pos;
            this.tag = tag;
        }

        public TagType getType() {
            Matcher m = PatternConsts.OMEGAT_TAG_DECOMPILE.matcher(this.tag);
            if (!m.find()) {
                return TagType.SINGLE;
            }
            boolean hasFrontSlash = "/".equals(m.group(1));
            boolean hasBackSlash = "/".equals(m.group(4));
            if (hasFrontSlash && !hasBackSlash) {
                return TagType.END;
            }
            if (!hasFrontSlash && !hasBackSlash) {
                return TagType.START;
            }
            return TagType.SINGLE;
        }

        public String getName() {
            Matcher m = PatternConsts.OMEGAT_TAG_DECOMPILE.matcher(this.tag);
            if (!m.find()) {
                return this.tag;
            }
            boolean hasFrontSlash = "/".equals(m.group(1));
            boolean hasBackSlash = "/".equals(m.group(4));
            if (hasFrontSlash && hasBackSlash) {
                return this.tag;
            }
            return m.group(2) + m.group(3);
        }

        public String getPairedTag() {
            switch (this.getType()) {
                case START: {
                    return "</" + this.getName() + ">";
                }
                case END: {
                    return "<" + this.getName() + ">";
                }
            }
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.pos;
            result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Tag other = (Tag)obj;
            if (this.pos != other.pos) {
                return false;
            }
            return !(this.tag == null ? other.tag != null : !this.tag.equals(other.tag));
        }

        public String toString() {
            return this.tag + "@" + this.pos;
        }
    }
}

