/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.scripting;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.omegat.gui.scripting.ScriptItem;

public class ScriptSet {
    private Properties m_props;
    private File m_setFile;

    public ScriptSet(File setFile) {
        this.m_setFile = setFile;
        this.m_props = new Properties();
        try {
            FileInputStream is = new FileInputStream(setFile);
            this.m_props.load(is);
            is.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveSet(File setFile, String title, String[] quickScripts) throws IOException {
        Properties p = new Properties();
        p.setProperty("title", title);
        for (int i = 0; i < 12; ++i) {
            if (quickScripts[i] == null) continue;
            p.setProperty(Integer.toString(i + 1), quickScripts[i]);
        }
        p.store(new FileOutputStream(setFile), "OmegaT Script Set");
    }

    public String getTitle() {
        if (this.m_props.containsKey("title")) {
            return this.m_props.getProperty("title");
        }
        return this.m_setFile.getName();
    }

    public ScriptItem getScriptItem(int key) {
        String idx;
        if (key > 12) {
            key = 12;
        }
        if (this.m_props.containsKey(idx = Integer.toString(key))) {
            return new ScriptItem(new File(this.m_setFile.getParentFile(), this.m_props.getProperty(idx)));
        }
        return null;
    }

    public void load() {
    }
}

