/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.calculator.content;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import net.loomchild.maligna.calculator.Calculator;
import net.loomchild.maligna.coretypes.Alignment;
import net.loomchild.maligna.filter.modifier.modify.split.SplitAlgorithm;
import net.loomchild.maligna.model.language.LanguageModel;
import net.loomchild.maligna.model.language.LanguageModelUtil;
import net.loomchild.maligna.model.translation.SourceData;
import net.loomchild.maligna.model.translation.TranslationModel;
import net.loomchild.maligna.model.translation.TranslationModelUtil;
import net.loomchild.maligna.model.vocabulary.Vocabulary;
import net.loomchild.maligna.model.vocabulary.VocabularyUtil;
import net.loomchild.maligna.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TranslationCalculator
implements Calculator {
    private static Log log = LogFactory.getLog(TranslationCalculator.class);
    public static final float MINIMUM_TRANSLATION_PROBABILITY = 1.0E-38f;
    private Vocabulary sourceVocabulary;
    private Vocabulary targetVocabulary;
    private LanguageModel sourceLanguageModel;
    private LanguageModel targetLanguageModel;
    private TranslationModel translationModel;
    private SplitAlgorithm splitAlgorithm;

    public TranslationCalculator(Vocabulary sourceVocabulary, Vocabulary targetVocabulary, LanguageModel sourceLanguageModel, LanguageModel targetLanguageModel, TranslationModel translationModel, SplitAlgorithm splitAlgorithm) {
        this.splitAlgorithm = splitAlgorithm;
        this.sourceVocabulary = sourceVocabulary;
        this.targetVocabulary = targetVocabulary;
        this.sourceLanguageModel = sourceLanguageModel;
        this.targetLanguageModel = targetLanguageModel;
        this.translationModel = translationModel;
    }

    public TranslationCalculator(Vocabulary sourceVocabulary, Vocabulary targetVocabulary, LanguageModel sourceLanguageModel, LanguageModel targetLanguageModel, TranslationModel translationModel) {
        this(sourceVocabulary, targetVocabulary, sourceLanguageModel, targetLanguageModel, translationModel, VocabularyUtil.DEFAULT_TOKENIZE_ALGORITHM);
    }

    public TranslationCalculator(List<Alignment> alignmentList, int trainIterationCount, SplitAlgorithm splitAlgorithm) {
        if (alignmentList.size() == 0) {
            throw new IllegalArgumentException("Reference corpus cannot be empty");
        }
        this.splitAlgorithm = splitAlgorithm;
        this.sourceVocabulary = new Vocabulary();
        this.targetVocabulary = new Vocabulary();
        ArrayList<List<Integer>> sourceWidList = new ArrayList<List<Integer>>();
        ArrayList<List<Integer>> targetWidList = new ArrayList<List<Integer>>();
        VocabularyUtil.tokenize(splitAlgorithm, alignmentList, this.sourceVocabulary, this.targetVocabulary, sourceWidList, targetWidList);
        this.sourceLanguageModel = LanguageModelUtil.train(sourceWidList);
        this.targetLanguageModel = LanguageModelUtil.train(targetWidList);
        this.translationModel = TranslationModelUtil.train(trainIterationCount, sourceWidList, targetWidList);
        if (log.isTraceEnabled()) {
            StringWriter writer = new StringWriter();
            this.translationModel.format(writer, this.sourceVocabulary, this.targetVocabulary);
            log.trace((Object)writer.toString());
        }
    }

    public TranslationCalculator(List<Alignment> alignmentList, int trainIterationCount) {
        this(alignmentList, trainIterationCount, VocabularyUtil.DEFAULT_TOKENIZE_ALGORITHM);
    }

    public TranslationCalculator(List<Alignment> alignmentList) {
        this(alignmentList, 4);
    }

    @Override
    public float calculateScore(List<String> sourceSegmentList, List<String> targetSegmentList) {
        float score;
        List<Integer> sourceWidList = VocabularyUtil.tokenize(this.splitAlgorithm, sourceSegmentList, this.sourceVocabulary);
        List<Integer> targetWidList = VocabularyUtil.tokenize(this.splitAlgorithm, targetSegmentList, this.targetVocabulary);
        if (sourceWidList.size() == 0 && targetWidList.size() == 0) {
            score = 0.0f;
        } else if (sourceWidList.size() == 0) {
            score = this.calculateLanguageScore(targetWidList, this.targetLanguageModel);
        } else {
            score = this.calculateLanguageScore(sourceWidList, this.sourceLanguageModel);
            if (targetWidList.size() > 0) {
                ArrayList<Integer> newSourceWidList = new ArrayList<Integer>(sourceWidList);
                newSourceWidList.add(0);
                score += this.calculateTranslationScore(newSourceWidList, targetWidList, this.translationModel);
            }
        }
        assert (score >= 0.0f) : score;
        return score;
    }

    private float calculateLanguageScore(List<Integer> widList, LanguageModel languageModel) {
        assert (widList.size() > 0);
        float score = 0.0f;
        for (Integer wid : widList) {
            float wordProbability = wid != null ? languageModel.getWordProbability(wid) : languageModel.getSingletonWordProbability();
            score = (float)((double)score + Util.toScore(wordProbability));
        }
        assert (score >= 0.0f) : score;
        return score;
    }

    private float calculateTranslationScore(List<Integer> sourceWidList, List<Integer> targetWidList, TranslationModel translationModel) {
        assert (targetWidList.size() > 0);
        float score = -((float)Math.log(1.0 / (double)sourceWidList.size())) * (float)targetWidList.size();
        for (Integer targetWid : targetWidList) {
            float translationProbability = 0.0f;
            if (targetWid != null) {
                for (Integer sourceWid : sourceWidList) {
                    if (sourceWid == null) continue;
                    SourceData sourceData = translationModel.get(sourceWid);
                    translationProbability = (float)((double)translationProbability + sourceData.getTranslationProbability(targetWid));
                }
            }
            translationProbability = Math.max(translationProbability, 1.0E-38f);
            score += -((float)Math.log(translationProbability));
        }
        return score;
    }
}

