/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPNTLMAuthentication;
import org.tmatesoft.svn.core.internal.util.jna.SVNWinSecurity;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class HTTPNativeNTLMAuthentication
extends HTTPNTLMAuthentication {
    private static final String NTLM_PROMPT_USER_PROPERTY = "svnkit.http.ntlm.promptUser";
    private SVNWinSecurity.SVNNTSecurityParameters myNTSecurityParameters;
    private String myLastToken;

    protected HTTPNativeNTLMAuthentication(String charset) {
        super(charset);
    }

    public static HTTPNativeNTLMAuthentication newInstance(String charset) {
        if (!SVNWinSecurity.isNativeLibraryAvailable()) {
            return null;
        }
        return new HTTPNativeNTLMAuthentication(charset);
    }

    @Override
    public String authenticate() throws SVNException {
        if (this.myState != 1 && this.myState != 3) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Unsupported message type in HTTP NTLM authentication");
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        if (this.myNTSecurityParameters == null) {
            String passwordString = this.getPassword() != null ? new String(this.getPassword()) : null;
            this.myNTSecurityParameters = SVNWinSecurity.getSecurityParams(this.getUserName(), passwordString, this.getDomain());
        }
        String response = "NTLM " + SVNWinSecurity.getAuthHeader(this.myLastToken, this.myNTSecurityParameters);
        if (this.myNTSecurityParameters.myCrdHandle == null) {
            this.myNTSecurityParameters = null;
        }
        if (this.isInType3State()) {
            this.setType1State();
            if (this.myLastToken != null) {
                this.myLastToken = null;
            }
        }
        return response;
    }

    @Override
    public void parseChallenge(String challenge) throws SVNException {
        this.myLastToken = challenge;
    }

    @Override
    public boolean isNative() {
        return true;
    }

    @Override
    public boolean allowPropmtForCredentials() {
        String prompt = System.getProperty(NTLM_PROMPT_USER_PROPERTY, "false");
        return Boolean.valueOf(prompt);
    }
}

