/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.VirtualSpace;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.VImage;
import javax.swing.ImageIcon;
import net.claribole.zgrviewer.ConfigManager;
import net.claribole.zgrviewer.GraphicsManager;

public class ToolPalette {
    GraphicsManager grMngr;
    static final String PALETTE_SPACE_NAME = "tps";
    VirtualSpace paletteSpace;
    Camera paletteCamera;
    static final short STD_NAV_MODE = 0;
    static final short FL_NAV_MODE = 1;
    static final short DM_NAV_MODE = 2;
    static final short PL_NAV_MODE = 3;
    static final short ML_NAV_MODE = 4;
    static final short HIGHLIGHT_MODE = 5;
    static final short BRING_AND_GO_MODE = 6;
    static final String[] ICON_PATHS = new String[]{"/images/stdnav24b.png", "/images/flnav24b.png", "/images/dmnav24b.png", "/images/plnav24b.png", "/images/mlnav24b.png", "/images/hl24b.png"};
    static final String[] SELECTED_ICON_PATHS = new String[]{"/images/stdnav24g.png", "/images/flnav24g.png", "/images/dmnav24g.png", "/images/plnav24g.png", "/images/mlnav24g.png", "/images/hl24g.png"};
    VImage[] buttons;
    VImage[] selectedButtons;
    static final int VERTICAL_STEP_BETWEEN_ICONS = 30;
    int selectedIconIndex = -1;
    boolean visible = false;
    boolean paintPalette = true;
    boolean enabled = true;
    static final int ANIM_TIME = 200;
    static final int TRIGGER_ZONE_WIDTH = 48;
    static final int TRIGGER_ZONE_HEIGHT = ICON_PATHS.length * 30 + 24;

    ToolPalette(GraphicsManager gm) {
        this.grMngr = gm;
        this.initZVTMelements();
    }

    void initZVTMelements() {
        this.paletteSpace = this.grMngr.vsm.addVirtualSpace(PALETTE_SPACE_NAME);
        this.paletteCamera = this.grMngr.vsm.addCamera(PALETTE_SPACE_NAME);
        this.paletteCamera.setAltitude(0.0f);
        this.buttons = new VImage[ICON_PATHS.length];
        this.selectedButtons = new VImage[ICON_PATHS.length];
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i] = new VImage(0L, -i * 30, 0, new ImageIcon(this.getClass().getResource(ICON_PATHS[i])).getImage());
            this.selectedButtons[i] = new VImage(0L, -i * 30, 0, new ImageIcon(this.getClass().getResource(SELECTED_ICON_PATHS[i])).getImage());
            this.buttons[i].setDrawBorderPolicy((short)1);
            this.selectedButtons[i].setDrawBorderPolicy((short)1);
            this.grMngr.vsm.addGlyph((Glyph)this.buttons[i], this.paletteSpace);
            this.grMngr.vsm.addGlyph((Glyph)this.selectedButtons[i], this.paletteSpace);
        }
        this.selectButton(this.buttons[0]);
    }

    void setEnabled(boolean b) {
        this.enabled = b;
        this.paletteCamera.setEnabled(b);
    }

    boolean isEnabled() {
        return this.enabled;
    }

    boolean isStdNavMode() {
        return this.selectedIconIndex == 0;
    }

    boolean isFadingLensNavMode() {
        return this.selectedIconIndex == 1;
    }

    boolean isDragMagNavMode() {
        return this.selectedIconIndex == 2;
    }

    boolean isProbingLensNavMode() {
        return this.selectedIconIndex == 3;
    }

    boolean isMeltingLensNavMode() {
        return this.selectedIconIndex == 4;
    }

    boolean isHighlightMode() {
        return this.selectedIconIndex == 5;
    }

    boolean isBringAndGoMode() {
        return this.selectedIconIndex == 6;
    }

    void selectButton(VImage icon) {
        int i;
        boolean newIconSelected = false;
        int oldSelectedIconIndex = this.selectedIconIndex;
        for (i = 0; i < this.buttons.length; ++i) {
            if (this.buttons[i] != icon) continue;
            this.paletteSpace.show(this.selectedButtons[i]);
            this.paletteSpace.hide(this.buttons[i]);
            this.selectedIconIndex = i;
            newIconSelected = true;
        }
        if (newIconSelected) {
            for (i = 0; i < this.selectedIconIndex; ++i) {
                this.paletteSpace.hide(this.selectedButtons[i]);
                this.paletteSpace.show(this.buttons[i]);
            }
            for (i = this.selectedIconIndex + 1; i < this.buttons.length; ++i) {
                this.paletteSpace.hide(this.selectedButtons[i]);
                this.paletteSpace.show(this.buttons[i]);
            }
            if (oldSelectedIconIndex == 2) {
                this.grMngr.killDM();
            } else if (oldSelectedIconIndex == 6) {
                this.grMngr.exitBringAndGoMode();
            } else if (oldSelectedIconIndex == 0) {
                this.grMngr.mainView.getCursor().activateDynaSpot(false);
            }
            if (this.selectedIconIndex == 6) {
                this.grMngr.enterBringAndGoMode();
            } else if (this.selectedIconIndex == 0 && ConfigManager.DYNASPOT) {
                try {
                    this.grMngr.mainView.getCursor().activateDynaSpot(true);
                }
                catch (NullPointerException ex) {
                    // empty catch block
                }
            }
        }
    }

    void displayPalette(boolean b) {
        if (this.paintPalette == b) {
            return;
        }
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setVisible(b);
            this.selectedButtons[i].setVisible(b);
        }
        this.paintPalette = b;
    }

    void updateHiddenPosition() {
        long[] wnes = this.grMngr.mainView.getVisibleRegion(this.paletteCamera);
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].moveTo(wnes[0] - this.buttons[i].getWidth() + 1L, wnes[1] - (long)((i + 1) * 30));
            this.selectedButtons[i].moveTo(wnes[0] - this.buttons[i].getWidth() + 1L, wnes[1] - (long)((i + 1) * 30));
        }
        this.displayPalette(true);
    }

    void show() {
        if (!this.visible) {
            this.visible = true;
            this.grMngr.meh.toolPaletteIsActive = true;
            this.grMngr.vsm.animator.createCameraAnimation(200L, (short)2, new LongPoint(-2L * this.buttons[0].getWidth() - 5L, 0L), this.paletteCamera.getID(), null);
            this.grMngr.mainView.setCursorIcon(12);
            this.grMngr.mainView.setActiveLayer(2);
        }
    }

    void hide() {
        if (this.visible) {
            this.visible = false;
            this.grMngr.vsm.animator.createCameraAnimation(200L, (short)2, new LongPoint(2L * this.buttons[0].getWidth() + 5L, 0L), this.paletteCamera.getID(), null);
            this.grMngr.mainView.setCursorIcon(-1);
            this.grMngr.mainView.setActiveLayer(0);
            this.grMngr.meh.toolPaletteIsActive = false;
        }
    }

    boolean insidePaletteTriggerZone(int jpx, int jpy) {
        return this.paintPalette && jpx < 48 && jpy < TRIGGER_ZONE_HEIGHT;
    }

    boolean isShowing() {
        return this.visible;
    }

    Camera getPaletteCamera() {
        return this.paletteCamera;
    }

    void showLogicalTools() {
        for (int i = 5; i <= 5; ++i) {
            if (!this.buttons[i].isSensitive()) {
                this.buttons[i].setSensitivity(true);
            }
            if (!this.buttons[i].isVisible()) {
                this.buttons[i].setVisible(true);
            }
            if (!this.selectedButtons[i].isSensitive()) {
                this.selectedButtons[i].setSensitivity(true);
            }
            if (this.selectedButtons[i].isVisible()) continue;
            this.selectedButtons[i].setVisible(true);
        }
    }

    void hideLogicalTools() {
        if (this.isHighlightMode() || this.isBringAndGoMode()) {
            this.selectButton(this.buttons[0]);
        }
        for (int i = 5; i <= 6; ++i) {
            if (this.buttons[i].isSensitive()) {
                this.buttons[i].setSensitivity(false);
            }
            if (this.buttons[i].isVisible()) {
                this.buttons[i].setVisible(false);
            }
            if (this.selectedButtons[i].isSensitive()) {
                this.selectedButtons[i].setSensitivity(false);
            }
            if (!this.selectedButtons[i].isVisible()) continue;
            this.selectedButtons[i].setVisible(false);
        }
    }
}

