/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Properties;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.network.SocketServer;
import kafka.security.minikdc.MiniKdc;
import kafka.server.ApiVersionsRequestTest$;
import kafka.server.BaseRequestTest;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0001\u0003\u0001\u001d\u0011!dU1tY\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e+fgRT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!a\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\bCA\u0007\u0011\u001b\u0005q!BA\b\u0005\u0003\r\t\u0007/[\u0005\u0003#9\u0011\u0011bU1tYN+G/\u001e9\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002CA\u0005\u0001\u0011\u00159\u0002\u0001\"\u0015\u0019\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G.F\u0001\u001a!\tQb%D\u0001\u001c\u0015\taR$\u0001\u0003bkRD'B\u0001\u0010 \u0003!\u0019XmY;sSRL(B\u0001\u0011\"\u0003\u0019\u0019w.\\7p]*\u0011QA\t\u0006\u0003G\u0011\na!\u00199bG\",'\"A\u0013\u0002\u0007=\u0014x-\u0003\u0002(7\t\u00012+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\u0005\bS\u0001\u0011\r\u0011\"\u0003+\u0003aY\u0017MZ6b\u00072LWM\u001c;TCNdW*Z2iC:L7/\\\u000b\u0002WA\u0011A&M\u0007\u0002[)\u0011afL\u0001\u0005Y\u0006twMC\u00011\u0003\u0011Q\u0017M^1\n\u0005Ij#AB*ue&tw\r\u0003\u00045\u0001\u0001\u0006IaK\u0001\u001aW\u000647.Y\"mS\u0016tGoU1tY6+7\r[1oSNl\u0007\u0005C\u00047\u0001\t\u0007I\u0011B\u001c\u00023-\fgm[1TKJ4XM]*bg2lUm\u00195b]&\u001cXn]\u000b\u0002qA\u0019\u0011\bQ\u0016\u000e\u0003iR!a\u000f\u001f\u0002\u0013%lW.\u001e;bE2,'BA\u001f?\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002\u007f\u0005)1oY1mC&\u0011\u0011I\u000f\u0002\u0005\u0019&\u001cH\u000f\u0003\u0004D\u0001\u0001\u0006I\u0001O\u0001\u001bW\u000647.Y*feZ,'oU1tY6+7\r[1oSNl7\u000f\t\u0005\b\u000b\u0002\u0011\r\u0011\"\u0015G\u0003Q\u0019XM\u001d<feN\u000b7\u000f\u001c)s_B,'\u000f^5fgV\tq\tE\u0002I\u0013.k\u0011AP\u0005\u0003\u0015z\u0012AaU8nKB\u0011AjT\u0007\u0002\u001b*\u0011ajL\u0001\u0005kRLG.\u0003\u0002Q\u001b\nQ\u0001K]8qKJ$\u0018.Z:\t\rI\u0003\u0001\u0015!\u0003H\u0003U\u0019XM\u001d<feN\u000b7\u000f\u001c)s_B,'\u000f^5fg\u0002Bq\u0001\u0016\u0001C\u0002\u0013Ec)\u0001\u000bdY&,g\u000e^*bg2\u0004&o\u001c9feRLWm\u001d\u0005\u0007-\u0002\u0001\u000b\u0011B$\u0002+\rd\u0017.\u001a8u'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3tA!)\u0001\f\u0001C!3\u0006Qa.^7Ce>\\WM]:\u0016\u0003i\u0003\"\u0001S.\n\u0005qs$aA%oi\")a\f\u0001C!?\u0006)1/\u001a;VaR\t\u0001\r\u0005\u0002IC&\u0011!M\u0010\u0002\u0005+:LG\u000f\u000b\u0002^IB\u0011Q\r[\u0007\u0002M*\u0011q\rJ\u0001\u0006UVt\u0017\u000e^\u0005\u0003S\u001a\u0014aAQ3g_J,\u0007\"B6\u0001\t\u0003z\u0016\u0001\u0003;fCJ$un\u001e8)\u0005)l\u0007CA3o\u0013\tygMA\u0003BMR,'\u000fC\u0003r\u0001\u0011\u0005q,\u0001\u0019uKN$\u0018\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u\u0005\u00164wN]3TCNd\u0007*\u00198eg\"\f7.\u001a*fcV,7\u000f\u001e\u0015\u0003aN\u0004\"!\u001a;\n\u0005U4'\u0001\u0002+fgRDQa\u001e\u0001\u0005\u0002}\u000bq\u0006^3ti\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f^!gi\u0016\u00148+Y:m\u0011\u0006tGm\u001d5bW\u0016\u0014V-];fgRD#A^:\t\u000bi\u0004A\u0011A0\u0002YQ,7\u000f^!qSZ+'o]5p]N\u0014V-];fgR<\u0016\u000e\u001e5V]N,\b\u000f]8si\u0016$g+\u001a:tS>t\u0007FA=t\u0011\u0015i\b\u0001\"\u0003\u007f\u0003Y\u0019XM\u001c3Ba&4VM]:j_:\u001c(+Z9vKN$HcB@\u0002\f\u0005m\u0011Q\u0005\t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011QA\u0010\u0002\u0011I,\u0017/^3tiNLA!!\u0003\u0002\u0004\t\u0019\u0012\t]5WKJ\u001c\u0018n\u001c8t%\u0016\u001c\bo\u001c8tK\"9\u0011Q\u0002?A\u0002\u0005=\u0011AB:pG.,G\u000f\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)bL\u0001\u0004]\u0016$\u0018\u0002BA\r\u0003'\u0011aaU8dW\u0016$\bbBA\u000fy\u0002\u0007\u0011qD\u0001\be\u0016\fX/Z:u!\u0011\t\t!!\t\n\t\u0005\r\u00121\u0001\u0002\u0013\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cH\u000fC\u0005\u0002(q\u0004\n\u00111\u0001\u0002*\u0005Q\u0011\r]5WKJ\u001c\u0018n\u001c8\u0011\u000b!\u000bY#a\f\n\u0007\u00055bH\u0001\u0004PaRLwN\u001c\t\u0004\u0011\u0006E\u0012bAA\u001a}\t)1\u000b[8si\"9\u0011q\u0007\u0001\u0005\n\u0005e\u0012\u0001K:f]\u0012\u001c\u0016m\u001d7IC:$7\u000f[1lKJ+\u0017/^3tiZ\u000bG.\u001b3bi\u0016\u0014Vm\u001d9p]N,Gc\u00011\u0002<!A\u0011QBA\u001b\u0001\u0004\ty\u0001C\u0005\u0002@\u0001\t\n\u0011\"\u0003\u0002B\u0005\u00013/\u001a8e\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019E\u000b\u0003\u0002*\u0005\u00153FAA$!\u0011\tI%a\u0015\u000e\u0005\u0005-#\u0002BA'\u0003\u001f\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Ec(\u0001\u0006b]:|G/\u0019;j_:LA!!\u0016\u0002L\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class SaslApiVersionsRequestTest
extends BaseRequestTest
implements SaslSetup {
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$(this, zkConnect, userName, password);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    public int numBrokers() {
        return 1;
    }

    @Override
    @Before
    public void setUp() {
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, JaasTestUtils$.MODULE$.KafkaServerContextName()));
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testApiVersionsRequestBeforeSaslHandshakeRequest() {
        SecurityProtocol x$1 = this.securityProtocol();
        SocketServer x$2 = this.connect$default$1();
        try (Socket plaintextSocket = this.connect(x$2, x$1);){
            ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(plaintextSocket, new ApiVersionsRequest.Builder().build((short)0), this.sendApiVersionsRequest$default$3());
            ApiVersionsRequestTest$.MODULE$.validateApiVersionsResponse(apiVersionsResponse);
            this.sendSaslHandshakeRequestValidateResponse(plaintextSocket);
        }
    }

    @Test
    public void testApiVersionsRequestAfterSaslHandshakeRequest() {
        SecurityProtocol x$3 = this.securityProtocol();
        SocketServer x$4 = this.connect$default$1();
        try (Socket plaintextSocket = this.connect(x$4, x$3);){
            this.sendSaslHandshakeRequestValidateResponse(plaintextSocket);
            ApiVersionsResponse response = this.sendApiVersionsRequest(plaintextSocket, new ApiVersionsRequest.Builder().build((short)0), this.sendApiVersionsRequest$default$3());
            Assert.assertEquals((Object)Errors.ILLEGAL_SASL_STATE, (Object)response.error());
        }
    }

    @Test
    public void testApiVersionsRequestWithUnsupportedVersion() {
        SecurityProtocol x$5 = this.securityProtocol();
        SocketServer x$6 = this.connect$default$1();
        try (Socket plaintextSocket = this.connect(x$6, x$5);){
            ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest(0);
            ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(plaintextSocket, apiVersionsRequest, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)));
            Assert.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)apiVersionsResponse.error());
            ApiVersionsResponse apiVersionsResponse2 = this.sendApiVersionsRequest(plaintextSocket, new ApiVersionsRequest.Builder().build((short)0), this.sendApiVersionsRequest$default$3());
            ApiVersionsRequestTest$.MODULE$.validateApiVersionsResponse(apiVersionsResponse2);
            this.sendSaslHandshakeRequestValidateResponse(plaintextSocket);
        }
    }

    private ApiVersionsResponse sendApiVersionsRequest(Socket socket, ApiVersionsRequest request, Option<Object> apiVersion) {
        ByteBuffer response = this.sendAndReceive((AbstractRequest)request, ApiKeys.API_VERSIONS, socket, apiVersion);
        return ApiVersionsResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private Option<Object> sendApiVersionsRequest$default$3() {
        return None$.MODULE$;
    }

    private void sendSaslHandshakeRequestValidateResponse(Socket socket) {
        SaslHandshakeRequest request = new SaslHandshakeRequest("PLAIN");
        ByteBuffer response = this.sendAndReceive((AbstractRequest)request, ApiKeys.SASL_HANDSHAKE, socket, this.sendAndReceive$default$4());
        SaslHandshakeResponse handshakeResponse = SaslHandshakeResponse.parse((ByteBuffer)response, (short)request.version());
        Assert.assertEquals((Object)Errors.NONE, (Object)handshakeResponse.error());
        Assert.assertEquals(Collections.singletonList("PLAIN"), (Object)handshakeResponse.enabledMechanisms());
    }

    public SaslApiVersionsRequestTest() {
        SaslSetup.$init$(this);
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PLAIN"}));
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
    }
}

