/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Objects;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.AbstractStoreBuilder;
import org.apache.kafka.streams.state.internals.CachingKeyValueStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.MeteredKeyValueBytesStore;

public class KeyValueStoreBuilder<K, V>
extends AbstractStoreBuilder<K, V, KeyValueStore<K, V>> {
    private final KeyValueBytesStoreSupplier storeSupplier;

    public KeyValueStoreBuilder(KeyValueBytesStoreSupplier storeSupplier, Serde<K> keySerde, Serde<V> valueSerde, Time time) {
        super(storeSupplier.name(), keySerde, valueSerde, time);
        Objects.requireNonNull(storeSupplier, "bytesStoreSupplier can't be null");
        this.storeSupplier = storeSupplier;
    }

    @Override
    public KeyValueStore<K, V> build() {
        return new MeteredKeyValueBytesStore(this.maybeWrapCaching(this.maybeWrapLogging((KeyValueStore)this.storeSupplier.get())), this.storeSupplier.metricsScope(), this.time, this.keySerde, this.valueSerde);
    }

    private KeyValueStore<Bytes, byte[]> maybeWrapCaching(KeyValueStore<Bytes, byte[]> inner) {
        if (!this.enableCaching) {
            return inner;
        }
        return new CachingKeyValueStore(inner, this.keySerde, this.valueSerde);
    }

    private KeyValueStore<Bytes, byte[]> maybeWrapLogging(KeyValueStore<Bytes, byte[]> inner) {
        if (!this.enableLogging) {
            return inner;
        }
        return new ChangeLoggingKeyValueBytesStore(inner);
    }
}

