/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.xmpp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.RtpEncodingDesc;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.rtp.SsrcAssociationType;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceGroupPacketExtension;
import org.jitsi.xmpp.extensions.jitsimeet.SSRCInfoPacketExtension;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.util.XmppStringUtils;

public class MediaSourceFactory {
    private static final Logger logger = new LoggerImpl(MediaSourceFactory.class.getName());
    private static final int VP8_SIMULCAST_TEMPORAL_LAYERS = 3;
    private static final int VP8_SIMULCAST_BASE_LAYER_HEIGHT = 180;
    private static Map<String, SsrcAssociationType> secondarySsrcTypeMap = null;
    private static final RtpLayerDesc[] noDependencies = new RtpLayerDesc[0];

    private static synchronized Map<String, SsrcAssociationType> getSecondarySsrcTypeMap() {
        if (secondarySsrcTypeMap == null) {
            secondarySsrcTypeMap = new HashMap<String, SsrcAssociationType>();
            secondarySsrcTypeMap.put("FID", SsrcAssociationType.RTX);
        }
        return secondarySsrcTypeMap;
    }

    private static RtpLayerDesc[] createRTPLayerDescs(int spatialLen, int temporalLen, int encodingIdx, int height) {
        RtpLayerDesc[] rtpLayers = new RtpLayerDesc[spatialLen * temporalLen];
        for (int spatialIdx = 0; spatialIdx < spatialLen; ++spatialIdx) {
            double frameRate = 30.0 / (double)(1 << temporalLen - 1);
            for (int temporalIdx = 0; temporalIdx < temporalLen; ++temporalIdx) {
                int idx = MediaSourceFactory.idx(spatialIdx, temporalIdx, temporalLen);
                RtpLayerDesc[] dependencies = spatialIdx > 0 && temporalIdx > 0 ? new RtpLayerDesc[]{rtpLayers[MediaSourceFactory.idx(spatialIdx, temporalIdx - 1, temporalLen)], rtpLayers[MediaSourceFactory.idx(spatialIdx - 1, temporalIdx, temporalLen)]} : (spatialIdx > 0 ? new RtpLayerDesc[]{rtpLayers[MediaSourceFactory.idx(spatialIdx - 1, temporalIdx, temporalLen)]} : (temporalIdx > 0 ? new RtpLayerDesc[]{rtpLayers[MediaSourceFactory.idx(spatialIdx, temporalIdx - 1, temporalLen)]} : noDependencies));
                int temporalId = temporalLen > 1 ? temporalIdx : -1;
                int spatialId = spatialLen > 1 ? spatialIdx : -1;
                rtpLayers[idx] = new RtpLayerDesc(encodingIdx, temporalId, spatialId, height, frameRate, dependencies);
                frameRate *= 2.0;
            }
        }
        return rtpLayers;
    }

    private static RtpEncodingDesc createRtpEncodingDesc(Long primarySsrc, int spatialLen, int temporalLen, SecondarySsrcs secondarySsrcs, int encodingIdx, int height) {
        RtpLayerDesc[] layers = MediaSourceFactory.createRTPLayerDescs(spatialLen, temporalLen, encodingIdx, height);
        RtpEncodingDesc enc = new RtpEncodingDesc(primarySsrc, layers, encodingIdx);
        if (secondarySsrcs != null) {
            secondarySsrcs.forEach(ssrcSecondarySsrc -> {
                SsrcAssociationType type2 = MediaSourceFactory.getSecondarySsrcTypeMap().get(ssrcSecondarySsrc.type);
                if (type2 == null) {
                    logger.error("Unable to find a mapping for secondary ssrc type " + ssrcSecondarySsrc.type + " will NOT included this secondary ssrc as an encoding");
                } else {
                    enc.addSecondarySsrc(ssrcSecondarySsrc.ssrc, type2);
                }
            });
        }
        return enc;
    }

    private static List<SecondarySsrc> getSecondarySsrcs(long ssrc2, Collection<SourceGroupPacketExtension> sourceGroups) {
        ArrayList<SecondarySsrc> secondarySsrcs = new ArrayList<SecondarySsrc>();
        for (SourceGroupPacketExtension sourceGroup : sourceGroups) {
            if (sourceGroup.getSemantics().equalsIgnoreCase("SIM")) continue;
            long groupPrimarySsrc = sourceGroup.getSources().get(0).getSSRC();
            long groupSecondarySsrc = sourceGroup.getSources().get(1).getSSRC();
            if (groupPrimarySsrc != ssrc2) continue;
            secondarySsrcs.add(new SecondarySsrc(groupSecondarySsrc, sourceGroup.getSemantics()));
        }
        return secondarySsrcs;
    }

    private static Map<Long, SecondarySsrcs> getAllSecondarySsrcs(SourceSsrcs ssrcs2, Collection<SourceGroupPacketExtension> sourceGroups) {
        HashMap<Long, SecondarySsrcs> allSecondarySsrcs = new HashMap<Long, SecondarySsrcs>();
        for (long ssrc2 : ssrcs2) {
            List<SecondarySsrc> secondarySsrcs = MediaSourceFactory.getSecondarySsrcs(ssrc2, sourceGroups);
            allSecondarySsrcs.put(ssrc2, new SecondarySsrcs(secondarySsrcs));
        }
        return allSecondarySsrcs;
    }

    private static List<SourceGroupPacketExtension> getGroups(String semantics, List<SourceGroupPacketExtension> groups2) {
        return groups2.stream().filter(sg -> sg.getSemantics().equalsIgnoreCase(semantics)).collect(Collectors.toList());
    }

    private static void removeReferences(SourceSsrcs sourceSsrcs, List<SourcePacketExtension> sources, List<SourceGroupPacketExtension> sourceGroups) {
        List<SourceGroupPacketExtension> groupsToRemove = sourceGroups.stream().filter(group -> group.getSources().stream().anyMatch(source -> sourceSsrcs.contains(source.getSSRC()))).collect(Collectors.toList());
        sourceGroups.removeAll(groupsToRemove);
        Set<Long> ssrcsToRemove = MediaSourceFactory.extractSsrcs(groupsToRemove);
        sources.removeIf(source -> sourceSsrcs.contains(source.getSSRC()) || ssrcsToRemove.contains(source.getSSRC()));
    }

    private static Set<Long> extractSsrcs(List<SourceGroupPacketExtension> groups2) {
        HashSet<Long> ssrcs2 = new HashSet<Long>();
        groups2.forEach(group -> group.getSources().forEach(source -> ssrcs2.add(source.getSSRC())));
        return ssrcs2;
    }

    private static List<SourceSsrcs> getSourceSsrcs(Collection<SourcePacketExtension> sources, Collection<SourceGroupPacketExtension> sourceGroups) {
        ArrayList<SourceSsrcs> sourceSsrcsList = new ArrayList<SourceSsrcs>();
        ArrayList<SourcePacketExtension> sourcesCopy = new ArrayList<SourcePacketExtension>(sources);
        ArrayList<SourceGroupPacketExtension> sourceGroupsCopy = new ArrayList<SourceGroupPacketExtension>(sourceGroups);
        Arrays.asList("SIM", "FID", "FEC-FR").forEach(groupSem -> {
            List<SourceGroupPacketExtension> groups2 = MediaSourceFactory.getGroups(groupSem, sourceGroupsCopy);
            groups2.forEach(group -> {
                if (group.getSources() == null || group.getSources().isEmpty()) {
                    if (groups2.size() > 1) {
                        logger.warn("Received empty group, which is a signal to clear all groups, but there were other groups present, which shouldn't happen");
                    }
                    return;
                }
                List<Long> ssrcs2 = groupSem.equalsIgnoreCase("SIM") ? group.getSources().stream().map(SourcePacketExtension::getSSRC).collect(Collectors.toList()) : Arrays.asList(group.getSources().get(0).getSSRC());
                SourceSsrcs sourceSsrcs = new SourceSsrcs(ssrcs2);
                MediaSourceFactory.removeReferences(sourceSsrcs, sourcesCopy, sourceGroupsCopy);
                sourceSsrcsList.add(sourceSsrcs);
            });
        });
        if (!sourceGroupsCopy.isEmpty()) {
            logger.warn("Unprocessed source groups: " + sourceGroupsCopy.stream().map(e -> e.toXML(XmlEnvironment.EMPTY)).reduce(String::concat));
        }
        sourcesCopy.forEach(source -> {
            if (source.getSSRC() != -1L) {
                sourceSsrcsList.add(new SourceSsrcs(source.getSSRC()));
            } else if (sourcesCopy.size() > 1) {
                logger.warn("Received an empty source, which is a signal to clear all sources, but there were other sources present, which shouldn't happen");
            }
        });
        MediaSourceFactory.setOwnersAndNames(sources, sourceSsrcsList);
        return sourceSsrcsList;
    }

    private static void setOwnersAndNames(Collection<SourcePacketExtension> sources, Collection<SourceSsrcs> sourceSsrcsList) {
        for (SourceSsrcs sourceSsrcs : sourceSsrcsList) {
            long primarySsrc = sourceSsrcs.get(0);
            SourcePacketExtension sourceSource = sources.stream().filter(source -> source.getSSRC() == primarySsrc).findAny().orElse(null);
            sourceSsrcs.owner = MediaSourceFactory.getOwner(sourceSource);
            sourceSsrcs.name = sourceSource != null ? sourceSource.getName() : null;
        }
    }

    public static String getOwner(SourcePacketExtension source) {
        String ownerAttr;
        SSRCInfoPacketExtension ssrcInfoPacketExtension;
        SSRCInfoPacketExtension sSRCInfoPacketExtension = ssrcInfoPacketExtension = source == null ? null : source.getFirstChildOfType(SSRCInfoPacketExtension.class);
        if (ssrcInfoPacketExtension != null && (ownerAttr = ssrcInfoPacketExtension.getAttributeAsString("owner")) != null) {
            return MediaSourceFactory.getResourceFromJid(ownerAttr);
        }
        return null;
    }

    private static String getResourceFromJid(String jid) {
        String unpreppedResource = XmppStringUtils.parseResource(jid);
        if (unpreppedResource.isEmpty()) {
            return Resourcepart.EMPTY.toString();
        }
        return Resourcepart.fromOrThrowUnchecked(unpreppedResource).toString();
    }

    @Deprecated
    public static MediaSourceDesc[] createMediaSources(Collection<SourcePacketExtension> sources, Collection<SourceGroupPacketExtension> sourceGroups) {
        ArrayList<SourceGroupPacketExtension> finalSourceGroups;
        ArrayList<SourceGroupPacketExtension> arrayList = finalSourceGroups = sourceGroups == null ? new ArrayList<SourceGroupPacketExtension>() : sourceGroups;
        if (sources == null) {
            sources = new ArrayList<SourcePacketExtension>();
        }
        List<SourceSsrcs> sourceSsrcsList = MediaSourceFactory.getSourceSsrcs(sources, finalSourceGroups);
        ArrayList mediaSources2 = new ArrayList();
        sourceSsrcsList.forEach(sourceSsrcs -> {
            int numSpatialLayersPerStream = 1;
            int numTemporalLayersPerStream = 3;
            Map<Long, SecondarySsrcs> secondarySsrcs = MediaSourceFactory.getAllSecondarySsrcs(sourceSsrcs, finalSourceGroups);
            MediaSourceDesc mediaSource = MediaSourceFactory.createSource(sourceSsrcs, numSpatialLayersPerStream, 3, secondarySsrcs, sourceSsrcs.owner, sourceSsrcs.name);
            mediaSources2.add(mediaSource);
        });
        return mediaSources2.toArray(new MediaSourceDesc[0]);
    }

    public static MediaSourceDesc createMediaSource(Collection<SourcePacketExtension> sources, Collection<SourceGroupPacketExtension> sourceGroups, String owner, String name) {
        ArrayList<SourceGroupPacketExtension> finalSourceGroups;
        Objects.requireNonNull(owner, "owner is required");
        Objects.requireNonNull(name, "name is required");
        ArrayList<SourceGroupPacketExtension> arrayList = finalSourceGroups = sourceGroups == null ? new ArrayList<SourceGroupPacketExtension>() : sourceGroups;
        if (sources == null) {
            return null;
        }
        List<SourceSsrcs> sourceSsrcsList = MediaSourceFactory.getSourceSsrcs(sources, finalSourceGroups);
        if (sourceSsrcsList.size() != 1) {
            logger.warn("sourceSsrcsList.size() != 1 for: " + sources + " groups: " + finalSourceGroups);
        }
        if (sourceSsrcsList.size() > 0) {
            SourceSsrcs sourceSsrcs = sourceSsrcsList.get(0);
            int numSpatialLayersPerStream = 1;
            int numTemporalLayersPerStream = 3;
            Map<Long, SecondarySsrcs> secondarySsrcs = MediaSourceFactory.getAllSecondarySsrcs(sourceSsrcs, finalSourceGroups);
            return MediaSourceFactory.createSource(sourceSsrcs, numSpatialLayersPerStream, 3, secondarySsrcs, owner, name);
        }
        return null;
    }

    private static int idx(int spatialIdx, int temporalIdx, int temporalLen) {
        return spatialIdx * temporalLen + temporalIdx;
    }

    private static MediaSourceDesc createSource(SourceSsrcs primarySsrcs, int numSpatialLayersPerStream, int numTemporalLayersPerStream, Map<Long, SecondarySsrcs> allSecondarySsrcs, String owner, String name) {
        RtpEncodingDesc[] encodings = new RtpEncodingDesc[primarySsrcs.size()];
        int height = 180;
        for (int encodingIdx = 0; encodingIdx < primarySsrcs.size(); ++encodingIdx) {
            Long primarySsrc = primarySsrcs.get(encodingIdx);
            SecondarySsrcs ssrcSecondarySsrcs = allSecondarySsrcs.get(primarySsrc);
            encodings[encodingIdx] = MediaSourceFactory.createRtpEncodingDesc(primarySsrc, numSpatialLayersPerStream, numTemporalLayersPerStream, ssrcSecondarySsrcs, encodingIdx, height);
            height *= 2;
        }
        if (name == null) {
            throw new IllegalArgumentException("The 'name' is missing in the source description");
        }
        if (owner == null) {
            throw new IllegalArgumentException("The 'owner' is missing in the source description");
        }
        return new MediaSourceDesc(encodings, owner, name);
    }

    private static class SecondarySsrcs
    implements Iterable<SecondarySsrc> {
        public List<SecondarySsrc> secondarySsrcs;

        public SecondarySsrcs(List<SecondarySsrc> secondarySsrcs) {
            this.secondarySsrcs = secondarySsrcs;
        }

        @Override
        public Iterator<SecondarySsrc> iterator() {
            return this.secondarySsrcs.iterator();
        }
    }

    private static class SecondarySsrc {
        public long ssrc;
        public String type;

        public SecondarySsrc(long ssrc2, String type2) {
            this.ssrc = ssrc2;
            this.type = type2;
        }
    }

    private static class SourceSsrcs
    implements Iterable<Long> {
        private String name;
        private List<Long> sourceSsrcs;
        private String owner;

        private SourceSsrcs(Long ssrc2) {
            this(Collections.singletonList(ssrc2));
        }

        public SourceSsrcs(List<Long> sourceSsrcs) {
            this.sourceSsrcs = sourceSsrcs;
        }

        public boolean contains(Long ssrc2) {
            return this.sourceSsrcs.contains(ssrc2);
        }

        public int size() {
            return this.sourceSsrcs.size();
        }

        public Long get(int index) {
            return this.sourceSsrcs.get(index);
        }

        @Override
        public Iterator<Long> iterator() {
            return this.sourceSsrcs.iterator();
        }
    }
}

