/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import jakarta.servlet.annotation.WebInitParam;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.eclipse.jetty.servlet.BaseHolder;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.servlet.Source;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.DiscoveredAnnotation;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.Origin;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServletAnnotation
extends DiscoveredAnnotation {
    private static final Logger LOG = LoggerFactory.getLogger(WebServletAnnotation.class);

    public WebServletAnnotation(WebAppContext context, String className) {
        super(context, className);
    }

    public WebServletAnnotation(WebAppContext context, String className, Resource resource) {
        super(context, className, resource);
    }

    @Override
    public void apply() {
        Class<?> clazz = this.getTargetClass();
        if (clazz == null) {
            LOG.warn("{} cannot be loaded", (Object)this._className);
            return;
        }
        if (!HttpServlet.class.isAssignableFrom(clazz)) {
            LOG.warn("{} is not assignable from jakarta.servlet.http.HttpServlet", (Object)clazz.getName());
            return;
        }
        WebServlet annotation = clazz.getAnnotation(WebServlet.class);
        if (annotation.urlPatterns().length > 0 && annotation.value().length > 0) {
            LOG.warn("{} defines both @WebServlet.value and @WebServlet.urlPatterns", (Object)clazz.getName());
            return;
        }
        String[] urlPatterns = annotation.value();
        if (urlPatterns.length == 0) {
            urlPatterns = annotation.urlPatterns();
        }
        if (urlPatterns.length == 0) {
            LOG.warn("{} defines neither @WebServlet.value nor @WebServlet.urlPatterns", (Object)clazz.getName());
            return;
        }
        ArrayList<String> urlPatternList = new ArrayList<String>();
        for (String p : urlPatterns) {
            urlPatternList.add(ServletPathSpec.normalize(p));
        }
        String servletName = annotation.name().equals("") ? clazz.getName() : annotation.name();
        MetaData metaData = this._context.getMetaData();
        ServletMapping mapping = null;
        ServletHolder[] holders = this._context.getServletHandler().getServlets();
        BaseHolder holder = null;
        if (holders != null) {
            for (ServletHolder h2 : holders) {
                if (h2.getName() == null || !servletName.equals(h2.getName())) continue;
                holder = h2;
                break;
            }
        }
        if (holder == null) {
            WebInitParam[] source = new Source(Source.Origin.ANNOTATION, clazz.getName());
            holder = this._context.getServletHandler().newServletHolder((Source)source);
            ((Holder)holder).setHeldClass(clazz);
            metaData.setOrigin(servletName + ".servlet.servlet-class", annotation, clazz);
            ((Holder)holder).setName(servletName);
            ((Holder)holder).setDisplayName(annotation.displayName());
            metaData.setOrigin(servletName + ".servlet.display-name", annotation, clazz);
            ((ServletHolder)holder).setInitOrder(annotation.loadOnStartup());
            metaData.setOrigin(servletName + ".servlet.load-on-startup", annotation, clazz);
            ((Holder)holder).setAsyncSupported(annotation.asyncSupported());
            metaData.setOrigin(servletName + ".servlet.async-supported", annotation, clazz);
            for (WebInitParam ip : annotation.initParams()) {
                ((Holder)holder).setInitParameter(ip.name(), ip.value());
                metaData.setOrigin(servletName + ".servlet.init-param." + ip.name(), ip, clazz);
            }
            this._context.getServletHandler().addServlet((ServletHolder)holder);
            mapping = new ServletMapping((Source)source);
            mapping.setServletName(((Holder)holder).getName());
            mapping.setPathSpecs(LazyList.toStringArray(urlPatternList));
            this._context.getMetaData().setOrigin(servletName + ".servlet.mapping." + Long.toHexString(mapping.hashCode()), annotation, clazz);
        } else {
            if (holder.getClassName() == null) {
                ((Holder)holder).setClassName(clazz.getName());
            }
            if (holder.getHeldClass() == null) {
                ((Holder)holder).setHeldClass(clazz);
            }
            for (WebInitParam ip : annotation.initParams()) {
                if (metaData.getOrigin(servletName + ".servlet.init-param." + ip.name()) != Origin.NotSet) continue;
                ((Holder)holder).setInitParameter(ip.name(), ip.value());
                metaData.setOrigin(servletName + ".servlet.init-param." + ip.name(), ip, clazz);
            }
            List<ServletMapping> existingMappings = this.getServletMappingsForServlet(servletName);
            if (existingMappings.isEmpty() || !this.containsNonDefaultMappings(existingMappings)) {
                mapping = new ServletMapping(new Source(Source.Origin.ANNOTATION, clazz.getName()));
                mapping.setServletName(servletName);
                mapping.setPathSpecs(LazyList.toStringArray(urlPatternList));
                this._context.getMetaData().setOrigin(servletName + ".servlet.mapping." + Long.toHexString(mapping.hashCode()), annotation, clazz);
            }
        }
        if (mapping != null) {
            List<ServletMapping> allMappings = ArrayUtil.asMutableList(this._context.getServletHandler().getServletMappings());
            for (String p : urlPatternList) {
                ServletMapping existingMapping = this._context.getServletHandler().getServletMapping(p);
                if (existingMapping != null && existingMapping.isFromDefaultDescriptor()) {
                    String[] updatedPaths = ArrayUtil.removeFromArray(existingMapping.getPathSpecs(), p);
                    if (updatedPaths == null || updatedPaths.length == 0) {
                        boolean success = allMappings.remove(existingMapping);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Removed empty mapping {} from defaults descriptor success:{}", (Object)existingMapping, (Object)success);
                        }
                    } else {
                        existingMapping.setPathSpecs(updatedPaths);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Removed path {} from mapping {} from defaults descriptor ", (Object)p, (Object)existingMapping);
                        }
                    }
                }
                this._context.getMetaData().setOrigin(servletName + ".servlet.mapping.url" + p, annotation, clazz);
            }
            allMappings.add(mapping);
            this._context.getServletHandler().setServletMappings(allMappings.toArray(new ServletMapping[allMappings.size()]));
        }
    }

    private List<ServletMapping> getServletMappingsForServlet(String name) {
        ServletMapping[] allMappings = this._context.getServletHandler().getServletMappings();
        if (allMappings == null) {
            return Collections.emptyList();
        }
        ArrayList<ServletMapping> mappings = new ArrayList<ServletMapping>();
        for (ServletMapping m3 : allMappings) {
            if (m3.getServletName() == null || !name.equals(m3.getServletName())) continue;
            mappings.add(m3);
        }
        return mappings;
    }

    private boolean containsNonDefaultMappings(List<ServletMapping> mappings) {
        if (mappings == null) {
            return false;
        }
        for (ServletMapping m3 : mappings) {
            if (m3.isFromDefaultDescriptor()) continue;
            return true;
        }
        return false;
    }
}

