/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.StanzaView;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.formtypes.FormFieldRegistry;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;

public final class DataForm
implements ExtensionElement {
    public static final String NAMESPACE = "jabber:x:data";
    public static final String ELEMENT = "x";
    public static final QName QNAME = new QName("jabber:x:data", "x");
    private final Type type;
    private final String title;
    private final List<String> instructions;
    private final ReportedData reportedData;
    private final List<Item> items;
    private final List<FormField> fields;
    private final Map<String, FormField> fieldsMap;
    private final List<Element> extensionElements;

    private DataForm(Builder builder) {
        this.type = builder.type;
        this.title = builder.title;
        this.instructions = CollectionUtil.cloneAndSeal((Collection)builder.instructions);
        this.reportedData = builder.reportedData;
        this.items = CollectionUtil.cloneAndSeal((Collection)builder.items);
        builder.orderFields();
        this.fields = CollectionUtil.cloneAndSeal((Collection)builder.fields);
        this.fieldsMap = CollectionUtil.cloneAndSeal((Map)builder.fieldsMap);
        this.extensionElements = CollectionUtil.cloneAndSeal((Collection)builder.extensionElements);
        if (this.type == Type.form) {
            FormFieldRegistry.register(this);
        }
    }

    public Type getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public List<String> getInstructions() {
        return this.instructions;
    }

    public ReportedData getReportedData() {
        return this.reportedData;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public List<FormField> getFields() {
        return this.fields;
    }

    public FormField getField(String fieldName) {
        return this.fieldsMap.get(fieldName);
    }

    public boolean hasField(String fieldName) {
        return this.fieldsMap.containsKey(fieldName);
    }

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public List<Element> getExtensionElements() {
        return this.extensionElements;
    }

    public String getFormType() {
        TextSingleFormField formTypeField = this.getHiddenFormTypeField();
        if (formTypeField == null) {
            return null;
        }
        return formTypeField.getFirstValue();
    }

    public TextSingleFormField getHiddenFormTypeField() {
        FormField field = this.getField("FORM_TYPE");
        if (field == null) {
            return null;
        }
        return field.asHiddenFormTypeFieldIfPossible();
    }

    public boolean hasHiddenFormTypeField() {
        return this.getHiddenFormTypeField() != null;
    }

    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        XmlStringBuilder buf = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
        buf.attribute("type", (Enum)this.getType());
        buf.rightAngleBracket();
        xmlEnvironment = buf.getXmlEnvironment();
        buf.optElement("title", this.getTitle());
        for (String instruction : this.getInstructions()) {
            buf.element("instructions", instruction);
        }
        buf.optElement((Element)this.getReportedData());
        buf.append(this.getItems());
        boolean includeType = this.getType() != Type.submit;
        for (FormField formField : this.getFields()) {
            buf.append(formField.toXML(xmlEnvironment, includeType));
        }
        buf.append(this.getExtensionElements());
        buf.closeElement((NamedElement)this);
        return buf;
    }

    public Builder asBuilder() {
        return new Builder(this);
    }

    public static DataForm from(StanzaView stanzaView) {
        return DataForm.from(stanzaView, null);
    }

    public static DataForm from(StanzaView stanzaView, String formType) {
        if (formType == null) {
            return (DataForm)stanzaView.getExtension(DataForm.class);
        }
        List dataForms = stanzaView.getExtensions(DataForm.class);
        return DataForm.from(dataForms, formType);
    }

    public static DataForm from(Collection<DataForm> dataForms, String formType) {
        for (DataForm dataForm : dataForms) {
            if (!formType.equals(dataForm.getFormType())) continue;
            return dataForm;
        }
        return null;
    }

    public static DataForm remove(Collection<DataForm> dataForms, String formType) {
        Iterator<DataForm> it = dataForms.iterator();
        while (it.hasNext()) {
            DataForm dataForm = it.next();
            if (!formType.equals(dataForm.getFormType())) continue;
            it.remove();
            return dataForm;
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Type type) {
        return new Builder(type);
    }

    public static class Item
    implements ExtensionElement {
        public static final String ELEMENT = "item";
        public static final QName QNAME = new QName("jabber:x:data", "item");
        private final List<? extends FormField> fields;

        public Item(List<? extends FormField> fields) {
            this.fields = Collections.unmodifiableList(fields);
        }

        public String getElementName() {
            return ELEMENT;
        }

        public String getNamespace() {
            return DataForm.NAMESPACE;
        }

        public List<? extends FormField> getFields() {
            return this.fields;
        }

        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xml = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
            xml.rightAngleBracket();
            xml.append(this.getFields());
            xml.closeElement((NamedElement)this);
            return xml;
        }
    }

    public static class ReportedData
    implements ExtensionElement {
        public static final String ELEMENT = "reported";
        public static final QName QNAME = new QName("jabber:x:data", "reported");
        private final List<? extends FormField> fields;
        private Map<String, FormField> fieldMap;

        public ReportedData(List<? extends FormField> fields) {
            this.fields = Collections.unmodifiableList(fields);
        }

        public String getElementName() {
            return ELEMENT;
        }

        public String getNamespace() {
            return DataForm.NAMESPACE;
        }

        public List<? extends FormField> getFields() {
            return this.fields;
        }

        public FormField getField(String name) {
            if (this.fieldMap == null) {
                this.fieldMap = new HashMap<String, FormField>(this.fields.size());
                for (FormField formField : this.fields) {
                    String fieldName = formField.getFieldName();
                    this.fieldMap.put(fieldName, formField);
                }
            }
            return this.fieldMap.get(name);
        }

        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xml = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
            xml.rightAngleBracket();
            xml.append(this.getFields());
            xml.closeElement((NamedElement)this);
            return xml;
        }
    }

    public static final class Builder {
        private Type type;
        private String title;
        private List<String> instructions;
        private ReportedData reportedData;
        private List<Item> items;
        private List<FormField> fields = new ArrayList<FormField>();
        private Map<String, FormField> fieldsMap = new HashMap<String, FormField>();
        private List<Element> extensionElements;

        private Builder() {
            this(Type.submit);
        }

        private Builder(Type type) {
            this.type = type;
        }

        private Builder(DataForm dataForm) {
            this.type = dataForm.getType();
            this.title = dataForm.getTitle();
            this.instructions = dataForm.getInstructions();
            this.reportedData = dataForm.getReportedData();
            this.items = CollectionUtil.newListWith(dataForm.getItems());
            this.fields = CollectionUtil.newListWith(dataForm.getFields());
            this.fieldsMap = new HashMap<String, FormField>(dataForm.fieldsMap);
            this.extensionElements = CollectionUtil.newListWith(dataForm.getExtensionElements());
        }

        private void orderFields() {
            Iterator<FormField> it = this.fields.iterator();
            if (!it.hasNext()) {
                return;
            }
            TextSingleFormField hiddenFormTypeField = it.next().asHiddenFormTypeFieldIfPossible();
            if (hiddenFormTypeField != null) {
                return;
            }
            while (it.hasNext()) {
                hiddenFormTypeField = it.next().asHiddenFormTypeFieldIfPossible();
                if (hiddenFormTypeField == null) continue;
                it.remove();
                this.fields.add(0, hiddenFormTypeField);
                break;
            }
        }

        @Deprecated
        public Builder setType(Type type) {
            this.type = (Type)((Object)Objects.requireNonNull((Object)((Object)type)));
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder addField(FormField field) {
            String fieldName = field.getFieldName();
            if (fieldName != null) {
                if (this.fieldsMap.containsKey(fieldName)) {
                    throw new IllegalArgumentException("A field with the name " + fieldName + " already exists");
                }
                this.fieldsMap.put(fieldName, field);
            }
            this.fields.add(field);
            return this;
        }

        public Builder addFields(Collection<? extends FormField> fieldsToAdd) {
            String fieldName;
            for (FormField formField : fieldsToAdd) {
                fieldName = formField.getFieldName();
                if (!this.fieldsMap.containsKey(fieldName)) continue;
                throw new IllegalArgumentException("A field with the name " + fieldName + " already exists");
            }
            for (FormField formField : fieldsToAdd) {
                fieldName = formField.getFieldName();
                if (fieldName != null) {
                    this.fieldsMap.put(fieldName, formField);
                }
                this.fields.add(formField);
            }
            return this;
        }

        public Builder removeField(String fieldName) {
            FormField field = this.fieldsMap.remove(fieldName);
            if (field != null) {
                this.fields.remove(field);
            }
            return this;
        }

        public Builder setFormType(String formType) {
            TextSingleFormField formField = FormField.buildHiddenFormType(formType);
            return this.addField(formField);
        }

        public Builder setInstructions(String instructions) {
            return this.setInstructions(StringUtils.splitLinesPortable((String)instructions));
        }

        public Builder setInstructions(List<String> instructions) {
            this.instructions = instructions;
            return this;
        }

        public Builder addInstruction(String instruction) {
            if (this.instructions == null) {
                this.instructions = new ArrayList<String>();
            }
            this.instructions.add(instruction);
            return this;
        }

        public Builder addItem(Item item) {
            if (this.items == null) {
                this.items = new ArrayList<Item>();
            }
            this.items.add(item);
            return this;
        }

        public Builder setReportedData(ReportedData reportedData) {
            this.reportedData = reportedData;
            return this;
        }

        public Builder addExtensionElement(Element element) {
            if (this.extensionElements == null) {
                this.extensionElements = new ArrayList<Element>();
            }
            this.extensionElements.add(element);
            return this;
        }

        public DataForm build() {
            return new DataForm(this);
        }
    }

    public static enum Type {
        form,
        submit,
        cancel,
        result;


        public static Type fromString(String string) {
            return Type.valueOf(string.toLowerCase(Locale.US));
        }
    }
}

