/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.validation.client.constraints;

import java.math.BigDecimal;
import javax.validation.ConstraintValidator;
import javax.validation.constraints.Digits;

public abstract class AbstractDigitsValidator<T>
implements ConstraintValidator<Digits, T> {
    private int fraction;
    private int integer;

    public final void initialize(Digits constraintAnnotation) {
        if (constraintAnnotation.fraction() < 0) {
            throw new IllegalArgumentException("@Digits.fraction must be a nonnegative nubmer");
        }
        if (constraintAnnotation.integer() < 0) {
            throw new IllegalArgumentException("@Digits.integer must be a nonnegative nubmer");
        }
        this.fraction = constraintAnnotation.fraction();
        this.integer = constraintAnnotation.integer();
    }

    protected final boolean isValid(BigDecimal bigValue) {
        int integerLength = bigValue.precision() - bigValue.scale();
        if (integerLength > this.integer) {
            return false;
        }
        int fractionalLength = bigValue.scale() < 0 ? 0 : bigValue.scale();
        return fractionalLength <= this.fraction;
    }
}

