/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.typedarrays.server;

import com.google.gwt.typedarrays.shared.ArrayBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ArrayBufferImpl
implements ArrayBuffer {
    private final Object lock = new Object();
    private final ByteBuffer buf;

    public ArrayBufferImpl(int length) {
        this.buf = ByteBuffer.allocate(length);
        this.buf.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public int byteLength() {
        return this.buf.capacity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    float getFloat32(int byteOffset, boolean littleEndian) {
        Object object = this.lock;
        synchronized (object) {
            float f;
            block8: {
                try {
                    if (!littleEndian) {
                        this.buf.order(ByteOrder.BIG_ENDIAN);
                    }
                    f = this.buf.getFloat(byteOffset);
                    if (littleEndian) break block8;
                    this.buf.order(ByteOrder.LITTLE_ENDIAN);
                }
                catch (Throwable throwable) {
                    if (!littleEndian) {
                        this.buf.order(ByteOrder.LITTLE_ENDIAN);
                    }
                    throw throwable;
                }
            }
            return f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double getFloat64(int byteOffset, boolean littleEndian) {
        Object object = this.lock;
        synchronized (object) {
            double d;
            block8: {
                try {
                    if (!littleEndian) {
                        this.buf.order(ByteOrder.BIG_ENDIAN);
                    }
                    d = this.buf.getDouble(byteOffset);
                    if (littleEndian) break block8;
                    this.buf.order(ByteOrder.LITTLE_ENDIAN);
                }
                catch (Throwable throwable) {
                    if (!littleEndian) {
                        this.buf.order(ByteOrder.LITTLE_ENDIAN);
                    }
                    throw throwable;
                }
            }
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    short getInt16(int byteOffset, boolean littleEndian) {
        Object object = this.lock;
        synchronized (object) {
            short s;
            block8: {
                try {
                    if (!littleEndian) {
                        this.buf.order(ByteOrder.BIG_ENDIAN);
                    }
                    s = this.buf.getShort(byteOffset);
                    if (littleEndian) break block8;
                    this.buf.order(ByteOrder.LITTLE_ENDIAN);
                }
                catch (Throwable throwable) {
                    if (!littleEndian) {
                        this.buf.order(ByteOrder.LITTLE_ENDIAN);
                    }
                    throw throwable;
                }
            }
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getInt32(int byteOffset, boolean littleEndian) {
        Object object = this.lock;
        synchronized (object) {
            int n;
            block8: {
                try {
                    if (!littleEndian) {
                        this.buf.order(ByteOrder.BIG_ENDIAN);
                    }
                    n = this.buf.getInt(byteOffset);
                    if (littleEndian) break block8;
                    this.buf.order(ByteOrder.LITTLE_ENDIAN);
                }
                catch (Throwable throwable) {
                    if (!littleEndian) {
                        this.buf.order(ByteOrder.LITTLE_ENDIAN);
                    }
                    throw throwable;
                }
            }
            return n;
        }
    }

    byte getInt8(int byteOffset) {
        return this.buf.get(byteOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFloat32(int byteOffset, float value, boolean littleEndian) {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (!littleEndian) {
                    this.buf.order(ByteOrder.BIG_ENDIAN);
                }
                this.buf.putFloat(byteOffset, value);
            }
            finally {
                if (!littleEndian) {
                    this.buf.order(ByteOrder.LITTLE_ENDIAN);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFloat64(int byteOffset, double value, boolean littleEndian) {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (!littleEndian) {
                    this.buf.order(ByteOrder.BIG_ENDIAN);
                }
                this.buf.putDouble(byteOffset, value);
            }
            finally {
                if (!littleEndian) {
                    this.buf.order(ByteOrder.LITTLE_ENDIAN);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInt16(int byteOffset, short value, boolean littleEndian) {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (!littleEndian) {
                    this.buf.order(ByteOrder.BIG_ENDIAN);
                }
                this.buf.putShort(byteOffset, value);
            }
            finally {
                if (!littleEndian) {
                    this.buf.order(ByteOrder.LITTLE_ENDIAN);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInt32(int byteOffset, int value, boolean littleEndian) {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (!littleEndian) {
                    this.buf.order(ByteOrder.BIG_ENDIAN);
                }
                this.buf.putInt(byteOffset, value);
            }
            finally {
                if (!littleEndian) {
                    this.buf.order(ByteOrder.LITTLE_ENDIAN);
                }
            }
        }
    }

    void setInt8(int byteOffset, byte value) {
        this.buf.put(byteOffset, value);
    }
}

