/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl;

import java.io.File;
import java.util.EnumSet;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.gradle.internal.cc.impl.DefaultIgnoredConfigurationInputs;
import org.gradle.internal.cc.impl.IgnoredConfigurationInputs;
import org.gradle.internal.cc.impl.initialization.ConfigurationCacheStartParameter;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.internal.GFileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ServiceScope(value={Scope.BuildTree.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0002J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0002R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/gradle/internal/cc/impl/DefaultIgnoredConfigurationInputs;", "Lorg/gradle/internal/cc/impl/IgnoredConfigurationInputs;", "configurationCacheStartParameter", "Lorg/gradle/internal/cc/impl/initialization/ConfigurationCacheStartParameter;", "fileSystem", "Lorg/gradle/internal/nativeintegration/filesystem/FileSystem;", "(Lorg/gradle/internal/cc/impl/initialization/ConfigurationCacheStartParameter;Lorg/gradle/internal/nativeintegration/filesystem/FileSystem;)V", "ignoredPathsString", "", "isCaseSensitive", "", "rootDirectory", "Ljava/io/File;", "(Ljava/lang/String;ZLjava/io/File;)V", "jointRegex", "Lkotlin/text/Regex;", "userHome", "isFileSystemCheckIgnoredFor", "file", "maybeCreateJointRegexForPatterns", "paths", "maybeRelativize", "normalizeActualInputPath", "normalizeFilePattern", "pathWithWildcards", "substituteUserHome", "wildcardsToRegexPatternString", "Companion", "configuration-cache"})
@SourceDebugExtension(value={"SMAP\nDefaultIgnoredConfigurationInputs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultIgnoredConfigurationInputs.kt\norg/gradle/internal/cc/impl/DefaultIgnoredConfigurationInputs\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
public final class DefaultIgnoredConfigurationInputs
implements IgnoredConfigurationInputs {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final File rootDirectory;
    @NotNull
    private final File userHome;
    @Nullable
    private final Regex jointRegex;
    @Deprecated
    @NotNull
    public static final String PATHS_SEPARATOR = ";";

    public DefaultIgnoredConfigurationInputs(@Nullable String ignoredPathsString, boolean isCaseSensitive, @NotNull File rootDirectory) {
        Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
        this.rootDirectory = rootDirectory;
        this.userHome = new File(System.getProperty("user.home"));
        this.jointRegex = this.maybeCreateJointRegexForPatterns(ignoredPathsString, isCaseSensitive);
    }

    @Inject
    public DefaultIgnoredConfigurationInputs(@NotNull ConfigurationCacheStartParameter configurationCacheStartParameter, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)configurationCacheStartParameter, (String)"configurationCacheStartParameter");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this(configurationCacheStartParameter.getIgnoredFileSystemCheckInputs(), fileSystem.isCaseSensitive(), configurationCacheStartParameter.getRootDirectory());
    }

    @Override
    public boolean isFileSystemCheckIgnoredFor(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Regex regex = this.jointRegex;
        return regex != null ? regex.matches((CharSequence)this.normalizeActualInputPath(file)) : false;
    }

    private final String normalizeActualInputPath(File file) {
        File p0 = file;
        boolean bl = false;
        p0 = this.maybeRelativize(p0);
        boolean bl2 = false;
        return FilesKt.getInvariantSeparatorsPath((File)FilesKt.normalize((File)p0));
    }

    private final String normalizeFilePattern(String pathWithWildcards) {
        File p0 = new File(pathWithWildcards);
        boolean bl = false;
        p0 = this.substituteUserHome(p0);
        boolean bl2 = false;
        p0 = this.maybeRelativize(p0);
        boolean bl3 = false;
        return FilesKt.getInvariantSeparatorsPath((File)FilesKt.normalize((File)p0));
    }

    private final File substituteUserHome(File file) {
        File file2;
        if (StringsKt.startsWith$default((String)FilesKt.getInvariantSeparatorsPath((File)file), (String)"~/", (boolean)false, (int)2, null)) {
            String string2 = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.path");
            file2 = new File(this.userHome, StringsKt.substringAfter$default((String)string2, (char)File.separatorChar, null, (int)2, null));
        } else {
            file2 = file;
        }
        return file2;
    }

    private final File maybeRelativize(File file) {
        return !file.isAbsolute() ? file : new File(GFileUtils.relativePathOf((File)file, (File)this.rootDirectory));
    }

    private final String wildcardsToRegexPatternString(String pathWithWildcards) {
        String[] stringArray = new String[]{"**"};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)pathWithWildcards, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)".*", (CharSequence)"^", (CharSequence)"$", (int)0, null, (Function1)wildcardsToRegexPatternString.1.INSTANCE, (int)24, null);
    }

    private final Regex maybeCreateJointRegexForPatterns(String paths, boolean isCaseSensitive) {
        Regex regex;
        Object object = (String[])paths;
        if (object == null || object.length() == 0) {
            regex = null;
        } else {
            Set set;
            object = new String[]{PATHS_SEPARATOR};
            object = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)paths, (String[])object, (boolean)false, (int)0, (int)6, null), (CharSequence)"|", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(this){
                final /* synthetic */ DefaultIgnoredConfigurationInputs this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return DefaultIgnoredConfigurationInputs.access$wildcardsToRegexPatternString(this.this$0, DefaultIgnoredConfigurationInputs.access$normalizeFilePattern(this.this$0, it));
                }
            }), (int)30, null);
            if (!isCaseSensitive) {
                EnumSet<Enum> enumSet = EnumSet.of((Enum)RegexOption.IGNORE_CASE);
                Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(RegexOption.IGNORE_CASE)");
                set = enumSet;
            } else {
                set = SetsKt.emptySet();
            }
            Set set2 = set;
            regex = new Regex((String)object, set2);
        }
        return regex;
    }

    private static final String wildcardsToRegexPatternString$runIfNotEmpty(String $this$wildcardsToRegexPatternString_u24runIfNotEmpty, Function1<? super String, String> action) {
        return ((CharSequence)$this$wildcardsToRegexPatternString_u24runIfNotEmpty).length() == 0 ? $this$wildcardsToRegexPatternString_u24runIfNotEmpty : (String)action.invoke((Object)$this$wildcardsToRegexPatternString_u24runIfNotEmpty);
    }

    public static final /* synthetic */ String access$wildcardsToRegexPatternString$runIfNotEmpty(String $receiver, Function1 action) {
        return DefaultIgnoredConfigurationInputs.wildcardsToRegexPatternString$runIfNotEmpty($receiver, (Function1<? super String, String>)action);
    }

    public static final /* synthetic */ String access$wildcardsToRegexPatternString(DefaultIgnoredConfigurationInputs $this, String pathWithWildcards) {
        return $this.wildcardsToRegexPatternString(pathWithWildcards);
    }

    public static final /* synthetic */ String access$normalizeFilePattern(DefaultIgnoredConfigurationInputs $this, String pathWithWildcards) {
        return $this.normalizeFilePattern(pathWithWildcards);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/gradle/internal/cc/impl/DefaultIgnoredConfigurationInputs$Companion;", "", "()V", "PATHS_SEPARATOR", "", "configuration-cache"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

