/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.type;

import java.util.Collections;
import java.util.Objects;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.EsField;

public class InvalidMappedField
extends EsField {
    private final String errorMessage;

    public InvalidMappedField(String name, String errorMessage) {
        super(name, DataType.UNSUPPORTED, Collections.emptyMap(), false);
        this.errorMessage = errorMessage;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.errorMessage);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            InvalidMappedField other = (InvalidMappedField)obj;
            return Objects.equals(this.errorMessage, other.errorMessage);
        }
        return false;
    }

    @Override
    public EsField getExactField() {
        throw new SqlIllegalArgumentException("Field [" + this.getName() + "] is invalid, cannot access it");
    }

    @Override
    public EsField.Exact getExactInfo() {
        return new EsField.Exact(false, "Field [" + this.getName() + "] is invalid, cannot access it");
    }
}

