/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.AttributeSet;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.tree.Node;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public abstract class QueryPlan<PlanType extends QueryPlan<PlanType>>
extends Node<PlanType> {
    private AttributeSet lazyOutputSet;
    private AttributeSet lazyInputSet;

    public QueryPlan(Source source, List<PlanType> children) {
        super(source, children);
    }

    public abstract List<Attribute> output();

    public AttributeSet outputSet() {
        if (this.lazyOutputSet == null) {
            this.lazyOutputSet = new AttributeSet(this.output());
        }
        return this.lazyOutputSet;
    }

    public AttributeSet inputSet() {
        if (this.lazyInputSet == null) {
            ArrayList<Attribute> attrs = new ArrayList<Attribute>();
            for (QueryPlan child : this.children()) {
                attrs.addAll(child.output());
            }
            this.lazyInputSet = new AttributeSet(attrs);
        }
        return this.lazyInputSet;
    }

    public PlanType transformExpressionsOnly(Function<? super Expression, ? extends Expression> rule) {
        return (PlanType)((QueryPlan)this.transformPropertiesOnly(e -> this.doTransformExpression(e, exp -> (Expression)exp.transformDown(rule)), Object.class));
    }

    public PlanType transformExpressionsDown(Function<? super Expression, ? extends Expression> rule) {
        return (PlanType)((QueryPlan)this.transformPropertiesDown(e -> this.doTransformExpression(e, exp -> (Expression)exp.transformDown(rule)), Object.class));
    }

    public PlanType transformExpressionsUp(Function<? super Expression, ? extends Expression> rule) {
        return (PlanType)((QueryPlan)this.transformPropertiesUp(e -> this.doTransformExpression(e, exp -> (Expression)exp.transformUp(rule)), Object.class));
    }

    private <E extends Expression> Object doTransformExpression(Object arg, Function<? super Expression, E> traversal) {
        if (arg instanceof Expression) {
            return traversal.apply((Expression)arg);
        }
        if (arg instanceof DataType || arg instanceof Map) {
            return arg;
        }
        if (arg instanceof Collection) {
            Collection c = (Collection)arg;
            ArrayList<Object> transformed = new ArrayList<Object>(c.size());
            boolean hasChanged = false;
            for (Object e : c) {
                Object next;
                if (!e.equals(next = this.doTransformExpression(e, traversal))) {
                    hasChanged = true;
                } else {
                    next = e;
                }
                transformed.add(next);
            }
            return hasChanged ? transformed : arg;
        }
        return arg;
    }

    public void forEachExpressionsDown(Consumer<? super Expression> rule) {
        this.forEachPropertiesDown(e -> this.doForEachExpression(e, exp -> exp.forEachDown(rule)), Object.class);
    }

    public void forEachExpressionsUp(Consumer<? super Expression> rule) {
        this.forEachPropertiesUp(e -> this.doForEachExpression(e, exp -> exp.forEachUp(rule)), Object.class);
    }

    public void forEachExpressions(Consumer<? super Expression> rule) {
        this.forEachPropertiesOnly(e -> this.doForEachExpression(e, rule::accept), Object.class);
    }

    private void doForEachExpression(Object arg, Consumer<? super Expression> traversal) {
        if (arg instanceof Expression) {
            traversal.accept((Expression)arg);
        } else if (arg instanceof Collection) {
            Collection c = (Collection)arg;
            for (Object o : c) {
                this.doForEachExpression(o, traversal);
            }
        }
    }
}

