/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.operator.comparison;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.expression.function.scalar.Processors;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.Comparisons;

public class InProcessor
implements Processor {
    public static final String NAME = "in";
    private final List<Processor> processsors;

    InProcessor(List<Processor> processors) {
        this.processsors = processors;
    }

    public InProcessor(StreamInput in) throws IOException {
        this.processsors = in.readNamedWriteableList(Processor.class);
    }

    public String getWriteableName() {
        return NAME;
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteableList(this.processsors);
    }

    @Override
    public Object process(Object input) {
        Object leftValue = this.processsors.get(this.processsors.size() - 1).process(input);
        return InProcessor.apply(leftValue, Processors.process(this.processsors.subList(0, this.processsors.size() - 1), leftValue));
    }

    public static Boolean apply(Object input, List<Object> values) {
        Boolean result = Boolean.FALSE;
        for (Object v : values) {
            Boolean compResult = Comparisons.eq(input, v);
            if (compResult == null) {
                result = null;
                continue;
            }
            if (compResult != Boolean.TRUE) continue;
            return Boolean.TRUE;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InProcessor that = (InProcessor)o;
        return Objects.equals(this.processsors, that.processsors);
    }

    public int hashCode() {
        return Objects.hash(this.processsors);
    }
}

