/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.conditional;

import java.util.List;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.Nullability;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypeConversion;

public abstract class ConditionalFunction
extends ScalarFunction {
    protected DataType dataType = null;

    ConditionalFunction(Source source, List<Expression> fields) {
        super(source, fields);
    }

    @Override
    public DataType dataType() {
        if (this.dataType == null) {
            this.dataType = DataType.NULL;
            for (Expression exp : this.children()) {
                this.dataType = DataTypeConversion.commonType(this.dataType, exp.dataType());
            }
        }
        return this.dataType;
    }

    @Override
    public boolean foldable() {
        return Expressions.foldable(this.children());
    }

    @Override
    public Nullability nullable() {
        return Nullability.UNKNOWN;
    }
}

