/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;

public class LocateFunctionProcessor
implements Processor {
    private final Processor pattern;
    private final Processor source;
    private final Processor start;
    public static final String NAME = "sloc";

    public LocateFunctionProcessor(Processor pattern, Processor source, Processor start) {
        this.pattern = pattern;
        this.source = source;
        this.start = start;
    }

    public LocateFunctionProcessor(StreamInput in) throws IOException {
        this.pattern = (Processor)in.readNamedWriteable(Processor.class);
        this.source = (Processor)in.readNamedWriteable(Processor.class);
        this.start = (Processor)in.readOptionalNamedWriteable(Processor.class);
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.pattern);
        out.writeNamedWriteable((NamedWriteable)this.source);
        out.writeOptionalNamedWriteable((NamedWriteable)this.start);
    }

    @Override
    public Object process(Object input) {
        return LocateFunctionProcessor.doProcess(this.pattern().process(input), this.source().process(input), this.start() == null ? null : this.start().process(input));
    }

    public static Integer doProcess(Object pattern, Object source, Object start) {
        if (source == null) {
            return null;
        }
        if (!(source instanceof String) && !(source instanceof Character)) {
            throw new SqlIllegalArgumentException("A string/char is required; received [{}]", source);
        }
        if (pattern == null) {
            return 0;
        }
        if (!(pattern instanceof String) && !(pattern instanceof Character)) {
            throw new SqlIllegalArgumentException("A string/char is required; received [{}]", pattern);
        }
        if (start != null && !(start instanceof Number)) {
            throw new SqlIllegalArgumentException("A number is required; received [{}]", start);
        }
        String stringSource = source instanceof Character ? source.toString() : (String)source;
        String stringPattern = pattern instanceof Character ? pattern.toString() : (String)pattern;
        return 1 + (start != null ? stringSource.indexOf(stringPattern, ((Number)start).intValue() - 1) : stringSource.indexOf(stringPattern));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LocateFunctionProcessor other = (LocateFunctionProcessor)obj;
        return Objects.equals(this.pattern(), other.pattern()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.start(), other.start());
    }

    public int hashCode() {
        return Objects.hash(this.pattern(), this.source(), this.start());
    }

    public Processor pattern() {
        return this.pattern;
    }

    public Processor source() {
        return this.source;
    }

    public Processor start() {
        return this.start;
    }

    public String getWriteableName() {
        return NAME;
    }
}

