/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar;

import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.ExpressionId;
import org.elasticsearch.xpack.sql.expression.Nullability;
import org.elasticsearch.xpack.sql.expression.function.FunctionAttribute;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public class ScalarFunctionAttribute
extends FunctionAttribute {
    private final ScriptTemplate script;
    private final Pipe pipe;

    ScalarFunctionAttribute(Source source, String name, DataType dataType, ExpressionId id, String functionId, ScriptTemplate script, Pipe processorDef) {
        this(source, name, dataType, null, Nullability.TRUE, id, false, functionId, script, processorDef);
    }

    public ScalarFunctionAttribute(Source source, String name, DataType dataType, String qualifier, Nullability nullable, ExpressionId id, boolean synthetic, String functionId, ScriptTemplate script, Pipe pipe) {
        super(source, name, dataType, qualifier, nullable, id, synthetic, functionId);
        this.script = script;
        this.pipe = pipe;
    }

    @Override
    protected NodeInfo<ScalarFunctionAttribute> info() {
        return NodeInfo.create(this, ScalarFunctionAttribute::new, this.name(), this.dataType(), this.qualifier(), this.nullable(), this.id(), this.synthetic(), this.functionId(), this.script, this.pipe);
    }

    public ScriptTemplate script() {
        return this.script;
    }

    @Override
    public Pipe asPipe() {
        return this.pipe;
    }

    @Override
    protected Expression canonicalize() {
        return new ScalarFunctionAttribute(this.source(), "<none>", this.dataType(), null, Nullability.TRUE, this.id(), false, this.functionId(), this.script, this.pipe);
    }

    @Override
    protected Attribute clone(Source source, String name, String qualifier, Nullability nullable, ExpressionId id, boolean synthetic) {
        return new ScalarFunctionAttribute(source, name, this.dataType(), qualifier, nullable, id, synthetic, this.functionId(), this.script, this.pipe);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.script(), this.pipe);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            ScalarFunctionAttribute other = (ScalarFunctionAttribute)obj;
            return Objects.equals(this.script, other.script()) && Objects.equals(this.pipe, other.asPipe());
        }
        return false;
    }

    @Override
    protected String label() {
        return "s->" + this.functionId();
    }
}

