/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpResource;

public class MultiHttpResource
extends HttpResource {
    private static final Logger logger = LogManager.getLogger(MultiHttpResource.class);
    private final List<HttpResource> resources;

    public MultiHttpResource(String resourceOwnerName, List<? extends HttpResource> resources) {
        super(resourceOwnerName);
        if (resources.isEmpty()) {
            throw new IllegalArgumentException("[resources] cannot be empty");
        }
        this.resources = Collections.unmodifiableList(resources);
    }

    public List<HttpResource> getResources() {
        return this.resources;
    }

    @Override
    protected void doCheckAndPublish(final RestClient client, final ActionListener<Boolean> listener) {
        logger.trace("checking sub-resources existence and publishing on the [{}]", (Object)this.resourceOwnerName);
        final Iterator<HttpResource> iterator = this.resources.iterator();
        iterator.next().checkAndPublish(client, new ActionListener<Boolean>(){

            public void onResponse(Boolean success) {
                if (success.booleanValue() && iterator.hasNext()) {
                    ((HttpResource)iterator.next()).checkAndPublish(client, this);
                } else {
                    logger.trace("all sub-resources exist [{}] on the [{}]", (Object)success, (Object)MultiHttpResource.this.resourceOwnerName);
                    listener.onResponse((Object)success);
                }
            }

            public void onFailure(Exception e) {
                logger.trace("all sub-resources exist [false] on the [{}]", (Object)MultiHttpResource.this.resourceOwnerName);
                listener.onFailure(e);
            }
        });
    }
}

