/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.ml.calendars.ScheduledEvent;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisLimits;
import org.elasticsearch.xpack.core.ml.job.config.DataDescription;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;
import org.elasticsearch.xpack.core.ml.job.config.ModelPlotConfig;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.ml.job.process.ProcessBuilderUtils;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.AnalysisLimitsWriter;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.FieldConfigWriter;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.ModelPlotConfigWriter;
import org.elasticsearch.xpack.ml.process.NativeController;
import org.elasticsearch.xpack.ml.process.ProcessPipes;

public class AutodetectBuilder {
    public static final String AUTODETECT = "autodetect";
    static final String AUTODETECT_PATH = "./autodetect";
    public static final String BUCKET_SPAN_ARG = "--bucketspan=";
    public static final String DELETE_STATE_FILES_ARG = "--deleteStateFiles";
    public static final String LENGTH_ENCODED_INPUT_ARG = "--lengthEncodedInput";
    public static final String MODEL_CONFIG_ARG = "--modelconfig=";
    public static final String QUANTILES_STATE_PATH_ARG = "--quantilesState=";
    private static final String CONF_EXTENSION = ".conf";
    static final String JOB_ID_ARG = "--jobid=";
    private static final String LIMIT_CONFIG_ARG = "--limitconfig=";
    private static final String MODEL_PLOT_CONFIG_ARG = "--modelplotconfig=";
    private static final String FIELD_CONFIG_ARG = "--fieldconfig=";
    static final String LATENCY_ARG = "--latency=";
    static final String MULTIVARIATE_BY_FIELDS_ARG = "--multivariateByFields";
    static final String PERSIST_INTERVAL_ARG = "--persistInterval=";
    static final String MAX_QUANTILE_INTERVAL_ARG = "--maxQuantileInterval=";
    static final String SUMMARY_COUNT_FIELD_ARG = "--summarycountfield=";
    static final String TIME_FIELD_ARG = "--timefield=";
    private static final int DEFAULT_MAX_NUM_RECORDS = 500;
    @Deprecated
    public static final Setting<Integer> MAX_ANOMALY_RECORDS_SETTING = Setting.intSetting((String)"max.anomaly.records", (int)500, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Deprecated});
    public static final Setting<Integer> MAX_ANOMALY_RECORDS_SETTING_DYNAMIC = Setting.intSetting((String)"xpack.ml.max_anomaly_records", MAX_ANOMALY_RECORDS_SETTING, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> DONT_PERSIST_MODEL_STATE_SETTING = Setting.boolSetting((String)"no.model.state.persist", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final int SECONDS_IN_HOUR = 3600;
    private static final long DEFAULT_BASE_PERSIST_INTERVAL = 10800L;
    static final int BASE_MAX_QUANTILE_INTERVAL = 21600;
    private static final String QUANTILES_FILE_EXTENSION = ".json";
    private final Job job;
    private final List<Path> filesToDelete;
    private final Logger logger;
    private final Environment env;
    private final Settings settings;
    private final NativeController controller;
    private final ProcessPipes processPipes;
    private Set<MlFilter> referencedFilters;
    private List<ScheduledEvent> scheduledEvents;
    private Quantiles quantiles;

    public AutodetectBuilder(Job job, List<Path> filesToDelete, Logger logger, Environment env, Settings settings, NativeController controller, ProcessPipes processPipes) {
        this.env = env;
        this.settings = settings;
        this.controller = controller;
        this.processPipes = processPipes;
        this.job = Objects.requireNonNull(job);
        this.filesToDelete = Objects.requireNonNull(filesToDelete);
        this.logger = Objects.requireNonNull(logger);
        this.referencedFilters = new HashSet<MlFilter>();
        this.scheduledEvents = Collections.emptyList();
    }

    public AutodetectBuilder referencedFilters(Set<MlFilter> filters) {
        this.referencedFilters = filters;
        return this;
    }

    public AutodetectBuilder quantiles(Quantiles quantiles) {
        this.quantiles = quantiles;
        return this;
    }

    public AutodetectBuilder scheduledEvents(List<ScheduledEvent> scheduledEvents) {
        this.scheduledEvents = scheduledEvents;
        return this;
    }

    public void build() throws IOException {
        List<String> command = this.buildAutodetectCommand();
        this.buildLimits(command);
        this.buildModelPlotConfig(command);
        this.buildQuantiles(command);
        this.buildFieldConfig(command);
        this.processPipes.addArgs(command);
        this.controller.startProcess(command);
    }

    List<String> buildAutodetectCommand() {
        ArrayList<String> command = new ArrayList<String>();
        command.add(AUTODETECT_PATH);
        command.add(JOB_ID_ARG + this.job.getId());
        AnalysisConfig analysisConfig = this.job.getAnalysisConfig();
        if (analysisConfig != null) {
            ProcessBuilderUtils.addIfNotNull(analysisConfig.getBucketSpan(), BUCKET_SPAN_ARG, command);
            ProcessBuilderUtils.addIfNotNull(analysisConfig.getLatency(), LATENCY_ARG, command);
            ProcessBuilderUtils.addIfNotNull(analysisConfig.getSummaryCountFieldName(), SUMMARY_COUNT_FIELD_ARG, command);
            if (Boolean.TRUE.equals(analysisConfig.getMultivariateByFields())) {
                command.add(MULTIVARIATE_BY_FIELDS_ARG);
            }
        }
        command.add(LENGTH_ENCODED_INPUT_ARG);
        command.add(AutodetectBuilder.maxAnomalyRecordsArg(this.settings));
        String timeFieldArg = TIME_FIELD_ARG + AutodetectBuilder.getTimeFieldOrDefault(this.job);
        command.add(timeFieldArg);
        int intervalStagger = AutodetectBuilder.calculateStaggeringInterval(this.job.getId());
        this.logger.debug("[{}] Periodic operations staggered by {} seconds", (Object)this.job.getId(), (Object)intervalStagger);
        if (((Boolean)DONT_PERSIST_MODEL_STATE_SETTING.get(this.settings)).booleanValue()) {
            this.logger.info("[{}] Will not persist model state - {} setting was set", (Object)this.job.getId(), DONT_PERSIST_MODEL_STATE_SETTING);
        } else {
            long persistInterval = this.job.getBackgroundPersistInterval() == null ? 10800L + (long)intervalStagger : this.job.getBackgroundPersistInterval().getSeconds();
            command.add(PERSIST_INTERVAL_ARG + persistInterval);
        }
        int maxQuantileInterval = 21600 + intervalStagger;
        command.add(MAX_QUANTILE_INTERVAL_ARG + maxQuantileInterval);
        if (ProcessBuilderUtils.modelConfigFilePresent(this.env)) {
            String modelConfigFile = XPackPlugin.resolveConfigFile((Environment)this.env, (String)"mlmodel.conf").toString();
            command.add(MODEL_CONFIG_ARG + modelConfigFile);
        }
        return command;
    }

    static String maxAnomalyRecordsArg(Settings settings) {
        return "--maxAnomalyRecords=" + MAX_ANOMALY_RECORDS_SETTING_DYNAMIC.get(settings);
    }

    private static String getTimeFieldOrDefault(Job job) {
        DataDescription dataDescription = job.getDataDescription();
        boolean useDefault = dataDescription == null || Strings.isNullOrEmpty((String)dataDescription.getTimeField());
        return useDefault ? "time" : dataDescription.getTimeField();
    }

    static int calculateStaggeringInterval(String jobId) {
        Random rng = new Random(jobId.hashCode());
        return rng.nextInt(3600);
    }

    private void buildLimits(List<String> command) throws IOException {
        if (this.job.getAnalysisLimits() != null) {
            Path limitConfigFile = Files.createTempFile(this.env.tmpFile(), "limitconfig", CONF_EXTENSION, new FileAttribute[0]);
            this.filesToDelete.add(limitConfigFile);
            AutodetectBuilder.writeLimits(this.job.getAnalysisLimits(), limitConfigFile);
            String limits = LIMIT_CONFIG_ARG + limitConfigFile.toString();
            command.add(limits);
        }
    }

    private static void writeLimits(AnalysisLimits options, Path emptyConfFile) throws IOException {
        try (OutputStreamWriter osw = new OutputStreamWriter(Files.newOutputStream(emptyConfFile, new OpenOption[0]), StandardCharsets.UTF_8);){
            new AnalysisLimitsWriter(options, osw).write();
        }
    }

    private void buildModelPlotConfig(List<String> command) throws IOException {
        if (this.job.getModelPlotConfig() != null) {
            Path modelPlotConfigFile = Files.createTempFile(this.env.tmpFile(), "modelplotconfig", CONF_EXTENSION, new FileAttribute[0]);
            this.filesToDelete.add(modelPlotConfigFile);
            AutodetectBuilder.writeModelPlotConfig(this.job.getModelPlotConfig(), modelPlotConfigFile);
            String modelPlotConfig = MODEL_PLOT_CONFIG_ARG + modelPlotConfigFile.toString();
            command.add(modelPlotConfig);
        }
    }

    private static void writeModelPlotConfig(ModelPlotConfig config, Path emptyConfFile) throws IOException {
        try (OutputStreamWriter osw = new OutputStreamWriter(Files.newOutputStream(emptyConfFile, new OpenOption[0]), StandardCharsets.UTF_8);){
            new ModelPlotConfigWriter(config, osw).write();
        }
    }

    private void buildQuantiles(List<String> command) throws IOException {
        if (this.quantiles != null && !this.quantiles.getQuantileState().isEmpty()) {
            this.logger.info("Restoring quantiles for job '" + this.job.getId() + "'");
            Path normalizersStateFilePath = AutodetectBuilder.writeNormalizerInitState(this.job.getId(), this.quantiles.getQuantileState(), this.env);
            String quantilesStateFileArg = QUANTILES_STATE_PATH_ARG + normalizersStateFilePath;
            command.add(quantilesStateFileArg);
            command.add(DELETE_STATE_FILES_ARG);
        }
    }

    public static Path writeNormalizerInitState(String jobId, String state, Environment env) throws IOException {
        Path stateFile = Files.createTempFile(env.tmpFile(), jobId + "_quantiles_" + Thread.currentThread().getId(), QUANTILES_FILE_EXTENSION, new FileAttribute[0]);
        try (BufferedWriter osw = Files.newBufferedWriter(stateFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            osw.write(state);
        }
        return stateFile;
    }

    private void buildFieldConfig(List<String> command) throws IOException {
        if (this.job.getAnalysisConfig() != null) {
            Path fieldConfigFile = Files.createTempFile(this.env.tmpFile(), "fieldconfig", CONF_EXTENSION, new FileAttribute[0]);
            this.filesToDelete.add(fieldConfigFile);
            try (OutputStreamWriter osw = new OutputStreamWriter(Files.newOutputStream(fieldConfigFile, new OpenOption[0]), StandardCharsets.UTF_8);){
                new FieldConfigWriter(this.job.getAnalysisConfig(), this.referencedFilters, this.scheduledEvents, osw, this.logger).write();
            }
            String fieldConfig = FIELD_CONFIG_ARG + fieldConfigFile.toString();
            command.add(fieldConfig);
        }
    }
}

