/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.GetInfluencersAction;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.InfluencersQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;

public class TransportGetInfluencersAction
extends HandledTransportAction<GetInfluencersAction.Request, GetInfluencersAction.Response> {
    private final JobResultsProvider jobResultsProvider;
    private final Client client;
    private final JobManager jobManager;

    @Inject
    public TransportGetInfluencersAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobResultsProvider jobResultsProvider, Client client, JobManager jobManager) {
        super(settings, "cluster:monitor/xpack/ml/job/results/influencers/get", threadPool, transportService, actionFilters, indexNameExpressionResolver, GetInfluencersAction.Request::new);
        this.jobResultsProvider = jobResultsProvider;
        this.client = client;
        this.jobManager = jobManager;
    }

    protected void doExecute(GetInfluencersAction.Request request, ActionListener<GetInfluencersAction.Response> listener) {
        this.jobManager.jobExists(request.getJobId(), (ActionListener<Boolean>)ActionListener.wrap(jobFound -> {
            InfluencersQueryBuilder.InfluencersQuery query = new InfluencersQueryBuilder().includeInterim(!request.isExcludeInterim()).start(request.getStart()).end(request.getEnd()).from(request.getPageParams().getFrom()).size(request.getPageParams().getSize()).influencerScoreThreshold(request.getInfluencerScore()).sortField(request.getSort()).sortDescending(request.isDescending()).build();
            this.jobResultsProvider.influencers(request.getJobId(), query, page -> listener.onResponse((Object)new GetInfluencersAction.Response(page)), arg_0 -> ((ActionListener)listener).onFailure(arg_0), this.client);
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

