/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.repository;

import com.carrotsearch.hppc.cursors.IntObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongConsumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.IndexCommit;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.ListenerTimeouts;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.seqno.LocalCheckpointTracker;
import org.elasticsearch.index.seqno.RetentionLeaseActions;
import org.elasticsearch.index.seqno.RetentionLeaseAlreadyExistsException;
import org.elasticsearch.index.seqno.RetentionLeaseNotFoundException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardRecoveryException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardRestoreFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.snapshots.blobstore.SnapshotFiles;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.indices.recovery.MultiFileWriter;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.blobstore.FileRestoreContext;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.ccr.CcrLicenseChecker;
import org.elasticsearch.xpack.ccr.CcrRetentionLeases;
import org.elasticsearch.xpack.ccr.CcrSettings;
import org.elasticsearch.xpack.ccr.action.CcrRequests;
import org.elasticsearch.xpack.ccr.action.repositories.ClearCcrRestoreSessionAction;
import org.elasticsearch.xpack.ccr.action.repositories.ClearCcrRestoreSessionRequest;
import org.elasticsearch.xpack.ccr.action.repositories.GetCcrRestoreFileChunkAction;
import org.elasticsearch.xpack.ccr.action.repositories.GetCcrRestoreFileChunkRequest;
import org.elasticsearch.xpack.ccr.action.repositories.PutCcrRestoreSessionAction;
import org.elasticsearch.xpack.ccr.action.repositories.PutCcrRestoreSessionRequest;

public class CcrRepository
extends AbstractLifecycleComponent
implements Repository {
    private static final Logger logger = LogManager.getLogger(CcrRepository.class);
    public static final String LATEST = "_latest_";
    public static final String TYPE = "_ccr_";
    public static final String NAME_PREFIX = "_ccr_";
    private static final SnapshotId SNAPSHOT_ID = new SnapshotId("_latest_", "_latest_");
    private static final String IN_SYNC_ALLOCATION_ID = "ccr_restore";
    private final RepositoryMetaData metadata;
    private final CcrSettings ccrSettings;
    private final String localClusterName;
    private final String remoteClusterAlias;
    private final Client client;
    private final CcrLicenseChecker ccrLicenseChecker;
    private final ThreadPool threadPool;
    private final CounterMetric throttledTime = new CounterMetric();

    public CcrRepository(RepositoryMetaData metadata, Client client, CcrLicenseChecker ccrLicenseChecker, Settings settings, CcrSettings ccrSettings, ThreadPool threadPool) {
        this.metadata = metadata;
        this.ccrSettings = ccrSettings;
        this.localClusterName = ((ClusterName)ClusterName.CLUSTER_NAME_SETTING.get(settings)).value();
        assert (metadata.name().startsWith("_ccr_")) : "CcrRepository metadata.name() must start with: _ccr_";
        this.remoteClusterAlias = Strings.split((String)metadata.name(), (String)"_ccr_")[1];
        this.ccrLicenseChecker = ccrLicenseChecker;
        this.client = client;
        this.threadPool = threadPool;
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    protected void doClose() {
    }

    public RepositoryMetaData getMetadata() {
        return this.metadata;
    }

    private Client getRemoteClusterClient() {
        return this.client.getRemoteClusterClient(this.remoteClusterAlias);
    }

    public SnapshotInfo getSnapshotInfo(SnapshotId snapshotId) {
        assert (SNAPSHOT_ID.equals((Object)snapshotId)) : "RemoteClusterRepository only supports " + SNAPSHOT_ID + " as the SnapshotId";
        Client remoteClient = this.getRemoteClusterClient();
        ClusterStateResponse response = (ClusterStateResponse)remoteClient.admin().cluster().prepareState().clear().setMetaData(true).setNodes(true).get(this.ccrSettings.getRecoveryActionTimeout());
        ImmutableOpenMap indicesMap = response.getState().metaData().indices();
        ArrayList indices = new ArrayList(indicesMap.size());
        indicesMap.keysIt().forEachRemaining(indices::add);
        return new SnapshotInfo(snapshotId, indices, SnapshotState.SUCCESS, response.getState().getNodes().getMaxNodeVersion());
    }

    public MetaData getSnapshotGlobalMetaData(SnapshotId snapshotId) {
        assert (SNAPSHOT_ID.equals((Object)snapshotId)) : "RemoteClusterRepository only supports " + SNAPSHOT_ID + " as the SnapshotId";
        Client remoteClient = this.getRemoteClusterClient();
        ClusterStateRequest clusterStateRequest = CcrRequests.metaDataRequest("dummy_index_name");
        ClusterStateResponse clusterState = (ClusterStateResponse)remoteClient.admin().cluster().state(clusterStateRequest).actionGet(this.ccrSettings.getRecoveryActionTimeout());
        return clusterState.getState().metaData();
    }

    public IndexMetaData getSnapshotIndexMetaData(SnapshotId snapshotId, IndexId index) throws IOException {
        assert (SNAPSHOT_ID.equals((Object)snapshotId)) : "RemoteClusterRepository only supports " + SNAPSHOT_ID + " as the SnapshotId";
        String leaderIndex = index.getName();
        Client remoteClient = this.getRemoteClusterClient();
        ClusterStateRequest clusterStateRequest = CcrRequests.metaDataRequest(leaderIndex);
        ClusterStateResponse clusterState = (ClusterStateResponse)remoteClient.admin().cluster().state(clusterStateRequest).actionGet(this.ccrSettings.getRecoveryActionTimeout());
        PlainActionFuture future = PlainActionFuture.newFuture();
        IndexMetaData leaderIndexMetaData = clusterState.getState().metaData().index(leaderIndex);
        this.ccrLicenseChecker.fetchLeaderHistoryUUIDs(remoteClient, leaderIndexMetaData, arg_0 -> ((PlainActionFuture)future).onFailure(arg_0), arg_0 -> ((PlainActionFuture)future).onResponse(arg_0));
        CharSequence[] leaderHistoryUUIDs = (String[])future.actionGet(this.ccrSettings.getRecoveryActionTimeout());
        IndexMetaData.Builder imdBuilder = IndexMetaData.builder((String)leaderIndex);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("leader_index_shard_history_uuids", String.join((CharSequence)",", leaderHistoryUUIDs));
        metadata.put("leader_index_uuid", leaderIndexMetaData.getIndexUUID());
        metadata.put("leader_index_name", leaderIndexMetaData.getIndex().getName());
        metadata.put("remote_cluster_name", this.remoteClusterAlias);
        imdBuilder.putCustom("ccr", metadata);
        imdBuilder.settings(leaderIndexMetaData.getSettings());
        for (ObjectObjectCursor cursor : leaderIndexMetaData.getMappings()) {
            imdBuilder.putMapping((MappingMetaData)cursor.value);
        }
        imdBuilder.setRoutingNumShards(leaderIndexMetaData.getRoutingNumShards());
        for (IntObjectCursor entry : leaderIndexMetaData.getInSyncAllocationIds()) {
            imdBuilder.putInSyncAllocationIds(entry.key, Collections.singleton(IN_SYNC_ALLOCATION_ID));
        }
        return imdBuilder.build();
    }

    public RepositoryData getRepositoryData() {
        Client remoteClient = this.getRemoteClusterClient();
        ClusterStateResponse response = (ClusterStateResponse)remoteClient.admin().cluster().prepareState().clear().setMetaData(true).get(this.ccrSettings.getRecoveryActionTimeout());
        MetaData remoteMetaData = response.getState().getMetaData();
        HashMap<String, SnapshotId> copiedSnapshotIds = new HashMap<String, SnapshotId>();
        HashMap<String, SnapshotState> snapshotStates = new HashMap<String, SnapshotState>(copiedSnapshotIds.size());
        HashMap<IndexId, Set<SnapshotId>> indexSnapshots = new HashMap<IndexId, Set<SnapshotId>>(copiedSnapshotIds.size());
        ImmutableOpenMap remoteIndices = remoteMetaData.getIndices();
        for (String indexName : remoteMetaData.getConcreteAllIndices()) {
            SnapshotId snapshotId = new SnapshotId(LATEST, LATEST);
            copiedSnapshotIds.put(indexName, snapshotId);
            snapshotStates.put(indexName, SnapshotState.SUCCESS);
            Index index = ((IndexMetaData)remoteIndices.get((Object)indexName)).getIndex();
            indexSnapshots.put(new IndexId(indexName, index.getUUID()), Collections.singleton(snapshotId));
        }
        return new RepositoryData(1L, copiedSnapshotIds, snapshotStates, indexSnapshots, Collections.emptyList());
    }

    public void initializeSnapshot(SnapshotId snapshotId, List<IndexId> indices, MetaData metaData) {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public SnapshotInfo finalizeSnapshot(SnapshotId snapshotId, List<IndexId> indices, long startTime, String failure, int totalShards, List<SnapshotShardFailure> shardFailures, long repositoryStateId, boolean includeGlobalState) {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public void deleteSnapshot(SnapshotId snapshotId, long repositoryStateId) {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public long getSnapshotThrottleTimeInNanos() {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public long getRestoreThrottleTimeInNanos() {
        return this.throttledTime.count();
    }

    public String startVerification() {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public void endVerification(String verificationToken) {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public void verify(String verificationToken, DiscoveryNode localNode) {
    }

    public boolean isReadOnly() {
        return true;
    }

    public void snapshotShard(IndexShard shard, Store store, SnapshotId snapshotId, IndexId indexId, IndexCommit snapshotIndexCommit, IndexShardSnapshotStatus snapshotStatus) {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public void restoreShard(IndexShard indexShard, SnapshotId snapshotId, Version version, IndexId indexId, ShardId shardId, RecoveryState recoveryState) {
        this.createEmptyStore(indexShard, shardId);
        Map ccrMetaData = indexShard.indexSettings().getIndexMetaData().getCustomData("ccr");
        String leaderIndexName = (String)ccrMetaData.get("leader_index_name");
        String leaderUUID = (String)ccrMetaData.get("leader_index_uuid");
        Index leaderIndex = new Index(leaderIndexName, leaderUUID);
        ShardId leaderShardId = new ShardId(leaderIndex, shardId.getId());
        Client remoteClient = this.getRemoteClusterClient();
        String retentionLeaseId = CcrRetentionLeases.retentionLeaseId(this.localClusterName, indexShard.shardId().getIndex(), this.remoteClusterAlias, leaderIndex);
        this.acquireRetentionLeaseOnLeader(shardId, retentionLeaseId, leaderShardId, remoteClient);
        Scheduler.Cancellable renewable = this.threadPool.scheduleWithFixedDelay(() -> {
            logger.trace("{} background renewal of retention lease [{}] during restore", (Object)indexShard.shardId(), (Object)retentionLeaseId);
            ThreadContext threadContext = this.threadPool.getThreadContext();
            try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
                threadContext.markAsSystemContext();
                CcrRetentionLeases.asyncRenewRetentionLease(leaderShardId, retentionLeaseId, -1L, remoteClient, (ActionListener<RetentionLeaseActions.Response>)ActionListener.wrap(r -> {}, e -> {
                    Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                    assert (!(cause instanceof ElasticsearchSecurityException)) : cause;
                    if (!CcrRetentionLeases.isInvalidRetainingSequenceNumberError(retentionLeaseId, cause)) {
                        logger.warn((Message)new ParameterizedMessage("{} background renewal of retention lease [{}] failed during restore", (Object)shardId, (Object)retentionLeaseId), cause);
                    }
                }));
            }
        }, (TimeValue)CcrRetentionLeases.RETENTION_LEASE_RENEW_INTERVAL_SETTING.get(indexShard.indexSettings().getNodeSettings()), "ccr");
        try (RestoreSession restoreSession = this.openSession(this.metadata.name(), remoteClient, leaderShardId, indexShard, recoveryState);){
            restoreSession.restoreFiles();
            this.updateMappings(remoteClient, leaderIndex, restoreSession.mappingVersion, this.client, indexShard.routingEntry().index());
        }
        catch (Exception e) {
            throw new IndexShardRestoreFailedException(indexShard.shardId(), "failed to restore snapshot [" + snapshotId + "]", (Throwable)e);
        }
        finally {
            logger.trace("{} canceling background renewal of retention lease [{}] at the end of restore", (Object)shardId, (Object)retentionLeaseId);
            renewable.cancel();
        }
    }

    private void createEmptyStore(IndexShard indexShard, ShardId shardId) {
        Store store = indexShard.store();
        store.incRef();
        try {
            store.createEmpty();
        }
        catch (IOException | EngineException e) {
            throw new IndexShardRecoveryException(shardId, "failed to create empty store", e);
        }
        finally {
            store.decRef();
        }
    }

    void acquireRetentionLeaseOnLeader(ShardId shardId, String retentionLeaseId, ShardId leaderShardId, Client remoteClient) {
        logger.trace(() -> new ParameterizedMessage("{} requesting leader to add retention lease [{}]", (Object)shardId, (Object)retentionLeaseId));
        TimeValue timeout = this.ccrSettings.getRecoveryActionTimeout();
        Optional<RetentionLeaseAlreadyExistsException> maybeAddAlready = CcrRetentionLeases.syncAddRetentionLease(leaderShardId, retentionLeaseId, -1L, remoteClient, timeout);
        maybeAddAlready.ifPresent(addAlready -> {
            logger.trace(() -> new ParameterizedMessage("{} retention lease [{}] already exists, requesting a renewal", (Object)shardId, (Object)retentionLeaseId), (Throwable)addAlready);
            Optional<RetentionLeaseNotFoundException> maybeRenewNotFound = CcrRetentionLeases.syncRenewRetentionLease(leaderShardId, retentionLeaseId, -1L, remoteClient, timeout);
            maybeRenewNotFound.ifPresent(renewNotFound -> {
                logger.trace(() -> new ParameterizedMessage("{} retention lease [{}] not found while attempting to renew, requesting a final add", (Object)shardId, (Object)retentionLeaseId), (Throwable)renewNotFound);
                Optional<RetentionLeaseAlreadyExistsException> maybeFallbackAddAlready = CcrRetentionLeases.syncAddRetentionLease(leaderShardId, retentionLeaseId, -1L, remoteClient, timeout);
                maybeFallbackAddAlready.ifPresent(fallbackAddAlready -> {
                    assert (false) : fallbackAddAlready;
                    throw fallbackAddAlready;
                });
            });
        });
    }

    public IndexShardSnapshotStatus getShardSnapshotStatus(SnapshotId snapshotId, Version version, IndexId indexId, ShardId leaderShardId) {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    private void updateMappings(Client leaderClient, Index leaderIndex, long leaderMappingVersion, Client followerClient, Index followerIndex) {
        PlainActionFuture indexMetadataFuture = new PlainActionFuture();
        long startTimeInNanos = System.nanoTime();
        Supplier<TimeValue> timeout = () -> {
            long elapsedInNanos = System.nanoTime() - startTimeInNanos;
            return TimeValue.timeValueNanos((long)(this.ccrSettings.getRecoveryActionTimeout().nanos() - elapsedInNanos));
        };
        CcrRequests.getIndexMetadata(leaderClient, leaderIndex, leaderMappingVersion, 0L, timeout, (ActionListener<IndexMetaData>)indexMetadataFuture);
        IndexMetaData leaderIndexMetadata = (IndexMetaData)indexMetadataFuture.actionGet(this.ccrSettings.getRecoveryActionTimeout());
        if (leaderIndexMetadata.getMappings().isEmpty()) {
            assert (leaderIndexMetadata.getMappingVersion() == 1L);
        } else {
            assert (leaderIndexMetadata.getMappings().size() == 1) : "expected exactly one mapping, but got [" + leaderIndexMetadata.getMappings().size() + "]";
            MappingMetaData mappingMetaData = (MappingMetaData)((ObjectObjectCursor)leaderIndexMetadata.getMappings().iterator().next()).value;
            if (mappingMetaData != null) {
                PutMappingRequest putMappingRequest = (PutMappingRequest)CcrRequests.putMappingRequest(followerIndex.getName(), mappingMetaData).masterNodeTimeout(TimeValue.timeValueMinutes((long)30L));
                followerClient.admin().indices().putMapping(putMappingRequest).actionGet(this.ccrSettings.getRecoveryActionTimeout());
            }
        }
    }

    RestoreSession openSession(String repositoryName, Client remoteClient, ShardId leaderShardId, IndexShard indexShard, RecoveryState recoveryState) {
        String sessionUUID = UUIDs.randomBase64UUID();
        PutCcrRestoreSessionAction.PutCcrRestoreSessionResponse response = (PutCcrRestoreSessionAction.PutCcrRestoreSessionResponse)((Object)remoteClient.execute((Action)PutCcrRestoreSessionAction.INSTANCE, (ActionRequest)new PutCcrRestoreSessionRequest(sessionUUID, leaderShardId)).actionGet(this.ccrSettings.getRecoveryActionTimeout()));
        return new RestoreSession(repositoryName, remoteClient, sessionUUID, response.getNode(), indexShard, recoveryState, response.getStoreFileMetaData(), response.getMappingVersion(), this.threadPool, this.ccrSettings, arg_0 -> ((CounterMetric)this.throttledTime).inc(arg_0));
    }

    private static class RestoreSession
    extends FileRestoreContext
    implements Closeable {
        private final Client remoteClient;
        private final String sessionUUID;
        private final DiscoveryNode node;
        private final Store.MetadataSnapshot sourceMetaData;
        private final long mappingVersion;
        private final CcrSettings ccrSettings;
        private final LongConsumer throttleListener;
        private final ThreadPool threadPool;

        RestoreSession(String repositoryName, Client remoteClient, String sessionUUID, DiscoveryNode node, IndexShard indexShard, RecoveryState recoveryState, Store.MetadataSnapshot sourceMetaData, long mappingVersion, ThreadPool threadPool, CcrSettings ccrSettings, LongConsumer throttleListener) {
            super(repositoryName, indexShard, SNAPSHOT_ID, recoveryState, Math.toIntExact(ccrSettings.getChunkSize().getBytes()));
            this.remoteClient = remoteClient;
            this.sessionUUID = sessionUUID;
            this.node = node;
            this.sourceMetaData = sourceMetaData;
            this.mappingVersion = mappingVersion;
            this.threadPool = threadPool;
            this.ccrSettings = ccrSettings;
            this.throttleListener = throttleListener;
        }

        void restoreFiles() throws IOException {
            ArrayList<BlobStoreIndexShardSnapshot.FileInfo> fileInfos = new ArrayList<BlobStoreIndexShardSnapshot.FileInfo>();
            for (StoreFileMetaData fileMetaData : this.sourceMetaData) {
                ByteSizeValue fileSize = new ByteSizeValue(fileMetaData.length());
                fileInfos.add(new BlobStoreIndexShardSnapshot.FileInfo(fileMetaData.name(), fileMetaData, fileSize));
            }
            SnapshotFiles snapshotFiles = new SnapshotFiles(CcrRepository.LATEST, fileInfos);
            this.restore(snapshotFiles);
        }

        protected void restoreFiles(List<BlobStoreIndexShardSnapshot.FileInfo> filesToRecover, Store store) throws IOException {
            logger.trace("[{}] starting CCR restore of {} files", (Object)this.shardId, filesToRecover);
            try (MultiFileWriter multiFileWriter = new MultiFileWriter(store, this.recoveryState.getIndex(), "", logger, () -> {});){
                final LocalCheckpointTracker requestSeqIdTracker = new LocalCheckpointTracker(-1L, -1L);
                final AtomicReference<Tuple> error = new AtomicReference<Tuple>();
                block9: for (final BlobStoreIndexShardSnapshot.FileInfo fileInfo : filesToRecover) {
                    long fileLength = fileInfo.length();
                    long offset = 0L;
                    while (offset < fileLength && error.get() == null) {
                        final long requestSeqId = requestSeqIdTracker.generateSeqNo();
                        try {
                            requestSeqIdTracker.waitForOpsToComplete(requestSeqId - (long)this.ccrSettings.getMaxConcurrentFileChunks());
                            if (error.get() != null) {
                                requestSeqIdTracker.markSeqNoAsCompleted(requestSeqId);
                                continue block9;
                            }
                            int bytesRequested = Math.toIntExact(Math.min(this.ccrSettings.getChunkSize().getBytes(), fileLength - offset));
                            GetCcrRestoreFileChunkRequest request = new GetCcrRestoreFileChunkRequest(this.node, this.sessionUUID, fileInfo.name(), bytesRequested);
                            logger.trace("[{}] [{}] fetching chunk for file [{}], expected offset: {}, size: {}", (Object)this.shardId, (Object)this.snapshotId, (Object)fileInfo.name(), (Object)(offset += (long)bytesRequested), (Object)bytesRequested);
                            TimeValue timeout = this.ccrSettings.getRecoveryActionTimeout();
                            ActionListener listener = ListenerTimeouts.wrapWithTimeout((ThreadPool)this.threadPool, (ActionListener)ActionListener.wrap(r -> this.threadPool.generic().execute((Runnable)new AbstractRunnable((GetCcrRestoreFileChunkAction.GetCcrRestoreFileChunkResponse)((Object)r), fileLength, multiFileWriter){
                                final /* synthetic */ GetCcrRestoreFileChunkAction.GetCcrRestoreFileChunkResponse val$r;
                                final /* synthetic */ long val$fileLength;
                                final /* synthetic */ MultiFileWriter val$multiFileWriter;
                                {
                                    this.val$r = getCcrRestoreFileChunkResponse;
                                    this.val$fileLength = l2;
                                    this.val$multiFileWriter = multiFileWriter;
                                }

                                public void onFailure(Exception e) {
                                    error.compareAndSet(null, Tuple.tuple((Object)fileInfo.metadata(), (Object)e));
                                    requestSeqIdTracker.markSeqNoAsCompleted(requestSeqId);
                                }

                                protected void doRun() throws Exception {
                                    int actualChunkSize = this.val$r.getChunk().length();
                                    logger.trace("[{}] [{}] got response for file [{}], offset: {}, length: {}", (Object)shardId, (Object)snapshotId, (Object)fileInfo.name(), (Object)this.val$r.getOffset(), (Object)actualChunkSize);
                                    long nanosPaused = ccrSettings.getRateLimiter().maybePause(actualChunkSize);
                                    throttleListener.accept(nanosPaused);
                                    boolean lastChunk = this.val$r.getOffset() + (long)actualChunkSize >= this.val$fileLength;
                                    this.val$multiFileWriter.writeFileChunk(fileInfo.metadata(), this.val$r.getOffset(), this.val$r.getChunk(), lastChunk);
                                    requestSeqIdTracker.markSeqNoAsCompleted(requestSeqId);
                                }
                            }), e -> {
                                error.compareAndSet(null, Tuple.tuple((Object)fileInfo.metadata(), (Object)e));
                                requestSeqIdTracker.markSeqNoAsCompleted(requestSeqId);
                            }), (TimeValue)timeout, (String)"generic", (String)"internal:admin/ccr/restore/file_chunk/get");
                            this.remoteClient.execute((Action)GetCcrRestoreFileChunkAction.INSTANCE, (ActionRequest)request, listener);
                        }
                        catch (Exception e2) {
                            error.compareAndSet(null, Tuple.tuple((Object)fileInfo.metadata(), (Object)e2));
                            requestSeqIdTracker.markSeqNoAsCompleted(requestSeqId);
                        }
                    }
                }
                try {
                    requestSeqIdTracker.waitForOpsToComplete(requestSeqIdTracker.getMaxSeqNo());
                }
                catch (InterruptedException e3) {
                    Thread.currentThread().interrupt();
                    throw new ElasticsearchException((Throwable)e3);
                }
                if (error.get() != null) {
                    this.handleError(store, (Exception)((Tuple)error.get()).v2());
                }
            }
            logger.trace("[{}] completed CCR restore", (Object)this.shardId);
        }

        private void handleError(Store store, Exception e) throws IOException {
            IOException corruptIndexException = ExceptionsHelper.unwrapCorruption((Throwable)e);
            if (corruptIndexException != null) {
                try {
                    store.markStoreCorrupted(corruptIndexException);
                }
                catch (IOException ioe) {
                    logger.warn("store cannot be marked as corrupted", (Throwable)e);
                }
                throw corruptIndexException;
            }
            ExceptionsHelper.reThrowIfNotNull((Throwable)e);
        }

        protected InputStream fileInputStream(BlobStoreIndexShardSnapshot.FileInfo fileInfo) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            ClearCcrRestoreSessionRequest clearRequest = new ClearCcrRestoreSessionRequest(this.sessionUUID, this.node);
            ClearCcrRestoreSessionAction.ClearCcrRestoreSessionResponse response = (ClearCcrRestoreSessionAction.ClearCcrRestoreSessionResponse)((Object)this.remoteClient.execute((Action)ClearCcrRestoreSessionAction.INSTANCE, (ActionRequest)clearRequest).actionGet(this.ccrSettings.getRecoveryActionTimeout()));
        }
    }
}

