/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.indexlifecycle.action;

import java.io.IOException;
import java.util.HashMap;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.info.TransportClusterInfoAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.indexlifecycle.ExplainLifecycleRequest;
import org.elasticsearch.xpack.core.indexlifecycle.ExplainLifecycleResponse;
import org.elasticsearch.xpack.core.indexlifecycle.IndexLifecycleExplainResponse;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleExecutionState;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleSettings;
import org.elasticsearch.xpack.core.indexlifecycle.PhaseExecutionInfo;

public class TransportExplainLifecycleAction
extends TransportClusterInfoAction<ExplainLifecycleRequest, ExplainLifecycleResponse> {
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public TransportExplainLifecycleAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NamedXContentRegistry xContentRegistry) {
        super(settings, "indices:admin/ilm/explain", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, ExplainLifecycleRequest::new);
        this.xContentRegistry = xContentRegistry;
    }

    protected ExplainLifecycleResponse newResponse() {
        return new ExplainLifecycleResponse();
    }

    protected String executor() {
        return "same";
    }

    protected ClusterBlockException checkBlock(ExplainLifecycleRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNames(state, (IndicesRequest)request));
    }

    protected void doMasterOperation(ExplainLifecycleRequest request, String[] concreteIndices, ClusterState state, ActionListener<ExplainLifecycleResponse> listener) {
        HashMap<String, IndexLifecycleExplainResponse> indexReponses = new HashMap<String, IndexLifecycleExplainResponse>();
        for (String index : concreteIndices) {
            IndexMetaData idxMetadata = state.metaData().index(index);
            Settings idxSettings = idxMetadata.getSettings();
            LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata((IndexMetaData)idxMetadata);
            String policyName = (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(idxSettings);
            String currentPhase = lifecycleState.getPhase();
            String stepInfo = lifecycleState.getStepInfo();
            BytesArray stepInfoBytes = null;
            if (stepInfo != null) {
                stepInfoBytes = new BytesArray(stepInfo);
            }
            String phaseDef = lifecycleState.getPhaseDefinition();
            PhaseExecutionInfo phaseExecutionInfo = null;
            if (!Strings.isNullOrEmpty((String)phaseDef)) {
                try (XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, phaseDef);){
                    phaseExecutionInfo = PhaseExecutionInfo.parse((XContentParser)parser, (String)currentPhase);
                }
                catch (IOException e) {
                    listener.onFailure((Exception)new ElasticsearchParseException("failed to parse phase definition for index [" + index + "]", (Throwable)e, new Object[0]));
                    return;
                }
            }
            IndexLifecycleExplainResponse indexResponse = Strings.hasLength((String)policyName) ? IndexLifecycleExplainResponse.newManagedIndexResponse((String)index, (String)policyName, (Long)lifecycleState.getLifecycleDate(), (String)lifecycleState.getPhase(), (String)lifecycleState.getAction(), (String)lifecycleState.getStep(), (String)lifecycleState.getFailedStep(), (Long)lifecycleState.getPhaseTime(), (Long)lifecycleState.getActionTime(), (Long)lifecycleState.getStepTime(), (BytesReference)stepInfoBytes, (PhaseExecutionInfo)phaseExecutionInfo) : IndexLifecycleExplainResponse.newUnmanagedIndexResponse((String)index);
            indexReponses.put(indexResponse.getIndex(), indexResponse);
        }
        listener.onResponse((Object)new ExplainLifecycleResponse(indexReponses));
    }
}

