/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.common.socket.SocketAccess;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authc.saml.SamlRealmSettings;
import org.elasticsearch.xpack.core.ssl.KeyConfig;
import org.elasticsearch.xpack.core.ssl.SSLConfiguration;
import org.elasticsearch.xpack.core.ssl.TLSv1DeprecationHandler;
import org.elasticsearch.xpack.core.ssl.TrustConfig;
import org.elasticsearch.xpack.core.ssl.cert.CertificateInfo;

public class SSLService
extends AbstractComponent {
    private static final Logger logger = LogManager.getLogger(SSLService.class);
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(logger);
    private final Map<String, SSLConfiguration> sslConfigurations;
    private final Map<SSLConfiguration, SSLContextHolder> sslContexts;
    private final SSLConfiguration globalSSLConfiguration;
    private final SetOnce<SSLConfiguration> transportSSLConfiguration = new SetOnce();
    private final Environment env;
    private final Settings settings;

    public SSLService(Settings settings, Environment environment) {
        this.settings = settings;
        this.env = environment;
        this.globalSSLConfiguration = new SSLConfiguration(settings.getByPrefix("xpack.ssl."));
        this.sslConfigurations = new HashMap<String, SSLConfiguration>();
        this.sslContexts = this.loadSSLConfigurations();
    }

    private SSLService(Settings settings, Environment environment, SSLConfiguration globalSSLConfiguration, Map<String, SSLConfiguration> sslConfigurations, Map<SSLConfiguration, SSLContextHolder> sslContexts) {
        this.settings = settings;
        this.env = environment;
        this.globalSSLConfiguration = globalSSLConfiguration;
        this.sslConfigurations = sslConfigurations;
        this.sslContexts = sslContexts;
    }

    public SSLService createDynamicSSLService() {
        return new SSLService(this.settings, this.env, this.globalSSLConfiguration, this.sslConfigurations, this.sslContexts){

            @Override
            Map<SSLConfiguration, SSLContextHolder> loadSSLConfigurations() {
                return Collections.emptyMap();
            }

            @Override
            SSLConfiguration sslConfiguration(Settings settings) {
                SSLConfiguration sslConfiguration = super.sslConfiguration(settings);
                SSLService.this.checkSSLConfigurationForFallback("monitoring.exporters", settings, sslConfiguration);
                return sslConfiguration;
            }

            @Override
            SSLContextHolder sslContextHolder(SSLConfiguration sslConfiguration) {
                SSLContextHolder holder = (SSLContextHolder)SSLService.this.sslContexts.get(sslConfiguration);
                if (holder == null) {
                    holder = SSLService.this.createSslContext(sslConfiguration);
                }
                return holder;
            }
        };
    }

    @Deprecated
    public SSLIOSessionStrategy sslIOSessionStrategy(Settings settings, TLSv1DeprecationHandler tlsDeprecationHandler) {
        SSLConfiguration config = this.sslConfiguration(settings);
        return this.sslIOSessionStrategy(config, tlsDeprecationHandler);
    }

    public SSLIOSessionStrategy sslIOSessionStrategy(SSLConfiguration config, TLSv1DeprecationHandler tlsDeprecationHandler) {
        SSLContext sslContext = this.sslContext(config);
        String[] ciphers = this.supportedCiphers(this.sslParameters(sslContext).getCipherSuites(), config.cipherSuites(), false);
        String[] supportedProtocols = config.supportedProtocols().toArray(Strings.EMPTY_ARRAY);
        HostnameVerifier verifier = config.verificationMode().isHostnameVerificationEnabled() ? SSLIOSessionStrategy.getDefaultHostnameVerifier() : NoopHostnameVerifier.INSTANCE;
        verifier = this.wrapHostnameVerifier(verifier, tlsDeprecationHandler);
        return this.sslIOSessionStrategy(sslContext, supportedProtocols, ciphers, verifier);
    }

    public HostnameVerifier wrapHostnameVerifier(HostnameVerifier verifier, TLSv1DeprecationHandler tlsDeprecationHandler) {
        if (tlsDeprecationHandler.shouldLogWarnings()) {
            return (hostname, session) -> {
                tlsDeprecationHandler.checkAndLog(session, () -> "http connection to " + hostname);
                return verifier.verify(hostname, session);
            };
        }
        return verifier;
    }

    SSLParameters sslParameters(SSLContext sslContext) {
        return sslContext.getSupportedSSLParameters();
    }

    SSLIOSessionStrategy sslIOSessionStrategy(SSLContext sslContext, String[] protocols, String[] ciphers, HostnameVerifier verifier) {
        return new SSLIOSessionStrategy(sslContext, protocols, ciphers, verifier);
    }

    public SSLSocketFactory sslSocketFactory(SSLConfiguration configuration) {
        SSLContextHolder contextHolder = this.sslContextHolder(configuration);
        SSLSocketFactory socketFactory = contextHolder.sslContext().getSocketFactory();
        SecuritySSLSocketFactory securitySSLSocketFactory = new SecuritySSLSocketFactory(() -> contextHolder.sslContext().getSocketFactory(), configuration.supportedProtocols().toArray(Strings.EMPTY_ARRAY), this.supportedCiphers(socketFactory.getSupportedCipherSuites(), configuration.cipherSuites(), false));
        contextHolder.addReloadListener(securitySSLSocketFactory::reload);
        return securitySSLSocketFactory;
    }

    public SSLEngine createSSLEngine(SSLConfiguration configuration, String host, int port) {
        SSLContext sslContext = this.sslContext(configuration);
        SSLEngine sslEngine = sslContext.createSSLEngine(host, port);
        String[] ciphers = this.supportedCiphers(sslEngine.getSupportedCipherSuites(), configuration.cipherSuites(), false);
        String[] supportedProtocols = configuration.supportedProtocols().toArray(Strings.EMPTY_ARRAY);
        SSLParameters parameters = new SSLParameters(ciphers, supportedProtocols);
        if (configuration.verificationMode().isHostnameVerificationEnabled() && host != null) {
            parameters.setEndpointIdentificationAlgorithm("HTTPS");
        }
        parameters.setUseCipherSuitesOrder(true);
        configuration.sslClientAuth().configure(parameters);
        sslEngine.setSSLParameters(parameters);
        return sslEngine;
    }

    public boolean isConfigurationValidForServerUsage(SSLConfiguration sslConfiguration) {
        Objects.requireNonNull(sslConfiguration, "SSLConfiguration cannot be null");
        return sslConfiguration.keyConfig() != KeyConfig.NONE;
    }

    public boolean isSSLClientAuthEnabled(SSLConfiguration sslConfiguration) {
        Objects.requireNonNull(sslConfiguration, "SSLConfiguration cannot be null");
        return sslConfiguration.sslClientAuth().enabled();
    }

    SSLContext sslContext() {
        return this.sslContextHolder(this.globalSSLConfiguration).sslContext();
    }

    SSLContext sslContext(SSLConfiguration configuration) {
        return this.sslContextHolder(configuration).sslContext();
    }

    SSLContextHolder sslContextHolder(SSLConfiguration sslConfiguration) {
        Objects.requireNonNull(sslConfiguration, "SSL Configuration cannot be null");
        SSLContextHolder holder = this.sslContexts.get(sslConfiguration);
        if (holder == null) {
            throw new IllegalArgumentException("did not find an SSLContext for [" + sslConfiguration.toString() + "]");
        }
        return holder;
    }

    SSLConfiguration sslConfiguration(Settings settings) {
        if (settings.isEmpty()) {
            return this.globalSSLConfiguration;
        }
        return new SSLConfiguration(settings, this.globalSSLConfiguration);
    }

    public Set<String> getTransportProfileContextNames() {
        return Collections.unmodifiableSet(this.sslConfigurations.keySet().stream().filter(k -> k.startsWith("transport.profiles.")).collect(Collectors.toSet()));
    }

    Collection<SSLConfiguration> getLoadedSSLConfigurations() {
        return Collections.unmodifiableSet(new HashSet<SSLConfiguration>(this.sslContexts.keySet()));
    }

    String[] supportedCiphers(String[] supportedCiphers, List<String> requestedCiphers, boolean log) {
        ArrayList<String> supportedCiphersList = new ArrayList<String>(requestedCiphers.size());
        LinkedList<String> unsupportedCiphers = new LinkedList<String>();
        for (String requestedCipher : requestedCiphers) {
            boolean found = false;
            for (String supportedCipher : supportedCiphers) {
                if (!supportedCipher.equals(requestedCipher)) continue;
                found = true;
                supportedCiphersList.add(requestedCipher);
                break;
            }
            if (found) continue;
            unsupportedCiphers.add(requestedCipher);
        }
        if (supportedCiphersList.isEmpty()) {
            throw new IllegalArgumentException("none of the ciphers " + Arrays.toString(requestedCiphers.toArray()) + " are supported by this JVM");
        }
        if (log && !unsupportedCiphers.isEmpty()) {
            logger.error("unsupported ciphers [{}] were requested but cannot be used in this JVM, however there are supported ciphers that will be used [{}]. If you are trying to use ciphers with a key length greater than 128 bits on an Oracle JVM, you will need to install the unlimited strength JCE policy files.", unsupportedCiphers, supportedCiphersList);
        }
        return supportedCiphersList.toArray(new String[supportedCiphersList.size()]);
    }

    private SSLContextHolder createSslContext(SSLConfiguration sslConfiguration) {
        if (logger.isDebugEnabled()) {
            logger.debug("using ssl settings [{}]", (Object)sslConfiguration);
        }
        X509ExtendedTrustManager trustManager = sslConfiguration.trustConfig().createTrustManager(this.env);
        X509ExtendedKeyManager keyManager = sslConfiguration.keyConfig().createKeyManager(this.env);
        return this.createSslContext(keyManager, trustManager, sslConfiguration);
    }

    private SSLContextHolder createSslContext(X509ExtendedKeyManager keyManager, X509ExtendedTrustManager trustManager, SSLConfiguration sslConfiguration) {
        try {
            SSLContext sslContext = SSLContext.getInstance(SSLService.sslContextAlgorithm(sslConfiguration.supportedProtocols()));
            sslContext.init(new X509ExtendedKeyManager[]{keyManager}, new X509ExtendedTrustManager[]{trustManager}, null);
            this.supportedCiphers(sslContext.getSupportedSSLParameters().getCipherSuites(), sslConfiguration.cipherSuites(), true);
            return new SSLContextHolder(sslContext, sslConfiguration);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new ElasticsearchException("failed to initialize the SSLContext", (Throwable)e, new Object[0]);
        }
    }

    Map<SSLConfiguration, SSLContextHolder> loadSSLConfigurations() {
        HashMap<SSLConfiguration, SSLContextHolder> sslContextHolders = new HashMap<SSLConfiguration, SSLContextHolder>();
        sslContextHolders.put(this.globalSSLConfiguration, this.createSslContext(this.globalSSLConfiguration));
        this.sslConfigurations.put("xpack.ssl", this.globalSSLConfiguration);
        HashMap<String, Settings> sslSettingsMap = new HashMap<String, Settings>();
        sslSettingsMap.put(XPackSettings.HTTP_SSL_PREFIX, this.getHttpTransportSSLSettings(this.settings));
        sslSettingsMap.put("xpack.http.ssl", this.settings.getByPrefix("xpack.http.ssl."));
        sslSettingsMap.putAll(SSLService.getRealmsSSLSettings(this.settings));
        sslSettingsMap.putAll(SSLService.getMonitoringExporterSettings(this.settings));
        sslSettingsMap.forEach((key, sslSettings) -> {
            if (sslSettings.isEmpty()) {
                if (this.shouldCheckForFallbackDeprecation((String)key)) {
                    this.checkSSLConfigurationForFallback((String)key, (Settings)sslSettings, new SSLConfiguration((Settings)sslSettings, this.globalSSLConfiguration));
                }
                this.storeSslConfiguration((String)key, this.globalSSLConfiguration);
            } else {
                SSLConfiguration configuration = new SSLConfiguration((Settings)sslSettings, this.globalSSLConfiguration);
                if (this.shouldCheckForFallbackDeprecation((String)key)) {
                    this.checkSSLConfigurationForFallback((String)key, (Settings)sslSettings, configuration);
                }
                this.storeSslConfiguration((String)key, configuration);
                sslContextHolders.computeIfAbsent(configuration, this::createSslContext);
            }
        });
        Settings transportSSLSettings = this.settings.getByPrefix(XPackSettings.TRANSPORT_SSL_PREFIX);
        SSLConfiguration transportSSLConfiguration = new SSLConfiguration(transportSSLSettings, this.globalSSLConfiguration);
        boolean transportSSLEnabled = (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(this.settings);
        if (transportSSLEnabled) {
            this.checkSSLConfigurationForFallback(XPackSettings.TRANSPORT_SSL_PREFIX, transportSSLSettings, transportSSLConfiguration);
        }
        this.transportSSLConfiguration.set((Object)transportSSLConfiguration);
        this.storeSslConfiguration(XPackSettings.TRANSPORT_SSL_PREFIX, transportSSLConfiguration);
        Map<String, Settings> profileSettings = SSLService.getTransportProfileSSLSettings(this.settings);
        sslContextHolders.computeIfAbsent(transportSSLConfiguration, this::createSslContext);
        profileSettings.forEach((key, profileSetting) -> {
            SSLConfiguration configuration = new SSLConfiguration((Settings)profileSetting, transportSSLConfiguration);
            if (transportSSLEnabled && !key.equals("transport.profiles.default.xpack.security.ssl")) {
                this.checkSSLConfigurationForFallback((String)key, (Settings)profileSetting, configuration);
            }
            this.storeSslConfiguration((String)key, configuration);
            sslContextHolders.computeIfAbsent(configuration, this::createSslContext);
        });
        return Collections.unmodifiableMap(sslContextHolders);
    }

    private void storeSslConfiguration(String key, SSLConfiguration configuration) {
        if (key.endsWith(".")) {
            key = key.substring(0, key.length() - 1);
        }
        this.sslConfigurations.put(key, configuration);
    }

    private boolean shouldCheckForFallbackDeprecation(String name) {
        if (name.startsWith("xpack.security.authc.realms.")) {
            Settings realm = this.settings.getByPrefix(name.substring(0, name.indexOf(".ssl")));
            String type = realm.get("type");
            if ("ldap".equals(type) || "active_directory".equals(type)) {
                List urls = realm.getAsList("url");
                return !urls.isEmpty() && urls.stream().anyMatch(s -> s.startsWith("ldaps://"));
            }
            if ("saml".equals(type)) {
                String idpMetadataPath = (String)SamlRealmSettings.IDP_METADATA_PATH.get(realm);
                return Strings.hasText((String)idpMetadataPath) && idpMetadataPath.startsWith("https://");
            }
        } else {
            if (name.startsWith("xpack.monitoring.exporters.")) {
                Settings exporterSettings = this.settings.getByPrefix(name.substring(0, name.indexOf(".ssl")));
                List hosts = exporterSettings.getAsList("host");
                return hosts.stream().anyMatch(s -> s.startsWith("https"));
            }
            if (name.equals(XPackSettings.HTTP_SSL_PREFIX) && ((Boolean)XPackSettings.HTTP_SSL_ENABLED.get(this.settings)).booleanValue()) {
                return true;
            }
            if (name.equals("xpack.http.ssl") && ((Boolean)XPackSettings.WATCHER_ENABLED.get(this.settings)).booleanValue()) {
                return true;
            }
        }
        return false;
    }

    private void checkSSLConfigurationForFallback(String name, Settings settings, SSLConfiguration config) {
        SSLConfiguration noFallBackConfig = new SSLConfiguration(settings);
        if (!config.equals(noFallBackConfig)) {
            ArrayList<String> fallbackReliers = new ArrayList<String>();
            if (!config.keyConfig().equals(noFallBackConfig.keyConfig())) {
                fallbackReliers.add("key configuration");
            }
            if (!config.trustConfig().equals(noFallBackConfig.trustConfig())) {
                fallbackReliers.add("trust configuration");
            }
            if (!config.cipherSuites().equals(noFallBackConfig.cipherSuites())) {
                fallbackReliers.add("enabled cipher suites");
            }
            if (config.sslClientAuth() != noFallBackConfig.sslClientAuth()) {
                fallbackReliers.add("client authentication");
            }
            if (!config.supportedProtocols().equals(noFallBackConfig.supportedProtocols())) {
                fallbackReliers.add("supported protocols");
            }
            if (config.verificationMode() != noFallBackConfig.verificationMode()) {
                fallbackReliers.add("certificate verification mode");
            }
            deprecationLogger.deprecated("SSL configuration [{}] relies upon fallback to another configuration for {}, which is deprecated.", new Object[]{name, fallbackReliers});
        }
    }

    public Set<CertificateInfo> getLoadedCertificates() throws GeneralSecurityException, IOException {
        HashSet<CertificateInfo> certificates = new HashSet<CertificateInfo>();
        for (SSLConfiguration config : this.getLoadedSSLConfigurations()) {
            certificates.addAll(config.getDefinedCertificates(this.env));
        }
        return certificates;
    }

    static void invalidateSessions(SSLSessionContext sslSessionContext) {
        Enumeration<byte[]> sessionIds = sslSessionContext.getIds();
        while (sessionIds.hasMoreElements()) {
            byte[] sessionId = sessionIds.nextElement();
            SSLSession session = sslSessionContext.getSession(sessionId);
            if (session == null) continue;
            session.invalidate();
        }
    }

    private static Map<String, Settings> getRealmsSSLSettings(Settings settings) {
        HashMap<String, Settings> sslSettings = new HashMap<String, Settings>();
        String prefix = SecurityField.setting("authc.realms.");
        Settings realmsSettings = settings.getByPrefix(prefix);
        for (String name : realmsSettings.names()) {
            Settings realmSSLSettings = realmsSettings.getAsSettings(name).getByPrefix("ssl.");
            sslSettings.put(prefix + name + ".ssl", realmSSLSettings);
        }
        return sslSettings;
    }

    private static Map<String, Settings> getTransportProfileSSLSettings(Settings settings) {
        HashMap<String, Settings> sslSettings = new HashMap<String, Settings>();
        Map profiles = settings.getGroups("transport.profiles.", true);
        for (Map.Entry entry : profiles.entrySet()) {
            Settings profileSettings = ((Settings)entry.getValue()).getByPrefix("xpack.security.ssl.");
            sslSettings.put("transport.profiles." + (String)entry.getKey() + ".xpack.security.ssl", profileSettings);
        }
        return sslSettings;
    }

    private Settings getHttpTransportSSLSettings(Settings settings) {
        Settings httpSSLSettings = settings.getByPrefix(XPackSettings.HTTP_SSL_PREFIX);
        if (httpSSLSettings.isEmpty()) {
            return httpSSLSettings;
        }
        Settings.Builder builder = Settings.builder().put(httpSSLSettings);
        if (builder.get("client_authentication") == null) {
            builder.put("client_authentication", (Enum)XPackSettings.HTTP_CLIENT_AUTH_DEFAULT);
        }
        return builder.build();
    }

    public SSLConfiguration getHttpTransportSSLConfiguration() {
        return this.getSSLConfiguration(XPackSettings.HTTP_SSL_PREFIX);
    }

    private static Map<String, Settings> getMonitoringExporterSettings(Settings settings) {
        HashMap<String, Settings> sslSettings = new HashMap<String, Settings>();
        Map exportersSettings = settings.getGroups("xpack.monitoring.exporters.");
        for (Map.Entry entry : exportersSettings.entrySet()) {
            Settings exporterSSLSettings = ((Settings)entry.getValue()).getByPrefix("ssl.");
            sslSettings.put("xpack.monitoring.exporters." + (String)entry.getKey() + ".ssl", exporterSSLSettings);
        }
        return sslSettings;
    }

    public SSLConfiguration getSSLConfiguration(String contextName) {
        SSLConfiguration configuration;
        if (contextName.endsWith(".")) {
            contextName = contextName.substring(0, contextName.length() - 1);
        }
        if ((configuration = this.sslConfigurations.get(contextName)) == null) {
            logger.warn("Cannot find SSL configuration for context {}. Known contexts are: {}", (Object)contextName, (Object)Strings.collectionToCommaDelimitedString(this.sslConfigurations.keySet()));
        }
        return configuration;
    }

    private static String sslContextAlgorithm(List<String> supportedProtocols) {
        if (supportedProtocols.isEmpty()) {
            return "TLSv1.2";
        }
        String algorithm = "SSL";
        Iterator<String> iterator = supportedProtocols.iterator();
        block29: while (iterator.hasNext()) {
            String supportedProtocol;
            block8 : switch (supportedProtocol = iterator.next()) {
                case "TLSv1.2": {
                    return "TLSv1.2";
                }
                case "TLSv1.1": {
                    if ("TLSv1.2".equals(algorithm)) continue block29;
                    algorithm = "TLSv1.1";
                    break;
                }
                case "TLSv1": {
                    switch (algorithm) {
                        case "TLSv1.2": 
                        case "TLSv1.1": {
                            break block8;
                        }
                    }
                    algorithm = "TLSv1";
                    break;
                }
                case "SSLv3": {
                    switch (algorithm) {
                        case "SSLv2": 
                        case "SSL": {
                            algorithm = "SSLv3";
                        }
                    }
                    break;
                }
                case "SSLv2": 
                case "SSLv2Hello": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("found unexpected value in supported protocols: " + supportedProtocol);
                }
            }
        }
        return algorithm;
    }

    final class SSLContextHolder {
        private volatile SSLContext context;
        private final KeyConfig keyConfig;
        private final TrustConfig trustConfig;
        private final SSLConfiguration sslConfiguration;
        private final List<Runnable> reloadListeners;

        SSLContextHolder(SSLContext context, SSLConfiguration sslConfiguration) {
            this.context = context;
            this.sslConfiguration = sslConfiguration;
            this.keyConfig = sslConfiguration.keyConfig();
            this.trustConfig = sslConfiguration.trustConfig();
            this.reloadListeners = new ArrayList<Runnable>();
        }

        SSLContext sslContext() {
            return this.context;
        }

        synchronized void reload() {
            SSLService.invalidateSessions(this.context.getClientSessionContext());
            SSLService.invalidateSessions(this.context.getServerSessionContext());
            this.reloadSslContext();
            this.reloadListeners.forEach(Runnable::run);
        }

        private void reloadSslContext() {
            try {
                X509ExtendedKeyManager loadedKeyManager = Optional.ofNullable(this.keyConfig.createKeyManager(SSLService.this.env)).orElse(this.getEmptyKeyManager());
                X509ExtendedTrustManager loadedTrustManager = Optional.ofNullable(this.trustConfig.createTrustManager(SSLService.this.env)).orElse(this.getEmptyTrustManager());
                SSLContext loadedSslContext = SSLContext.getInstance(SSLService.sslContextAlgorithm(this.sslConfiguration.supportedProtocols()));
                loadedSslContext.init(new X509ExtendedKeyManager[]{loadedKeyManager}, new X509ExtendedTrustManager[]{loadedTrustManager}, null);
                SSLService.this.supportedCiphers(loadedSslContext.getSupportedSSLParameters().getCipherSuites(), this.sslConfiguration.cipherSuites(), false);
                this.context = loadedSslContext;
            }
            catch (IOException | GeneralSecurityException e) {
                throw new ElasticsearchException("failed to initialize the SSLContext", (Throwable)e, new Object[0]);
            }
        }

        X509ExtendedKeyManager getEmptyKeyManager() throws GeneralSecurityException, IOException {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, null);
            return (X509ExtendedKeyManager)keyManagerFactory.getKeyManagers()[0];
        }

        X509ExtendedTrustManager getEmptyTrustManager() throws GeneralSecurityException, IOException {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("X509");
            trustManagerFactory.init(keyStore);
            return (X509ExtendedTrustManager)trustManagerFactory.getTrustManagers()[0];
        }

        public void addReloadListener(Runnable listener) {
            this.reloadListeners.add(listener);
        }
    }

    private static class SecuritySSLSocketFactory
    extends SSLSocketFactory {
        private final Supplier<SSLSocketFactory> delegateSupplier;
        private final String[] supportedProtocols;
        private final String[] ciphers;
        private volatile SSLSocketFactory delegate;

        SecuritySSLSocketFactory(Supplier<SSLSocketFactory> delegateSupplier, String[] supportedProtocols, String[] ciphers) {
            this.delegateSupplier = delegateSupplier;
            this.delegate = this.delegateSupplier.get();
            this.supportedProtocols = supportedProtocols;
            this.ciphers = ciphers;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.ciphers;
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.delegate.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket() throws IOException {
            SSLSocket sslSocket = SecuritySSLSocketFactory.createWithPermissions((CheckedSupplier<Socket, IOException>)((CheckedSupplier)this.delegate::createSocket));
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
            SSLSocket sslSocket = SecuritySSLSocketFactory.createWithPermissions((CheckedSupplier<Socket, IOException>)((CheckedSupplier)() -> this.delegate.createSocket(socket, host, port, autoClose)));
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            SSLSocket sslSocket = SecuritySSLSocketFactory.createWithPermissions((CheckedSupplier<Socket, IOException>)((CheckedSupplier)() -> this.delegate.createSocket(host, port)));
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            SSLSocket sslSocket = SecuritySSLSocketFactory.createWithPermissions((CheckedSupplier<Socket, IOException>)((CheckedSupplier)() -> this.delegate.createSocket(host, port, localHost, localPort)));
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            SSLSocket sslSocket = SecuritySSLSocketFactory.createWithPermissions((CheckedSupplier<Socket, IOException>)((CheckedSupplier)() -> this.delegate.createSocket(host, port)));
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            SSLSocket sslSocket = SecuritySSLSocketFactory.createWithPermissions((CheckedSupplier<Socket, IOException>)((CheckedSupplier)() -> this.delegate.createSocket(address, port, localAddress, localPort)));
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        public void reload() {
            SSLSocketFactory newDelegate;
            this.delegate = newDelegate = this.delegateSupplier.get();
        }

        private void configureSSLSocket(SSLSocket socket) {
            SSLParameters parameters = new SSLParameters(this.ciphers, this.supportedProtocols);
            parameters.setUseCipherSuitesOrder(true);
            socket.setSSLParameters(parameters);
        }

        private static SSLSocket createWithPermissions(CheckedSupplier<Socket, IOException> supplier) throws IOException {
            return (SSLSocket)SocketAccess.doPrivileged(supplier);
        }
    }
}

