/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.TooComplexToDeterminizeException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.DocumentPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivilegesMap;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.core.security.index.RestrictedIndicesNames;
import org.elasticsearch.xpack.core.security.support.Automatons;

public final class IndicesPermission {
    public static final IndicesPermission NONE = new IndicesPermission(new Group[0]);
    private final ConcurrentMap<String, Predicate<String>> allowedIndicesMatchersForAction = new ConcurrentHashMap<String, Predicate<String>>();
    private final Group[] groups;

    public IndicesPermission(Group ... groups) {
        this.groups = groups;
    }

    static Predicate<String> indexMatcher(Collection<String> indices) {
        HashSet<String> exactMatch = new HashSet<String>();
        ArrayList<String> nonExactMatch = new ArrayList<String>();
        for (String indexPattern : indices) {
            if (indexPattern.startsWith("/") || indexPattern.contains("*") || indexPattern.contains("?")) {
                nonExactMatch.add(indexPattern);
                continue;
            }
            exactMatch.add(indexPattern);
        }
        if (exactMatch.isEmpty() && nonExactMatch.isEmpty()) {
            return s -> false;
        }
        if (exactMatch.isEmpty()) {
            return IndicesPermission.buildAutomataPredicate(nonExactMatch);
        }
        if (nonExactMatch.isEmpty()) {
            return IndicesPermission.buildExactMatchPredicate(exactMatch);
        }
        return IndicesPermission.buildExactMatchPredicate(exactMatch).or(IndicesPermission.buildAutomataPredicate(nonExactMatch));
    }

    private static Predicate<String> buildExactMatchPredicate(Set<String> indices) {
        if (indices.size() == 1) {
            String singleValue = indices.iterator().next();
            return singleValue::equals;
        }
        return indices::contains;
    }

    private static Predicate<String> buildAutomataPredicate(List<String> indices) {
        try {
            return Automatons.predicate(indices);
        }
        catch (TooComplexToDeterminizeException e) {
            LogManager.getLogger(IndicesPermission.class).debug("Index pattern automaton [{}] is too complex", indices);
            String description = Strings.collectionToCommaDelimitedString(indices);
            if (description.length() > 80) {
                description = Strings.cleanTruncate((String)description, (int)80) + "...";
            }
            throw new ElasticsearchSecurityException("The set of permitted index patterns [{}] is too complex to evaluate", (Exception)((Object)e), new Object[]{description});
        }
    }

    public Group[] groups() {
        return this.groups;
    }

    public Predicate<String> allowedIndicesMatcher(String action) {
        return this.allowedIndicesMatchersForAction.computeIfAbsent(action, a -> Group.buildIndexMatcherPredicateForAction(a, this.groups));
    }

    public boolean check(String action) {
        for (Group group : this.groups) {
            if (!group.check(action)) continue;
            return true;
        }
        return false;
    }

    public ResourcePrivilegesMap checkResourcePrivileges(Set<String> checkForIndexPatterns, boolean allowRestrictedIndices, Set<String> checkForPrivileges) {
        ResourcePrivilegesMap.Builder resourcePrivilegesMapBuilder = ResourcePrivilegesMap.builder();
        HashMap<Group, Automaton> predicateCache = new HashMap<Group, Automaton>();
        for (String forIndexPattern : checkForIndexPatterns) {
            Automaton checkIndexAutomaton = Automatons.patterns(forIndexPattern);
            if (!allowRestrictedIndices && !RestrictedIndicesNames.RESTRICTED_NAMES.contains(forIndexPattern)) {
                checkIndexAutomaton = Automatons.minusAndMinimize(checkIndexAutomaton, RestrictedIndicesNames.NAMES_AUTOMATON);
            }
            if (!Operations.isEmpty((Automaton)checkIndexAutomaton)) {
                Automaton allowedIndexPrivilegesAutomaton = null;
                for (Group group : this.groups) {
                    Automaton groupIndexAutomaton = predicateCache.computeIfAbsent(group, g -> Group.buildIndexMatcherAutomaton(g.allowRestrictedIndices(), g.indices()));
                    if (!Operations.subsetOf((Automaton)checkIndexAutomaton, (Automaton)groupIndexAutomaton)) continue;
                    allowedIndexPrivilegesAutomaton = allowedIndexPrivilegesAutomaton != null ? Automatons.unionAndMinimize(Arrays.asList(allowedIndexPrivilegesAutomaton, group.privilege().getAutomaton())) : group.privilege().getAutomaton();
                }
                for (String privilege : checkForPrivileges) {
                    IndexPrivilege indexPrivilege = IndexPrivilege.get(Collections.singleton(privilege));
                    if (allowedIndexPrivilegesAutomaton != null && Operations.subsetOf((Automaton)indexPrivilege.getAutomaton(), (Automaton)allowedIndexPrivilegesAutomaton)) {
                        resourcePrivilegesMapBuilder.addResourcePrivilege(forIndexPattern, privilege, Boolean.TRUE);
                        continue;
                    }
                    resourcePrivilegesMapBuilder.addResourcePrivilege(forIndexPattern, privilege, Boolean.FALSE);
                }
                continue;
            }
            for (String privilege : checkForPrivileges) {
                resourcePrivilegesMapBuilder.addResourcePrivilege(forIndexPattern, privilege, Boolean.FALSE);
            }
        }
        return resourcePrivilegesMapBuilder.build();
    }

    public Automaton allowedActionsMatcher(String index) {
        ArrayList<Automaton> automatonList = new ArrayList<Automaton>();
        for (Group group : this.groups) {
            if (!group.indexNameMatcher.test(index)) continue;
            automatonList.add(group.privilege.getAutomaton());
        }
        return automatonList.isEmpty() ? Automatons.EMPTY : Automatons.unionAndMinimize(automatonList);
    }

    public Map<String, IndicesAccessControl.IndexAccessControl> authorize(String action, Set<String> requestedIndicesOrAliases, Map<String, AliasOrIndex> allAliasesAndIndices, FieldPermissionsCache fieldPermissionsCache) {
        HashMap<String, Set> fieldPermissionsByIndex = new HashMap<String, Set>();
        HashMap<String, DocumentLevelPermissions> roleQueriesByIndex = new HashMap<String, DocumentLevelPermissions>();
        HashMap<String, Boolean> grantedBuilder = new HashMap<String, Boolean>();
        for (String indexOrAlias : requestedIndicesOrAliases) {
            boolean granted = false;
            HashSet<String> concreteIndices = new HashSet<String>();
            AliasOrIndex aliasOrIndex = allAliasesAndIndices.get(indexOrAlias);
            if (aliasOrIndex != null) {
                for (IndexMetaData indexMetaData : aliasOrIndex.getIndices()) {
                    concreteIndices.add(indexMetaData.getIndex().getName());
                }
            }
            for (Group group : this.groups) {
                if (!group.check(action, indexOrAlias)) continue;
                granted = true;
                for (String index : concreteIndices) {
                    Set fieldPermissions = fieldPermissionsByIndex.computeIfAbsent(index, k -> new HashSet());
                    fieldPermissionsByIndex.put(indexOrAlias, fieldPermissions);
                    fieldPermissions.add(group.getFieldPermissions());
                    DocumentLevelPermissions permissions = roleQueriesByIndex.computeIfAbsent(index, k -> new DocumentLevelPermissions());
                    roleQueriesByIndex.putIfAbsent(indexOrAlias, permissions);
                    if (group.hasQuery()) {
                        permissions.addAll(group.getQuery());
                        continue;
                    }
                    permissions.setAllowAll(true);
                }
            }
            if (concreteIndices.isEmpty()) {
                grantedBuilder.put(indexOrAlias, granted);
                continue;
            }
            grantedBuilder.put(indexOrAlias, granted);
            for (String concreteIndex : concreteIndices) {
                grantedBuilder.put(concreteIndex, granted);
            }
        }
        HashMap<String, IndicesAccessControl.IndexAccessControl> indexPermissions = new HashMap<String, IndicesAccessControl.IndexAccessControl>();
        for (Map.Entry entry : grantedBuilder.entrySet()) {
            String index = (String)entry.getKey();
            DocumentLevelPermissions permissions = (DocumentLevelPermissions)roleQueriesByIndex.get(index);
            Set<BytesReference> roleQueries = permissions != null && !permissions.isAllowAll() ? Collections.unmodifiableSet(permissions.queries) : null;
            Set indexFieldPermissions = (Set)fieldPermissionsByIndex.get(index);
            FieldPermissions fieldPermissions = indexFieldPermissions != null && !indexFieldPermissions.isEmpty() ? (indexFieldPermissions.size() == 1 ? (FieldPermissions)indexFieldPermissions.iterator().next() : fieldPermissionsCache.getFieldPermissions(indexFieldPermissions)) : FieldPermissions.DEFAULT;
            indexPermissions.put(index, new IndicesAccessControl.IndexAccessControl((Boolean)entry.getValue(), fieldPermissions, roleQueries != null ? DocumentPermissions.filteredBy(roleQueries) : DocumentPermissions.allowAll()));
        }
        return Collections.unmodifiableMap(indexPermissions);
    }

    private static class DocumentLevelPermissions {
        private Set<BytesReference> queries = null;
        private boolean allowAll = false;

        private DocumentLevelPermissions() {
        }

        private void addAll(Set<BytesReference> query) {
            if (!this.allowAll) {
                if (this.queries == null) {
                    this.queries = new HashSet<BytesReference>();
                }
                this.queries.addAll(query);
            }
        }

        private boolean isAllowAll() {
            return this.allowAll;
        }

        private void setAllowAll(boolean allowAll) {
            this.allowAll = allowAll;
        }
    }

    public static class Group {
        private final IndexPrivilege privilege;
        private final Predicate<String> actionMatcher;
        private final String[] indices;
        private final Predicate<String> indexNameMatcher;
        private final FieldPermissions fieldPermissions;
        private final Set<BytesReference> query;
        private final boolean allowRestrictedIndices;

        public Group(IndexPrivilege privilege, FieldPermissions fieldPermissions, @Nullable Set<BytesReference> query, boolean allowRestrictedIndices, String ... indices) {
            assert (indices.length != 0);
            this.privilege = privilege;
            this.actionMatcher = privilege.predicate();
            this.indices = indices;
            this.indexNameMatcher = IndicesPermission.indexMatcher(Arrays.asList(indices));
            this.fieldPermissions = Objects.requireNonNull(fieldPermissions);
            this.query = query;
            this.allowRestrictedIndices = allowRestrictedIndices;
        }

        public IndexPrivilege privilege() {
            return this.privilege;
        }

        public String[] indices() {
            return this.indices;
        }

        @Nullable
        public Set<BytesReference> getQuery() {
            return this.query;
        }

        public FieldPermissions getFieldPermissions() {
            return this.fieldPermissions;
        }

        private boolean check(String action) {
            return this.actionMatcher.test(action);
        }

        private boolean check(String action, String index) {
            assert (index != null);
            return this.check(action) && this.indexNameMatcher.test(index) && (this.allowRestrictedIndices || false == RestrictedIndicesNames.RESTRICTED_NAMES.contains(index) || IndexPrivilege.MONITOR.predicate().test(action));
        }

        boolean hasQuery() {
            return this.query != null;
        }

        public boolean allowRestrictedIndices() {
            return this.allowRestrictedIndices;
        }

        public static Automaton buildIndexMatcherAutomaton(boolean allowRestrictedIndices, String ... indices) {
            Automaton indicesAutomaton = Automatons.patterns(indices);
            if (allowRestrictedIndices) {
                return indicesAutomaton;
            }
            return Automatons.minusAndMinimize(indicesAutomaton, RestrictedIndicesNames.NAMES_AUTOMATON);
        }

        private static Predicate<String> buildIndexMatcherPredicateForAction(String action, Group ... groups) {
            HashSet<String> ordinaryIndices = new HashSet<String>();
            HashSet<String> restrictedIndices = new HashSet<String>();
            for (Group group : groups) {
                if (!group.actionMatcher.test(action)) continue;
                if (group.allowRestrictedIndices) {
                    restrictedIndices.addAll(Arrays.asList(group.indices()));
                    continue;
                }
                ordinaryIndices.addAll(Arrays.asList(group.indices()));
            }
            Predicate<String> predicate = restrictedIndices.isEmpty() ? IndicesPermission.indexMatcher(ordinaryIndices).and(index -> false == RestrictedIndicesNames.RESTRICTED_NAMES.contains(index)) : (ordinaryIndices.isEmpty() ? IndicesPermission.indexMatcher(restrictedIndices) : IndicesPermission.indexMatcher(restrictedIndices).or(IndicesPermission.indexMatcher(ordinaryIndices).and(index -> false == RestrictedIndicesNames.RESTRICTED_NAMES.contains(index))));
            return predicate;
        }
    }
}

