/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.action;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.rollup.action.GetRollupCapsAction;
import org.elasticsearch.xpack.core.rollup.action.RollableIndexCaps;
import org.elasticsearch.xpack.core.rollup.action.RollupJobCaps;
import org.elasticsearch.xpack.rollup.action.RollupIndexCaps;

public class TransportGetRollupCapsAction
extends HandledTransportAction<GetRollupCapsAction.Request, GetRollupCapsAction.Response> {
    private final ClusterService clusterService;

    @Inject
    public TransportGetRollupCapsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:monitor/xpack/rollup/get/caps", threadPool, transportService, actionFilters, indexNameExpressionResolver, GetRollupCapsAction.Request::new);
        this.clusterService = clusterService;
    }

    protected void doExecute(GetRollupCapsAction.Request request, ActionListener<GetRollupCapsAction.Response> listener) {
        Map<String, RollableIndexCaps> allCaps = TransportGetRollupCapsAction.getCaps(request.getIndexPattern(), (ImmutableOpenMap<String, IndexMetaData>)this.clusterService.state().getMetaData().indices());
        listener.onResponse((Object)new GetRollupCapsAction.Response(allCaps));
    }

    static Map<String, RollableIndexCaps> getCaps(String indexPattern, ImmutableOpenMap<String, IndexMetaData> indices) {
        TreeMap allCaps = new TreeMap();
        for (ObjectObjectCursor entry : indices) {
            TransportGetRollupCapsAction.findRollupIndexCaps((String)entry.key, (IndexMetaData)entry.value).ifPresent(cap -> {
                List<RollupJobCaps> jobCaps = indexPattern.equals("_all") ? cap.getJobCaps() : cap.getJobCapsByIndexPattern(indexPattern);
                jobCaps.forEach(jobCap -> {
                    String pattern = indexPattern.equals("_all") ? jobCap.getIndexPattern() : indexPattern;
                    ArrayList<RollupJobCaps> indexCaps = (ArrayList<RollupJobCaps>)allCaps.get(pattern);
                    if (indexCaps == null) {
                        indexCaps = new ArrayList<RollupJobCaps>();
                    }
                    indexCaps.add((RollupJobCaps)jobCap);
                    allCaps.put(pattern, indexCaps);
                });
            });
        }
        return allCaps.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new RollableIndexCaps((String)e.getKey(), (List)e.getValue())));
    }

    static Optional<RollupIndexCaps> findRollupIndexCaps(String indexName, IndexMetaData indexMetaData) {
        if (indexMetaData == null) {
            return Optional.empty();
        }
        MappingMetaData rollupMapping = (MappingMetaData)indexMetaData.getMappings().get((Object)"_doc");
        if (rollupMapping == null) {
            return Optional.empty();
        }
        Object objMeta = rollupMapping.getSourceAsMap().get("_meta");
        if (objMeta == null) {
            return Optional.empty();
        }
        RollupIndexCaps caps = RollupIndexCaps.parseMetadataXContent((BytesReference)new BytesArray(rollupMapping.source().uncompressed()), indexName);
        if (caps.hasCaps()) {
            return Optional.of(caps);
        }
        return Optional.empty();
    }
}

