/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rescore;

import java.io.IOException;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.search.SearchPhase;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.rescore.RescoreContext;

public class RescorePhase
implements SearchPhase {
    @Override
    public void preProcess(SearchContext context) {
    }

    @Override
    public void execute(SearchContext context) {
        try {
            TopDocs topDocs = context.queryResult().topDocs();
            for (RescoreContext ctx : context.rescore()) {
                topDocs = ctx.rescorer().rescore(topDocs, context.searcher(), ctx);
                assert (context.sort() == null && this.topDocsSortedByScore(topDocs)) : "topdocs should be sorted after rescore";
            }
            context.queryResult().topDocs(topDocs, context.queryResult().sortValueFormats());
        }
        catch (IOException e) {
            throw new ElasticsearchException("Rescore Phase Failed", (Throwable)e, new Object[0]);
        }
    }

    private boolean topDocsSortedByScore(TopDocs topDocs) {
        if (topDocs == null || topDocs.scoreDocs == null || topDocs.scoreDocs.length < 2) {
            return true;
        }
        float lastScore = topDocs.scoreDocs[0].score;
        for (int i = 1; i < topDocs.scoreDocs.length; ++i) {
            ScoreDoc doc = topDocs.scoreDocs[i];
            if (Float.compare(doc.score, lastScore) > 0) {
                return false;
            }
            lastScore = doc.score;
        }
        return true;
    }
}

