/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class StoredScriptSource
extends AbstractDiffable<StoredScriptSource>
implements Writeable,
ToXContentObject {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(StoredScriptSource.class));
    public static final ParseField SCRIPT_PARSE_FIELD = new ParseField("script", new String[0]);
    public static final ParseField TEMPLATE_PARSE_FIELD = new ParseField("template", new String[0]);
    public static final ParseField TEMPLATE_NO_WRAPPER_PARSE_FIELD = new ParseField("query", new String[0]);
    public static final ParseField LANG_PARSE_FIELD = new ParseField("lang", new String[0]);
    public static final ParseField SOURCE_PARSE_FIELD = new ParseField("source", new String[]{"code"});
    public static final ParseField OPTIONS_PARSE_FIELD = new ParseField("options", new String[0]);
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("stored script source", true, () -> new Builder());
    private final String lang;
    private final String source;
    private final Map<String, String> options;

    private static StoredScriptSource parseRemaining(XContentParser.Token token, XContentParser parser) throws IOException {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            if (token != XContentParser.Token.START_OBJECT) {
                builder.startObject();
                builder.copyCurrentStructure(parser);
                builder.endObject();
            } else {
                builder.copyCurrentStructure(parser);
            }
            String source = Strings.toString(builder);
            if (source == null || source.isEmpty()) {
                DEPRECATION_LOGGER.deprecated("empty templates should no longer be used", new Object[0]);
            }
            StoredScriptSource storedScriptSource = new StoredScriptSource("mustache", source, Collections.emptyMap());
            return storedScriptSource;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public static StoredScriptSource parse(BytesReference content, XContentType xContentType) {
        try {
            stream = content.streamInput();
            try {
                block37: {
                    block35: {
                        block36: {
                            block31: {
                                block34: {
                                    block32: {
                                        block33: {
                                            block29: {
                                                block30: {
                                                    block27: {
                                                        block28: {
                                                            parser = xContentType.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);
                                                            try {
                                                                token = parser.nextToken();
                                                                if (token != XContentParser.Token.START_OBJECT) {
                                                                    throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + token + "], expected [{]", new Object[0]);
                                                                }
                                                                token = parser.nextToken();
                                                                if (token != XContentParser.Token.END_OBJECT) break block27;
                                                                StoredScriptSource.DEPRECATION_LOGGER.deprecated("empty templates should no longer be used", new Object[0]);
                                                                var5_9 = new StoredScriptSource("mustache", "", Collections.emptyMap());
                                                                if (parser == null) break block28;
                                                            }
                                                            catch (Throwable var4_7) {
                                                                if (parser != null) {
                                                                    try {
                                                                        parser.close();
                                                                    }
                                                                    catch (Throwable var5_11) {
                                                                        var4_7.addSuppressed(var5_11);
                                                                    }
                                                                }
                                                                throw var4_7;
                                                            }
                                                            parser.close();
                                                        }
                                                        return var5_9;
                                                    }
                                                    if (token != XContentParser.Token.FIELD_NAME) {
                                                        throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + token + ", expected [" + StoredScriptSource.SCRIPT_PARSE_FIELD.getPreferredName() + ", " + StoredScriptSource.TEMPLATE_PARSE_FIELD.getPreferredName(), new Object[0]);
                                                    }
                                                    name = parser.currentName();
                                                    if (!StoredScriptSource.SCRIPT_PARSE_FIELD.getPreferredName().equals(name)) ** GOTO lbl44
                                                    token = parser.nextToken();
                                                    if (token != XContentParser.Token.START_OBJECT) break block29;
                                                    var6_12 = Builder.access$100((Builder)StoredScriptSource.PARSER.apply(parser, null), false);
                                                    if (parser == null) break block30;
                                                    parser.close();
                                                }
                                                return var6_12;
                                            }
                                            throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + token + "], expected [{, <source>]", new Object[0]);
lbl44:
                                            // 1 sources

                                            if (!StoredScriptSource.TEMPLATE_PARSE_FIELD.getPreferredName().equals(name)) break block31;
                                            StoredScriptSource.DEPRECATION_LOGGER.deprecated("the template context is now deprecated. Specify templates in a \"script\" element.", new Object[0]);
                                            token = parser.nextToken();
                                            if (token != XContentParser.Token.VALUE_STRING) break block32;
                                            source = parser.text();
                                            if (source == null || source.isEmpty()) {
                                                StoredScriptSource.DEPRECATION_LOGGER.deprecated("empty templates should no longer be used", new Object[0]);
                                            }
                                            var7_17 = new StoredScriptSource("mustache", source, Collections.emptyMap());
                                            if (parser == null) break block33;
                                            parser.close();
                                        }
                                        return var7_17;
                                    }
                                    var6_14 = StoredScriptSource.parseRemaining(token, parser);
                                    if (parser == null) break block34;
                                    parser.close();
                                }
                                return var6_14;
                            }
                            if (!StoredScriptSource.TEMPLATE_NO_WRAPPER_PARSE_FIELD.getPreferredName().equals(name)) break block35;
                            StoredScriptSource.DEPRECATION_LOGGER.deprecated("the template context is now deprecated. Specify templates in a \"script\" element.", new Object[0]);
                            var6_15 = StoredScriptSource.parseRemaining(token, parser);
                            if (parser == null) break block36;
                            parser.close();
                        }
                        return var6_15;
                    }
                    StoredScriptSource.DEPRECATION_LOGGER.deprecated("scripts should not be stored without a context. Specify them in a \"script\" element.", new Object[0]);
                    var6_16 = StoredScriptSource.parseRemaining(token, parser);
                    if (parser == null) break block37;
                    parser.close();
                }
                return var6_16;
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public static StoredScriptSource fromXContent(XContentParser parser, boolean ignoreEmpty) {
        return ((Builder)StoredScriptSource.PARSER.apply(parser, null)).build(ignoreEmpty);
    }

    public static Diff<StoredScriptSource> readDiffFrom(StreamInput in) throws IOException {
        return StoredScriptSource.readDiffFrom(StoredScriptSource::new, in);
    }

    public StoredScriptSource(String source) {
        this.lang = null;
        this.source = Objects.requireNonNull(source);
        this.options = null;
    }

    public StoredScriptSource(String lang, String source, Map<String, String> options) {
        this.lang = Objects.requireNonNull(lang);
        this.source = Objects.requireNonNull(source);
        this.options = Collections.unmodifiableMap(Objects.requireNonNull(options));
    }

    public StoredScriptSource(StreamInput in) throws IOException {
        if (in.getVersion().onOrAfter(Version.V_5_3_0)) {
            this.lang = in.readString();
            this.source = in.readString();
            Map<String, Object> options = in.readMap();
            this.options = options;
        } else {
            this.lang = null;
            this.source = in.readBytesReference().utf8ToString();
            this.options = null;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_5_3_0)) {
            out.writeString(this.lang);
            out.writeString(this.source);
            Map<String, Object> options = this.options;
            out.writeMap(options);
        } else {
            out.writeBytesReference(new BytesArray(this.source));
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(LANG_PARSE_FIELD.getPreferredName(), this.lang);
        builder.field(SOURCE_PARSE_FIELD.getPreferredName(), this.source);
        if (!this.options.isEmpty()) {
            builder.field(OPTIONS_PARSE_FIELD.getPreferredName(), this.options);
        }
        builder.endObject();
        return builder;
    }

    public String getLang() {
        return this.lang;
    }

    public String getSource() {
        return this.source;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredScriptSource that = (StoredScriptSource)o;
        if (this.lang != null ? !this.lang.equals(that.lang) : that.lang != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        return this.options != null ? this.options.equals(that.options) : that.options == null;
    }

    public int hashCode() {
        int result = this.lang != null ? this.lang.hashCode() : 0;
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "StoredScriptSource{lang='" + this.lang + '\'' + ", source='" + this.source + '\'' + ", options=" + this.options + '}';
    }

    static {
        PARSER.declareString((rec$, x$0) -> ((Builder)rec$).setLang(x$0), LANG_PARSE_FIELD);
        PARSER.declareField((rec$, x$0) -> ((Builder)rec$).setSource(x$0), parser -> parser, SOURCE_PARSE_FIELD, ObjectParser.ValueType.OBJECT_OR_STRING);
        PARSER.declareField((rec$, x$0) -> ((Builder)rec$).setOptions(x$0), XContentParser::mapStrings, OPTIONS_PARSE_FIELD, ObjectParser.ValueType.OBJECT);
    }

    private static final class Builder {
        private String lang;
        private String source;
        private Map<String, String> options = new HashMap<String, String>();

        private Builder() {
        }

        private void setLang(String lang) {
            this.lang = lang;
        }

        private void setSource(XContentParser parser) {
            try {
                if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                    XContentBuilder builder = XContentFactory.jsonBuilder();
                    this.source = Strings.toString(builder.copyCurrentStructure(parser));
                    this.options.put("content_type", XContentType.JSON.mediaType());
                } else {
                    this.source = parser.text();
                }
            }
            catch (IOException exception) {
                throw new UncheckedIOException(exception);
            }
        }

        private void setOptions(Map<String, String> options) {
            this.options.putAll(options);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private StoredScriptSource build(boolean ignoreEmpty) {
            if (this.lang == null) {
                throw new IllegalArgumentException("must specify lang for stored script");
            }
            if (this.lang.isEmpty()) {
                throw new IllegalArgumentException("lang cannot be empty");
            }
            if (this.source == null) {
                if (!ignoreEmpty && !"mustache".equals(this.lang)) throw new IllegalArgumentException("must specify source for stored script");
                if ("mustache".equals(this.lang)) {
                    DEPRECATION_LOGGER.deprecated("empty templates should no longer be used", new Object[0]);
                } else {
                    DEPRECATION_LOGGER.deprecated("empty scripts should no longer be used", new Object[0]);
                }
            } else if (this.source.isEmpty()) {
                if (!ignoreEmpty && !"mustache".equals(this.lang)) throw new IllegalArgumentException("source cannot be empty");
                if ("mustache".equals(this.lang)) {
                    DEPRECATION_LOGGER.deprecated("empty templates should no longer be used", new Object[0]);
                } else {
                    DEPRECATION_LOGGER.deprecated("empty scripts should no longer be used", new Object[0]);
                }
            }
            if (this.options.size() <= 1 && (this.options.size() != 1 || this.options.get("content_type") != null)) return new StoredScriptSource(this.lang, this.source, this.options);
            throw new IllegalArgumentException("illegal compiler options [" + this.options + "] specified");
        }
    }
}

