/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions.delete;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.protocol.xpack.watcher.DeleteWatchRequest;
import org.elasticsearch.protocol.xpack.watcher.DeleteWatchResponse;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;

public class TransportDeleteWatchAction
extends HandledTransportAction<DeleteWatchRequest, DeleteWatchResponse> {
    private final Client client;

    @Inject
    public TransportDeleteWatchAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super(settings, "cluster:admin/xpack/watcher/watch/delete", threadPool, transportService, actionFilters, indexNameExpressionResolver, DeleteWatchRequest::new);
        this.client = client;
    }

    protected void doExecute(DeleteWatchRequest request, ActionListener<DeleteWatchResponse> listener) {
        DeleteRequest deleteRequest = new DeleteRequest(".watches", "doc", request.getId());
        deleteRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"watcher", (ActionRequest)deleteRequest, (ActionListener)ActionListener.wrap(deleteResponse -> {
            boolean deleted = deleteResponse.getResult() == DocWriteResponse.Result.DELETED;
            DeleteWatchResponse response = new DeleteWatchResponse(deleteResponse.getId(), deleteResponse.getVersion(), deleted);
            listener.onResponse((Object)response);
        }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).delete(arg_0, arg_1));
    }
}

