/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logstash;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.template.TemplateUtils;
import org.elasticsearch.xpack.logstash.LogstashFeatureSet;

public class Logstash
extends Plugin
implements ActionPlugin {
    private static final String LOGSTASH_TEMPLATE_NAME = "logstash-index-template";
    private static final String TEMPLATE_VERSION_PATTERN = Pattern.quote("${logstash.template.version}");
    private final boolean enabled;
    private final boolean transportClientMode;

    public Logstash(Settings settings) {
        this.enabled = (Boolean)XPackSettings.LOGSTASH_ENABLED.get(settings);
        this.transportClientMode = XPackPlugin.transportClientMode((Settings)settings);
    }

    boolean isEnabled() {
        return this.enabled;
    }

    boolean isTransportClient() {
        return this.transportClientMode;
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(b -> XPackPlugin.bindFeatureSet((Binder)b, LogstashFeatureSet.class));
        return modules;
    }

    public UnaryOperator<Map<String, IndexTemplateMetaData>> getIndexTemplateMetaDataUpgrader() {
        return templates -> {
            TemplateUtils.loadTemplateIntoMap((String)"/logstash-index-template.json", (Map)templates, (String)LOGSTASH_TEMPLATE_NAME, (String)Version.CURRENT.toString(), (String)TEMPLATE_VERSION_PATTERN, (Logger)LogManager.getLogger(Logstash.class));
            return templates;
        };
    }
}

