/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ru;

import java.util.Collections;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import org.languagetool.rules.AdvancedWordRepeatRule;
import org.languagetool.rules.Example;

public class RussianWordRepeatRule
extends AdvancedWordRepeatRule {
    private static final Set<String> EXC_WORDS;
    private static final Pattern EXC_POS;
    private static final Pattern EXC_NONWORDS;

    public RussianWordRepeatRule(ResourceBundle messages) {
        super(messages);
        this.addExamplePair(Example.wrong((String)"\u0412\u0441\u0451 \u0441\u043c\u0435\u0448\u0430\u043b\u043e\u0441\u044c \u0432 <marker>\u0434\u043e\u043c\u0435 \u0434\u043e\u043c\u0435</marker> \u041e\u0431\u043b\u043e\u043d\u0441\u043a\u0438\u0445."), Example.fixed((String)"\u0412\u0441\u0451 \u0441\u043c\u0435\u0448\u0430\u043b\u043e\u0441\u044c \u0432 <marker>\u0434\u043e\u043c\u0435</marker> \u041e\u0431\u043b\u043e\u043d\u0441\u043a\u0438\u0445."));
    }

    public final String getId() {
        return "RU_WORD_REPEAT";
    }

    public final String getDescription() {
        return "\u041f\u043e\u0432\u0442\u043e\u0440 \u0441\u043b\u043e\u0432 \u0432 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u0438";
    }

    protected Set<String> getExcludedWordsPattern() {
        return EXC_WORDS;
    }

    protected Pattern getExcludedNonWordsPattern() {
        return EXC_NONWORDS;
    }

    protected Pattern getExcludedPos() {
        return EXC_POS;
    }

    public final String getMessage() {
        return "\u041f\u043e\u0432\u0442\u043e\u0440 \u0441\u043b\u043e\u0432 \u0432 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u0438";
    }

    public final String getShortMessage() {
        return "\u041f\u043e\u0432\u0442\u043e\u0440 \u0441\u043b\u043e\u0432 \u0432 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u0438";
    }

    static {
        HashSet<String> tempSet = new HashSet<String>();
        tempSet.add("\u043d\u0435");
        tempSet.add("\u043d\u0438");
        tempSet.add("\u0430");
        tempSet.add("\u043d\u0430");
        tempSet.add("\u0432");
        tempSet.add("\u043c\u0438\u043d\u0443\u0442\u0430");
        tempSet.add("\u0434\u0440\u0443\u0433");
        tempSet.add("\u0447\u0430\u0441");
        tempSet.add("\u0441\u0435\u043a\u0443\u043d\u0434\u0430");
        EXC_WORDS = Collections.unmodifiableSet(tempSet);
        EXC_POS = Pattern.compile("INTERJECTION|PRDC|PREP|CONJ|PARTICLE|PNN:.*");
        EXC_NONWORDS = Pattern.compile("&quot|&gt|&lt|&amp|[0-9].*|M*(D?C{0,3}|C[DM])(L?X{0,3}|X[LC])(V?I{0,3}|I[VX])$");
    }
}

