/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.parser;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.loomchild.maligna.coretypes.Alignment;
import net.loomchild.maligna.parser.Parser;
import net.loomchild.maligna.parser.TmxParseException;
import net.loomchild.maligna.util.bind.TmxMarshallerUnmarshaller;
import net.loomchild.maligna.util.bind.tmx.Body;
import net.loomchild.maligna.util.bind.tmx.Seg;
import net.loomchild.maligna.util.bind.tmx.Tmx;
import net.loomchild.maligna.util.bind.tmx.Tu;
import net.loomchild.maligna.util.bind.tmx.Tuv;

public class TmxParser
implements Parser {
    private Reader reader;
    private String sourceLanguageCode;
    private String targetLanguageCode;

    public TmxParser(Reader reader, String sourceLanguageCode, String targetLanguageCode) {
        this.reader = reader;
        this.sourceLanguageCode = sourceLanguageCode;
        this.targetLanguageCode = targetLanguageCode;
    }

    public TmxParser(Reader reader) {
        this.reader = reader;
    }

    @Override
    public List<Alignment> parse() {
        ArrayList<Alignment> alignmentList = new ArrayList<Alignment>();
        Tmx tmx = TmxMarshallerUnmarshaller.getInstance().unmarshal(this.reader);
        Body body = tmx.getBody();
        if (this.sourceLanguageCode == null && this.targetLanguageCode == null) {
            this.initLanguageCodes(body.getTu());
        }
        for (Tu tu : body.getTu()) {
            List<String> sourceSegmentList = this.createSegmentList(tu, this.sourceLanguageCode);
            List<String> targetSegmentList = this.createSegmentList(tu, this.targetLanguageCode);
            if (sourceSegmentList.size() <= 0 && targetSegmentList.size() <= 0) continue;
            Alignment alignment = new Alignment(sourceSegmentList, targetSegmentList);
            alignmentList.add(alignment);
        }
        return alignmentList;
    }

    private List<String> createSegmentList(Tu tu, String languageCode) {
        ArrayList<String> segmentList = new ArrayList<String>();
        for (Tuv tuv : tu.getTuv()) {
            if (!languageCode.equals(tuv.getLang())) continue;
            String segment = this.getSegment(tuv.getSeg());
            segmentList.add(segment);
        }
        if (segmentList.size() > 1) {
            throw new TmxParseException(languageCode + " variant count greater than 1");
        }
        return segmentList;
    }

    private String getSegment(Seg seg) {
        StringBuilder builder = new StringBuilder();
        for (Object object : seg.getContent()) {
            builder.append(object.toString());
        }
        return builder.toString();
    }

    private void initLanguageCodes(List<Tu> tuList) {
        Set<String> languageCodeSet = this.getLanguageCodeSet(tuList);
        if (languageCodeSet.size() != 2) {
            throw new TmxParseException("Document does not contain units exactly in 2 languages");
        }
        Object[] languageCodeArray = languageCodeSet.toArray(new String[0]);
        Arrays.sort(languageCodeArray);
        this.sourceLanguageCode = languageCodeArray[0];
        this.targetLanguageCode = languageCodeArray[1];
    }

    private Set<String> getLanguageCodeSet(List<Tu> tuList) {
        HashSet<String> languageCodeSet = new HashSet<String>();
        for (Tu tu : tuList) {
            for (Tuv tuv : tu.getTuv()) {
                languageCodeSet.add(tuv.getLang());
            }
        }
        return languageCodeSet;
    }
}

