/*
 * Decompiled with CFR 0.152.
 */
package io.github.eb4j.stardict;

import io.github.eb4j.stardict.DictionaryData;
import io.github.eb4j.stardict.IndexEntry;
import io.github.eb4j.stardict.StarDictDictionary;
import io.github.eb4j.stardict.StarDictInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;

public class StarDictFileDict
extends StarDictDictionary {
    private final RandomAccessFile dataFile;

    StarDictFileDict(StarDictInfo info, File dictFile, DictionaryData<IndexEntry> data, int cacheSize) throws FileNotFoundException {
        super(data, info, 64, cacheSize);
        this.dataFile = new RandomAccessFile(dictFile, "r");
    }

    @Override
    protected String readArticle(long start, int len) {
        String result = null;
        try {
            byte[] data = new byte[len];
            this.dataFile.seek(start);
            int readLen = this.dataFile.read(data);
            result = new String(data, 0, readLen, StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.dataFile.close();
    }
}

