/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.theme;

import java.awt.Color;
import java.io.IOException;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import org.omegat.gui.theme.DelegatingLookAndFeel;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.gui.UIDesignManager;

public class DefaultClassicTheme
extends DelegatingLookAndFeel {
    private static final String NAME = OStrings.getString("THEME_OMEGAT_CLASSIC_NAME");

    public static void loadPlugins() {
        UIManager.installLookAndFeel(NAME, DefaultClassicTheme.class.getName());
    }

    public static void unloadPlugins() {
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getID() {
        return "OmegaT";
    }

    @Override
    public String getDescription() {
        return OStrings.getString("THEME_OMEGAT_CLASSIC_DESCRIPTION");
    }

    @Override
    public UIDefaults getDefaults() {
        return DefaultClassicTheme.setDefaults(this.systemLookAndFeel.getDefaults());
    }

    public static UIDefaults setDefaults(UIDefaults defaults) {
        defaults.put("OmegaTStatusArea.border", new MatteBorder(1, 1, 1, 1, Color.BLACK));
        try {
            UIDesignManager.loadDefaultColors(defaults);
        }
        catch (IOException e) {
            Log.log(e);
        }
        UIManager.put("DockViewTitleBar.hide", DefaultClassicTheme.getIcon("minimize.gif"));
        UIManager.put("DockViewTitleBar.hide.rollover", DefaultClassicTheme.getIcon("minimize.rollover.gif"));
        UIManager.put("DockViewTitleBar.hide.pressed", DefaultClassicTheme.getIcon("minimize.pressed.gif"));
        UIManager.put("DockViewTitleBar.maximize", DefaultClassicTheme.getIcon("maximize.gif"));
        UIManager.put("DockViewTitleBar.maximize.rollover", DefaultClassicTheme.getIcon("maximize.rollover.gif"));
        UIManager.put("DockViewTitleBar.maximize.pressed", DefaultClassicTheme.getIcon("maximize.pressed.gif"));
        UIManager.put("DockViewTitleBar.restore", DefaultClassicTheme.getIcon("restore.gif"));
        UIManager.put("DockViewTitleBar.restore.rollover", DefaultClassicTheme.getIcon("restore.rollover.gif"));
        UIManager.put("DockViewTitleBar.restore.pressed", DefaultClassicTheme.getIcon("restore.pressed.gif"));
        UIManager.put("DockViewTitleBar.dock", DefaultClassicTheme.getIcon("restore.gif"));
        UIManager.put("DockViewTitleBar.dock.rollover", DefaultClassicTheme.getIcon("restore.rollover.gif"));
        UIManager.put("DockViewTitleBar.dock.pressed", DefaultClassicTheme.getIcon("restore.pressed.gif"));
        UIManager.put("DockViewTitleBar.float", DefaultClassicTheme.getIcon("undock.gif"));
        UIManager.put("DockViewTitleBar.float.rollover", DefaultClassicTheme.getIcon("undock.rollover.gif"));
        UIManager.put("DockViewTitleBar.float.pressed", DefaultClassicTheme.getIcon("undock.pressed.gif"));
        UIManager.put("DockViewTitleBar.attach", DefaultClassicTheme.getIcon("dock.gif"));
        UIManager.put("DockViewTitleBar.attach.rollover", DefaultClassicTheme.getIcon("dock.rollover.gif"));
        UIManager.put("DockViewTitleBar.attach.pressed", DefaultClassicTheme.getIcon("dock.pressed.gif"));
        UIManager.put("DockViewTitleBar.menu.hide", DefaultClassicTheme.getIcon("minimize.gif"));
        UIManager.put("DockViewTitleBar.menu.maximize", DefaultClassicTheme.getIcon("maximize.gif"));
        UIManager.put("DockViewTitleBar.menu.restore", DefaultClassicTheme.getIcon("restore.gif"));
        UIManager.put("DockViewTitleBar.menu.dock", DefaultClassicTheme.getIcon("restore.gif"));
        UIManager.put("DockViewTitleBar.menu.float", DefaultClassicTheme.getIcon("undock.gif"));
        UIManager.put("DockViewTitleBar.menu.attach", DefaultClassicTheme.getIcon("dock.gif"));
        UIManager.put("DockTabbedPane.menu.hide", DefaultClassicTheme.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.menu.maximize", DefaultClassicTheme.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.menu.float", DefaultClassicTheme.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.menu.closeAll", DefaultClassicTheme.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.menu.closeAllOther", DefaultClassicTheme.getIcon("empty.gif"));
        UIManager.put("DragControler.detachCursor", DefaultClassicTheme.getIcon("undock.gif").getImage());
        return defaults;
    }
}

