/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.mark;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.swing.text.JTextComponent;
import org.omegat.gui.editor.UnderlineFactory;

public class BidiPainter
extends UnderlineFactory.Underliner {
    protected final Color color;
    protected final int bidi;
    private static final int MARKER_HEIGHT = 6;
    private static final float STROKE_WIDTH = 1.0f;
    private static final BasicStroke BIDI_STROKE = new BasicStroke(1.0f);

    public BidiPainter(int b, Color c) {
        this.bidi = b;
        this.color = c;
    }

    @Override
    protected void paint(Graphics g, Rectangle rect, JTextComponent c) {
        g.setColor(this.color);
        int dir = this.bidi == 8234 || this.bidi == 8206 || this.bidi == 8237 ? -1 : 1;
        int y = rect.y;
        int x1 = rect.x;
        int x2 = rect.x + rect.width;
        Stroke oldStroke = ((Graphics2D)g).getStroke();
        ((Graphics2D)g).setStroke(BIDI_STROKE);
        Polygon p = new Polygon();
        switch (this.bidi) {
            case 8206: 
            case 8207: {
                p.addPoint(x1, y + 6);
                p.addPoint(x1, y);
                p.addPoint(x1 - dir * 6, y);
                p.addPoint(x1, y + 6);
                g.fillPolygon(p);
                g.drawPolygon(p);
                break;
            }
            case 8234: {
                p.addPoint(x1 + 1, y + 6);
                p.addPoint(x1 + 1, y);
                p.addPoint(x1 + 1 - dir * 6, y);
                p.addPoint(x1 + 1, y + 6);
                g.drawPolygon(p);
                g.drawLine(x2, y, x2, y + 6);
                g.drawLine(x1 + 1, y, x2, y);
                break;
            }
            case 8235: {
                p.addPoint(x2 + 1, y + 6);
                p.addPoint(x2 + 1, y);
                p.addPoint(x2 + 1 - dir * 6, y);
                p.addPoint(x2 + 1, y + 6);
                g.drawPolygon(p);
                g.drawLine(x1, y, x1, y + 6);
                g.drawLine(x1, y, x2 + 1, y);
                break;
            }
            case 8237: {
                p.addPoint(x1 + 1, y + 6);
                p.addPoint(x1 + 1 - dir * 6, y + 6);
                p.addPoint(x1 + 1, y);
                g.fillPolygon(p);
                g.drawPolygon(p);
                g.drawLine(x2, y, x2, y + 6);
                g.drawLine(x1 + 1, y, x2, y);
                break;
            }
            case 8238: {
                p.addPoint(x2 + 1, y + 6);
                p.addPoint(x2 + 1 - dir * 6 / 2, y + 6);
                p.addPoint(x2 + 1, y);
                g.fillPolygon(p);
                g.drawPolygon(p);
                g.drawLine(x1, y, x1, y + 6);
                g.drawLine(x1, y, x2 + 1, y);
                break;
            }
        }
        ((Graphics2D)g).setStroke(oldStroke);
    }
}

