/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml.xliff;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.omegat.filters3.xml.xliff.XLIFFOptions;
import org.omegat.util.OStrings;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class EditXLIFFOptionsDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private final XLIFFOptions options;
    private int returnStatus = 0;
    private ButtonGroup buttonGroup1;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JCheckBox changeToNeedsReviewCB;
    private JCheckBox compatibility26CB;
    private Box.Filler filler1;
    private JCheckBox forceshortcut2fCB;
    private JCheckBox ignoreTypeForBptTagsCB;
    private JCheckBox ignoreTypeForPhTagsCB;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JButton okButton;
    private JRadioButton prevAndNextRB;
    private JRadioButton transIDRB;
    private JRadioButton transResnameRB;

    public EditXLIFFOptionsDialog(Window parent, Map<String, String> config) {
        super(parent);
        this.setModal(true);
        this.options = new XLIFFOptions(new TreeMap<String, String>(config));
        this.initComponents();
        this.compatibility26CB.setSelected(this.options.get26Compatibility());
        this.forceshortcut2fCB.setSelected(this.options.getForceShortcutToF());
        this.ignoreTypeForPhTagsCB.setSelected(this.options.getIgnoreTypeForPhTags());
        this.ignoreTypeForBptTagsCB.setSelected(this.options.getIgnoreTypeForBptTags());
        this.prevAndNextRB.setSelected(this.options.getAltTransIDType() == XLIFFOptions.ID_TYPE.CONTEXT);
        this.transIDRB.setSelected(this.options.getAltTransIDType() == XLIFFOptions.ID_TYPE.ELEMENT_ID);
        this.transResnameRB.setSelected(this.options.getAltTransIDType() == XLIFFOptions.ID_TYPE.RESNAME_ATTR);
        this.changeToNeedsReviewCB.setSelected(this.options.getChangeStateToNeedsReviewTranslation());
        StaticUIUtils.setEscapeAction(this, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditXLIFFOptionsDialog.this.doClose(0);
            }
        });
        this.setLocationRelativeTo(parent);
    }

    public XLIFFOptions getOptions() {
        return this.options;
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.compatibility26CB = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.prevAndNextRB = new JRadioButton();
        this.transIDRB = new JRadioButton();
        this.transResnameRB = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.filler1 = new Box.Filler(new Dimension(30, 0), new Dimension(30, 0), new Dimension(30, Short.MAX_VALUE));
        this.jLabel4 = new JLabel();
        this.jLabel1 = new JLabel();
        this.forceshortcut2fCB = new JCheckBox();
        this.ignoreTypeForPhTagsCB = new JCheckBox();
        this.ignoreTypeForBptTagsCB = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.changeToNeedsReviewCB = new JCheckBox();
        this.setTitle(OStrings.getString("XLIFF_OPTIONS_TITLE"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EditXLIFFOptionsDialog.this.closeDialog(evt);
            }
        });
        this.buttonPanel.setMinimumSize(new Dimension(143, 33));
        this.buttonPanel.setLayout(new FlowLayout(2));
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditXLIFFOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditXLIFFOptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.jPanel1.setMinimumSize(new Dimension(167, 121));
        this.jPanel1.setLayout(new GridLayout(0, 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)OStrings.getString("XLIFF_OPTIONS_LABEL"));
        this.jPanel1.add(this.jLabel2);
        Mnemonics.setLocalizedText((AbstractButton)this.compatibility26CB, (String)OStrings.getString("XLIFF_OPTIONS_26"));
        this.jPanel1.add(this.compatibility26CB);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)OStrings.getString("XLIFF_OPTIONS_ID"));
        this.jPanel1.add(this.jLabel3);
        this.buttonGroup1.add(this.prevAndNextRB);
        Mnemonics.setLocalizedText((AbstractButton)this.prevAndNextRB, (String)OStrings.getString("XLIFF_OPTIONS_ID_NEXT_PREV"));
        this.jPanel1.add(this.prevAndNextRB);
        this.buttonGroup1.add(this.transIDRB);
        Mnemonics.setLocalizedText((AbstractButton)this.transIDRB, (String)OStrings.getString("XLIFF_OPTIONS_ID_TRANS_UNIT"));
        this.jPanel1.add(this.transIDRB);
        this.buttonGroup1.add(this.transResnameRB);
        Mnemonics.setLocalizedText((AbstractButton)this.transResnameRB, (String)OStrings.getString("XLIFF_OPTIONS_RESNAME_TRANS_UNIT"));
        this.jPanel1.add(this.transResnameRB);
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel2.add((Component)this.filler1, "West");
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)OStrings.getString("XLIFF_OPTIONS_RESNAME_EXPLANATION"));
        this.jPanel2.add((Component)this.jLabel4, "Center");
        this.jPanel1.add(this.jPanel2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)OStrings.getString("XLIFF_OPTIONS_36_ONLY"));
        this.jPanel1.add(this.jLabel1);
        Mnemonics.setLocalizedText((AbstractButton)this.forceshortcut2fCB, (String)OStrings.getString("XLIFF_OPTIONS_FORCE2F"));
        this.jPanel1.add(this.forceshortcut2fCB);
        Mnemonics.setLocalizedText((AbstractButton)this.ignoreTypeForPhTagsCB, (String)OStrings.getString("XLIFF_OPTIONS_IGNORE4PH"));
        this.jPanel1.add(this.ignoreTypeForPhTagsCB);
        Mnemonics.setLocalizedText((AbstractButton)this.ignoreTypeForBptTagsCB, (String)OStrings.getString("XLIFF_OPTIONS_IGNORE4BPT"));
        this.jPanel1.add(this.ignoreTypeForBptTagsCB);
        ResourceBundle bundle = ResourceBundle.getBundle("org/omegat/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)bundle.getString("XLIFF_OPTIONS_STATE"));
        this.jPanel1.add(this.jLabel5);
        Mnemonics.setLocalizedText((AbstractButton)this.changeToNeedsReviewCB, (String)bundle.getString("XLIFF_OPTION_CHANGE_TARGET_STATE_NEEDS_REVIEW_T9N"));
        this.jPanel1.add(this.changeToNeedsReviewCB);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.options.set26Compatibility(this.compatibility26CB.isSelected());
        this.options.setForceShortcutToF(this.forceshortcut2fCB.isSelected());
        this.options.setIgnoreTypeForPhTags(this.ignoreTypeForPhTagsCB.isSelected());
        this.options.setIgnoreTypeForBptTags(this.ignoreTypeForBptTagsCB.isSelected());
        this.options.setStateToReview(this.changeToNeedsReviewCB.isSelected());
        if (this.prevAndNextRB.isSelected()) {
            this.options.setAltTransIDType(XLIFFOptions.ID_TYPE.CONTEXT);
        } else if (this.transIDRB.isSelected()) {
            this.options.setAltTransIDType(XLIFFOptions.ID_TYPE.ELEMENT_ID);
        } else if (this.transResnameRB.isSelected()) {
            this.options.setAltTransIDType(XLIFFOptions.ID_TYPE.RESNAME_ATTR);
        }
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

