/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.util.Objects;
import org.omegat.util.StringUtil;

public class EntryKey
implements Comparable<EntryKey> {
    public final String file;
    public final String sourceText;
    public final String id;
    public final String prev;
    public final String next;
    public final String path;
    private static boolean ignoreFileContext = false;

    public EntryKey(String file, String sourceText, String id, String prev, String next, String path) {
        this.file = file;
        this.sourceText = sourceText;
        this.id = id;
        this.prev = prev;
        this.next = next;
        this.path = path;
    }

    public int hashCode() {
        int hash = this.sourceText.hashCode();
        if (!ignoreFileContext && this.file != null) {
            hash += this.file.hashCode();
        }
        if (this.id != null) {
            hash += this.id.hashCode();
        }
        if (this.prev != null) {
            hash += this.prev.hashCode();
        }
        if (this.next != null) {
            hash += this.next.hashCode();
        }
        if (this.path != null) {
            hash += this.path.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EntryKey)) {
            return false;
        }
        EntryKey o = (EntryKey)obj;
        return Objects.equals(this.sourceText, o.sourceText) && (ignoreFileContext || Objects.equals(this.file, o.file)) && Objects.equals(this.id, o.id) && Objects.equals(this.prev, o.prev) && Objects.equals(this.next, o.next) && Objects.equals(this.path, o.path);
    }

    @Override
    public int compareTo(EntryKey o) {
        int c;
        int n = c = ignoreFileContext ? 0 : StringUtil.compareToWithNulls(this.file, o.file);
        if (c == 0) {
            c = StringUtil.compareToWithNulls(this.id, o.id);
        }
        if (c == 0) {
            c = StringUtil.compareToWithNulls(this.sourceText, o.sourceText);
        }
        if (c == 0) {
            c = StringUtil.compareToWithNulls(this.prev, o.prev);
        }
        if (c == 0) {
            c = StringUtil.compareToWithNulls(this.next, o.next);
        }
        if (c == 0) {
            c = StringUtil.compareToWithNulls(this.path, o.path);
        }
        return c;
    }

    public String toString() {
        return "[file:" + this.file + ", id=" + this.id + ", path=" + this.path + ", source='" + this.sourceText + "', prev='" + this.prev + "', next='" + this.next + "']";
    }

    public static void setIgnoreFileContext(boolean ignore) {
        ignoreFileContext = ignore;
    }

    public static boolean isIgnoreFileContext() {
        return ignoreFileContext;
    }
}

