/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.pipeline;

import gnu.xml.pipeline.EventConsumer;
import gnu.xml.pipeline.EventFilter;
import gnu.xml.pipeline.TeeConsumer;
import gnu.xml.pipeline.TextConsumer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.StringTokenizer;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class PipelineFactory {
    private static final String[][] builtinStages = new String[][]{{"dom", "gnu.xml.dom.Consumer"}, {"nsfix", "gnu.xml.pipeline.NSFilter"}, {"null", "gnu.xml.pipeline.EventFilter"}, {"server", "gnu.xml.pipeline.CallFilter"}, {"tee", "gnu.xml.pipeline.TeeConsumer"}, {"validate", "gnu.xml.pipeline.ValidationConsumer"}, {"wf", "gnu.xml.pipeline.WellFormednessFilter"}, {"xinclude", "gnu.xml.pipeline.XIncludeFilter"}, {"xslt", "gnu.xml.pipeline.XsltFilter"}};
    private String[] tokens;
    private int index;

    public static EventConsumer createPipeline(String description) throws IOException {
        return PipelineFactory.createPipeline(description, null);
    }

    public static EventConsumer createPipeline(String description, EventConsumer next) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(description);
        String[] tokens = new String[tokenizer.countTokens()];
        int i = 0;
        while (i < tokens.length) {
            tokens[i] = tokenizer.nextToken();
            ++i;
        }
        PipelineFactory factory = new PipelineFactory();
        Pipeline pipeline = factory.parsePipeline(tokens, next);
        return pipeline.createPipeline();
    }

    public static EventConsumer createPipeline(String[] tokens, EventConsumer next) throws IOException {
        PipelineFactory factory = new PipelineFactory();
        Pipeline pipeline = factory.parsePipeline(tokens, next);
        return pipeline.createPipeline();
    }

    private final Pipeline parsePipeline(String[] toks, EventConsumer next) {
        this.tokens = toks;
        this.index = 0;
        Pipeline retval = this.parsePipeline(next);
        if (this.index != toks.length) {
            throw new ArrayIndexOutOfBoundsException("extra token: " + this.tokens[this.index]);
        }
        return retval;
    }

    private final Pipeline parsePipeline(EventConsumer next) {
        Pipeline retval = new Pipeline(this.parseStage());
        if (this.index > this.tokens.length - 2 || !"|".equals(this.tokens[this.index])) {
            retval.next = next;
            return retval;
        }
        ++this.index;
        retval.rest = this.parsePipeline(next);
        return retval;
    }

    private final Stage parseStage() {
        Stage retval = new Stage(this.tokens[this.index++]);
        if (this.index > this.tokens.length - 2 || !"(".equals(this.tokens[this.index])) {
            return retval;
        }
        ++this.index;
        retval.param = this.parsePipeline(null);
        if (this.index >= this.tokens.length) {
            throw new ArrayIndexOutOfBoundsException("missing right paren");
        }
        if (!")".equals(this.tokens[this.index++])) {
            throw new ArrayIndexOutOfBoundsException("required right paren, not: " + this.tokens[this.index - 1]);
        }
        return retval;
    }

    private PipelineFactory() {
    }

    private static class Pipeline {
        Stage stage;
        Pipeline rest;
        EventConsumer next;

        public String toString() {
            if (this.rest == null && this.next == null) {
                return this.stage.toString();
            }
            if (this.rest != null) {
                return this.stage + " | " + this.rest;
            }
            throw new IllegalArgumentException("next");
        }

        EventConsumer createPipeline() throws IOException {
            if (this.next == null) {
                this.next = this.rest == null ? this.stage.createStage(null) : this.stage.createStage(this.rest.createPipeline());
            }
            return this.next;
        }

        Pipeline(Stage s) {
            this.stage = s;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class Stage {
        String id;
        Pipeline param;
        static /* synthetic */ Class class$gnu$xml$pipeline$EventConsumer;
        static /* synthetic */ Class class$java$lang$String;

        public String toString() {
            if (this.param == null) {
                return this.id;
            }
            return this.id + " ( " + this.param + " )";
        }

        private final void fail(String message) throws IOException {
            throw new IOException("in '" + this.id + "' stage of pipeline, " + message);
        }

        EventConsumer createStage(EventConsumer next) throws IOException {
            String name = this.id;
            int i = 0;
            while (i < builtinStages.length) {
                if (this.id.equals(builtinStages[i][0])) {
                    name = builtinStages[i][1];
                    break;
                }
                ++i;
            }
            if ("write".equals(name) || "xhtml".equals(name)) {
                String filename;
                boolean isXhtml = "xhtml".equals(name);
                OutputStream out = null;
                if (this.param == null) {
                    this.fail("parameter is required");
                }
                if ("stdout".equals(filename = this.param.toString())) {
                    out = System.out;
                } else if ("stderr".equals(filename)) {
                    out = System.err;
                } else {
                    File f = new File(filename);
                    if (f.exists()) {
                        this.fail("file already exists: " + f.getName());
                    }
                    out = new FileOutputStream(f);
                }
                TextConsumer consumer = !isXhtml ? new TextConsumer(out) : new TextConsumer((Writer)new OutputStreamWriter(out, "8859_1"), true);
                consumer.setPrettyPrinting(true);
                if (next == null) {
                    return consumer;
                }
                return new TeeConsumer(consumer, next);
            }
            String msg = null;
            try {
                Class klass = Class.forName(name);
                Class[] argTypes = null;
                Constructor constructor = null;
                boolean filter = false;
                Object[] params = null;
                Object obj = null;
                if (next != null) {
                    if (this.param == null) {
                        argTypes = new Class[1];
                        Class clazz = class$gnu$xml$pipeline$EventConsumer;
                        if (clazz == null) {
                            clazz = class$gnu$xml$pipeline$EventConsumer = Stage.class("[Lgnu.xml.pipeline.EventConsumer;", false);
                        }
                        argTypes[0] = clazz;
                        params = new Object[]{next};
                        msg = "no-param filter";
                    } else {
                        Class clazz;
                        argTypes = new Class[2];
                        Class clazz2 = class$java$lang$String;
                        if (clazz2 == null) {
                            clazz2 = argTypes[0] = (class$java$lang$String = Stage.class("[Ljava.lang.String;", false));
                        }
                        if ((clazz = class$gnu$xml$pipeline$EventConsumer) == null) {
                            clazz = class$gnu$xml$pipeline$EventConsumer = Stage.class("[Lgnu.xml.pipeline.EventConsumer;", false);
                        }
                        argTypes[1] = clazz;
                        params = new Object[]{this.param.toString(), next};
                        msg = "one-param filter";
                    }
                    try {
                        constructor = klass.getConstructor(argTypes);
                    }
                    catch (NoSuchMethodException e) {
                        filter = true;
                        msg = msg + " built from ";
                    }
                }
                if (constructor == null) {
                    String tmp;
                    if (this.param == null) {
                        argTypes = new Class[]{};
                        params = new Object[]{};
                        tmp = "no-param terminus";
                    } else {
                        argTypes = new Class[1];
                        Class clazz = class$java$lang$String;
                        if (clazz == null) {
                            clazz = class$java$lang$String = Stage.class("[Ljava.lang.String;", false);
                        }
                        argTypes[0] = clazz;
                        params = new Object[]{this.param.toString()};
                        tmp = "one-param terminus";
                    }
                    msg = msg == null ? tmp : msg + tmp;
                    constructor = klass.getConstructor(argTypes);
                }
                if ((obj = constructor.newInstance(params)) instanceof EventConsumer) {
                    if (filter) {
                        return new TeeConsumer((EventConsumer)obj, next);
                    }
                    return (EventConsumer)obj;
                }
                EventFilter retval = new EventFilter();
                boolean updated = false;
                if (obj instanceof ContentHandler) {
                    retval.setContentHandler((ContentHandler)obj);
                    updated = true;
                }
                if (obj instanceof DTDHandler) {
                    retval.setDTDHandler((DTDHandler)obj);
                    updated = true;
                }
                if (obj instanceof LexicalHandler) {
                    retval.setProperty("http://xml.org/sax/properties/lexical-handler", obj);
                    updated = true;
                }
                if (obj instanceof DeclHandler) {
                    retval.setProperty("http://xml.org/sax/properties/declaration-handler", obj);
                    updated = true;
                }
                if (!updated) {
                    this.fail("class is neither Consumer nor Handler");
                }
                if (filter) {
                    return new TeeConsumer(retval, next);
                }
                return retval;
            }
            catch (IOException e) {
                throw e;
            }
            catch (NoSuchMethodException e) {
                this.fail(name + " constructor missing -- " + msg);
            }
            catch (ClassNotFoundException e) {
                this.fail(name + " class not found");
            }
            catch (Exception e) {
                this.fail("stage not available: " + e.getMessage());
            }
            return null;
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError().initCause(classNotFoundException);
            }
        }

        Stage(String name) {
            this.id = name;
        }
    }
}

