/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.ComboPopup;

public class BasicComboPopup
extends JPopupMenu
implements ComboPopup {
    protected static final int SCROLL_DOWN = 1;
    protected static final int SCROLL_UP = 0;
    protected Timer autoscrollTimer;
    protected JComboBox comboBox;
    protected boolean hasEntered;
    protected boolean isAutoScrolling;
    protected ItemListener itemListener;
    protected KeyListener keyListener;
    protected JList list;
    protected ListDataListener listDataListener;
    protected MouseListener listMouseListener;
    protected MouseMotionListener listMouseMotionListener;
    protected ListSelectionListener listSelectionListener;
    protected MouseListener mouseListener;
    protected MouseMotionListener mouseMotionListener;
    protected PropertyChangeListener propertyChangeListener;
    protected int scrollDirection;
    protected JScrollPane scroller;
    protected boolean valueIsAdjusting;

    public void show() {
        Rectangle cbBounds = this.comboBox.getBounds();
        int popupHeight = this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount());
        this.list.setPreferredSize(new Dimension(cbBounds.width, popupHeight));
        Insets insets1 = this.getInsets();
        Insets insets2 = this.scroller.getInsets();
        super.setPopupSize(cbBounds.width, popupHeight + insets1.top + insets1.bottom + insets2.top + insets2.bottom);
        if (this.comboBox.getSelectedIndex() != -1) {
            this.list.setSelectedIndex(this.comboBox.getSelectedIndex());
        }
        JScrollBar scrollbar = this.scroller.getVerticalScrollBar();
        int selectedIndex = this.comboBox.getSelectedIndex();
        if (selectedIndex > this.comboBox.getMaximumRowCount()) {
            scrollbar.setValue(this.getPopupHeightForRowCount(selectedIndex));
        }
        super.show(this.comboBox, 0, cbBounds.height);
    }

    public void hide() {
        super.setVisible(false);
    }

    public JList getList() {
        return this.list;
    }

    public MouseListener getMouseListener() {
        return this.mouseListener;
    }

    public MouseMotionListener getMouseMotionListener() {
        return this.mouseMotionListener;
    }

    public KeyListener getKeyListener() {
        return this.keyListener;
    }

    public void uninstallingUI() {
        this.uninstallComboBoxModelListeners(this.comboBox.getModel());
        this.uninstallListeners();
        this.uninstallKeyboardActions();
    }

    protected void uninstallComboBoxModelListeners(ComboBoxModel model) {
        model.removeListDataListener(this.listDataListener);
    }

    protected void uninstallKeyboardActions() {
    }

    protected void firePopupMenuWillBecomeVisible() {
        PopupMenuListener[] ll = this.comboBox.getPopupMenuListeners();
        int i = 0;
        while (i < ll.length) {
            ll[i].popupMenuWillBecomeVisible(new PopupMenuEvent(this.comboBox));
            ++i;
        }
    }

    protected void firePopupMenuWillBecomeInvisible() {
        PopupMenuListener[] ll = this.comboBox.getPopupMenuListeners();
        int i = 0;
        while (i < ll.length) {
            ll[i].popupMenuWillBecomeInvisible(new PopupMenuEvent(this.comboBox));
            ++i;
        }
    }

    protected void firePopupMenuCanceled() {
        PopupMenuListener[] ll = this.comboBox.getPopupMenuListeners();
        int i = 0;
        while (i < ll.length) {
            ll[i].popupMenuCanceled(new PopupMenuEvent(this.comboBox));
            ++i;
        }
    }

    protected MouseListener createMouseListener() {
        return new InvocationMouseHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new InvocationMouseMotionHandler();
    }

    protected KeyListener createKeyListener() {
        return new InvocationKeyHandler();
    }

    protected ListSelectionListener createListSelectionListener() {
        return new ListSelectionHandler();
    }

    protected ListDataListener createListDataListener() {
        return null;
    }

    protected MouseListener createListMouseListener() {
        return new ListMouseHandler();
    }

    protected MouseMotionListener createListMouseMotionListener() {
        return new ListMouseMotionHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected ItemListener createItemListener() {
        return new ItemHandler();
    }

    protected JList createList() {
        JList l = new JList(this.comboBox.getModel());
        l.setSelectionMode(1);
        return l;
    }

    protected void configureList() {
        this.list.setModel(this.comboBox.getModel());
        this.list.setVisibleRowCount(this.comboBox.getMaximumRowCount());
        this.installListListeners();
    }

    protected void installListListeners() {
        this.listMouseListener = this.createListMouseListener();
        this.list.addMouseListener(this.listMouseListener);
        this.listMouseMotionListener = this.createListMouseMotionListener();
        this.list.addMouseMotionListener(this.listMouseMotionListener);
        this.listSelectionListener = this.createListSelectionListener();
        this.list.addListSelectionListener(this.listSelectionListener);
    }

    protected JScrollPane createScroller() {
        return new JScrollPane();
    }

    protected void configureScroller() {
        this.scroller.getViewport().setView(this.list);
        this.scroller.setHorizontalScrollBarPolicy(31);
    }

    protected void configurePopup() {
        this.list = this.createList();
        ((JLabel)((Object)this.list.getCellRenderer())).setHorizontalAlignment(2);
        this.configureList();
        this.scroller = this.createScroller();
        this.configureScroller();
        super.add(this.scroller);
    }

    protected void installComboBoxListeners() {
        this.mouseListener = this.createMouseListener();
        this.comboBox.addMouseListener(this.mouseListener);
        this.mouseMotionListener = this.createMouseMotionListener();
        this.comboBox.addMouseMotionListener(this.mouseMotionListener);
        this.itemListener = this.createItemListener();
        this.comboBox.addItemListener(this.itemListener);
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void installComboBoxModelListeners(ComboBoxModel model) {
        this.listDataListener = this.createListDataListener();
        this.comboBox.getModel().addListDataListener(this.listDataListener);
    }

    protected void installKeyboardActions() {
    }

    public boolean isFocusTraversable() {
        return false;
    }

    protected void startAutoScrolling(int direction) {
        this.isAutoScrolling = true;
        if (direction == 0) {
            this.autoScrollUp();
        } else {
            this.autoScrollDown();
        }
    }

    protected void stopAutoScrolling() {
        this.isAutoScrolling = false;
    }

    protected void autoScrollUp() {
        JScrollBar scrollbar = this.scroller.getVerticalScrollBar();
        int scrollToNext = this.list.getScrollableUnitIncrement(super.getBounds(), 1, 0);
        scrollbar.setValue(scrollbar.getValue() - scrollToNext);
        if (this.list.getSelectedIndex() != 0) {
            this.list.setSelectedIndex(this.list.getSelectedIndex() - 1);
        }
    }

    protected void autoScrollDown() {
        JScrollBar scrollbar = this.scroller.getVerticalScrollBar();
        int scrollToNext = this.list.getScrollableUnitIncrement(super.getBounds(), 1, 1);
        scrollbar.setValue(scrollbar.getValue() + scrollToNext);
        if (this.list.getSelectedIndex() + 1 != this.comboBox.getItemCount()) {
            this.list.setSelectedIndex(this.list.getSelectedIndex() + 1);
        }
    }

    protected void delegateFocus(MouseEvent e) {
    }

    protected void togglePopup() {
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    protected MouseEvent convertMouseEvent(MouseEvent e) {
        return null;
    }

    protected int getPopupHeightForRowCount(int maxRowCount) {
        int totalHeight = 0;
        ListCellRenderer rend = this.list.getCellRenderer();
        if (this.comboBox.getItemCount() < maxRowCount) {
            maxRowCount = this.comboBox.getItemCount();
        }
        int i = 0;
        while (i < maxRowCount) {
            Component comp = rend.getListCellRendererComponent(this.list, this.comboBox.getModel().getElementAt(i), -1, false, false);
            Dimension dim = comp.getPreferredSize();
            totalHeight += dim.height;
            ++i;
        }
        return totalHeight;
    }

    protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
        return new Rectangle(px, py, pw, ph);
    }

    protected void updateListBoxSelectionForEvent(MouseEvent anEvent, boolean shouldScroll) {
        int index = this.list.locationToIndex(anEvent.getPoint());
        if (index >= 0) {
            this.list.setSelectedIndex(index);
        }
    }

    private final void uninstallListeners() {
        this.uninstallListListeners();
        this.uninstallComboBoxListeners();
        this.uninstallComboBoxModelListeners(this.comboBox.getModel());
    }

    private final void uninstallListListeners() {
        this.list.removeMouseListener(this.listMouseListener);
        this.listMouseListener = null;
        this.list.removeMouseMotionListener(this.listMouseMotionListener);
        this.listMouseMotionListener = null;
    }

    private final void uninstallComboBoxListeners() {
        this.comboBox.removeMouseListener(this.mouseListener);
        this.mouseListener = null;
        this.comboBox.removeMouseMotionListener(this.mouseMotionListener);
        this.mouseMotionListener = null;
        this.comboBox.removeItemListener(this.itemListener);
        this.itemListener = null;
        this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    public BasicComboPopup(JComboBox comboBox) {
        this.comboBox = comboBox;
        this.installComboBoxListeners();
        this.configurePopup();
        this.setLightWeightPopupEnabled(comboBox.isLightWeightPopupEnabled());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class InvocationMouseHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (BasicComboPopup.this.comboBox.isEnabled()) {
                BasicComboPopup.this.togglePopup();
            }
        }

        public void mouseReleased(MouseEvent e) {
            int y;
            int x;
            Component src = (Component)e.getSource();
            Component releasedComponent = SwingUtilities.getDeepestComponentAt(src, x = e.getX(), y = e.getY());
            if (!(releasedComponent instanceof JComboBox)) {
                BasicComboPopup.this.comboBox.setSelectedIndex(BasicComboPopup.this.list.getSelectedIndex());
                if (BasicComboPopup.this.isAutoScrolling) {
                    BasicComboPopup.this.stopAutoScrolling();
                }
                BasicComboPopup.this.hide();
            }
        }

        protected InvocationMouseHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class InvocationMouseMotionHandler
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent e) {
            if (BasicComboPopup.this.isVisible()) {
                int cbHeight = (int)BasicComboPopup.this.comboBox.getPreferredSize().getHeight();
                int popupHeight = BasicComboPopup.this.getSize().height;
                if (e.getY() > cbHeight && e.getY() - cbHeight < popupHeight) {
                    int index = BasicComboPopup.this.list.locationToIndex(new Point(e.getX(), e.getY() - cbHeight));
                    int firstVisibleIndex = BasicComboPopup.this.list.getFirstVisibleIndex();
                    if (firstVisibleIndex != 0) {
                        index += firstVisibleIndex + 1;
                    }
                    BasicComboPopup.this.list.setSelectedIndex(index);
                } else {
                    boolean movingDown;
                    boolean bl = false;
                    if (e.getY() < cbHeight) {
                        bl = true;
                    }
                    boolean movingUP = bl;
                    boolean bl2 = false;
                    if (e.getY() > cbHeight) {
                        bl2 = movingDown = true;
                    }
                    if (movingUP) {
                        BasicComboPopup.this.scrollDirection = 0;
                        BasicComboPopup.this.startAutoScrolling(0);
                    } else if (movingDown) {
                        BasicComboPopup.this.scrollDirection = 1;
                        BasicComboPopup.this.startAutoScrolling(1);
                    }
                }
            }
        }

        protected InvocationMouseMotionHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class InvocationKeyHandler
    extends KeyAdapter {
        public void keyReleased(KeyEvent e) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ListSelectionHandler
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
        }

        protected ListSelectionHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ListMouseHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent anEvent) {
            int index = BasicComboPopup.this.list.locationToIndex(anEvent.getPoint());
            if (index >= 0) {
                BasicComboPopup.this.comboBox.setSelectedIndex(index);
            }
            BasicComboPopup.this.hide();
        }

        protected ListMouseHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ListMouseMotionHandler
    extends MouseMotionAdapter {
        public void mouseMoved(MouseEvent anEvent) {
            BasicComboPopup.this.updateListBoxSelectionForEvent(anEvent, false);
        }

        protected ListMouseMotionHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("renderer")) {
                BasicComboPopup.this.list.setCellRenderer((ListCellRenderer)e.getNewValue());
                BasicComboPopup.this.revalidate();
                BasicComboPopup.this.repaint();
            }
            if (e.getPropertyName().equals("dataModel")) {
                BasicComboPopup.this.list.setModel((ComboBoxModel)e.getNewValue());
                BasicComboPopup.this.revalidate();
                BasicComboPopup.this.repaint();
            }
        }

        protected PropertyChangeHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ItemHandler
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
        }

        protected ItemHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ListDataHandler
    implements ListDataListener {
        public void contentsChanged(ListDataEvent e) {
        }

        public void intervalAdded(ListDataEvent e) {
        }

        public void intervalRemoved(ListDataEvent e) {
        }
    }
}

